/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.framework.screendef.customize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.NoRemoveIterator;
import org.maskat.framework.screendef.customize.ComponentPluginConfig;
import org.maskat.framework.screendef.customize.CustCompPropDescKey;
import org.maskat.framework.screendef.customize.IComponentPluginConfig;
import org.maskat.framework.screendef.customize.IContentFactory;
import org.maskat.framework.screendef.customize.IPluginComponentDef;
import org.maskat.framework.screendef.customize.PluginComponentDef;
import org.maskat.framework.screendef.customize.PluginContainerDef;
import org.maskat.framework.screendef.customize.PluginDefProxy;
import org.maskat.framework.screendef.customize.PluginDefUnavailableException;
import org.maskat.framework.screendef.customize.PropertyPluginConfig;
import org.maskat.ide.MaskatIDEPlugin;
import org.maskat.ide.property.descriptor.EventPropertyDescriptor;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;

public class PluginDefFactory {
    private static final String DEFAULT_PREFIX = "extend";
    private static Map propDescriptors = new HashMap();
    private static Map pluginConfigs = null;

    private static Map getPluginConfigs() {
        if (pluginConfigs == null) {
            PluginDefFactory.init();
        }
        return pluginConfigs;
    }

    private static void init() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.maskat.ide.gef", "customizecomponents");
        IExtension[] extensions = ep.getExtensions();
        pluginConfigs = new HashMap();
        int i = 0;
        while (i < extensions.length) {
            IExtension ex = extensions[i];
            IConfigurationElement[] configEles = ex.getConfigurationElements();
            int j = 0;
            while (j < configEles.length) {
                IConfigurationElement element = configEles[j];
                if (element.getName().equals("component")) {
                    PluginDefFactory.registerPluginDefs(element, ex.getNamespace());
                }
                ++j;
            }
            ++i;
        }
    }

    private static void registerPluginDefs(IConfigurationElement element, String extensionNamespace) {
        IConfigurationElement[] children;
        ComponentPluginConfig config = new ComponentPluginConfig();
        String componentNodeName = element.getAttribute("name");
        config.defineNodeName(componentNodeName);
        config.defineNamespace(element.getAttribute("namespace"));
        config.defineIsContainer(element.getAttribute("isContainer"));
        config.definePrefix(element.getAttribute("prefix"));
        try {
            children = element.getChildren("contentFactory");
            if (children.length == 1) {
                config.defineContentFactory((IContentFactory)children[0].createExecutableExtension("class"));
            }
        }
        catch (CoreException e) {
            MaskatIDEPlugin.getDefault().getLog().log(e.getStatus());
        }
        children = element.getChildren("property");
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            PropertyPluginConfig propConfig = new PropertyPluginConfig(child.getAttribute("name"), child.getAttribute("type"));
            config.defineProperty(propConfig);
            PluginDefFactory.dealPropertyConfig(propConfig, componentNodeName, extensionNamespace);
            ++i;
        }
        pluginConfigs.put(componentNodeName, config);
    }

    private static void dealPropertyConfig(PropertyPluginConfig propConfig, String componentNodeName, String extensionNamespace) {
        String propertyName = propConfig.getName();
        CustCompPropDescKey propDescID = new CustCompPropDescKey(componentNodeName, propertyName);
        String type = propConfig.getType();
        Object descriptor = null;
        if (type.equals("readonly")) {
            descriptor = new PropertyDescriptor((Object)propDescID, propertyName);
        }
        if (type.equals("maskattext")) {
            descriptor = new MaskatTextPropertyDescriptor(propDescID, propertyName);
        }
        if (type.equals("event")) {
            descriptor = new EventPropertyDescriptor(propDescID, propertyName);
        }
        if (descriptor == null) {
            MaskatIDEPlugin.getDefault().getLog().log((IStatus)new Status(4, extensionNamespace, 4, "The 'type' attribute defined for the property(" + propertyName + ") of component (" + componentNodeName + ") is of invalid value(" + type + ").", null));
            return;
        }
        propDescriptors.put(propDescID, descriptor);
    }

    public static IPluginComponentDef newComponentDef(String componentNodeName, String namespace, String prefix) throws PluginDefUnavailableException {
        IPluginComponentDef def;
        IComponentPluginConfig config = (IComponentPluginConfig)PluginDefFactory.getPluginConfigs().get(componentNodeName);
        boolean notFound = false;
        if (config == null) {
            notFound = true;
        } else {
            if (namespace == null) {
                namespace = "";
            }
            if (config.getNamespace() == null) {
                if (!"".equals(namespace)) {
                    notFound = true;
                }
            } else if (!namespace.equals(config.getNamespace())) {
                notFound = true;
            }
        }
        if (notFound) {
            throw new PluginDefUnavailableException("Component definition for \"" + componentNodeName + "\" is not found.");
        }
        if ((prefix == null || "".equals(prefix)) && namespace != null && !"".equals(namespace)) {
            prefix = DEFAULT_PREFIX;
        }
        if (config.getContentFactory() != null && (def = config.getContentFactory().newDef(new PluginDefProxy(config, prefix))) != null) {
            def.setAttribute("name", "new" + config.getNodeName());
            return def;
        }
        def = config.isContainer() ? new PluginContainerDef(config, prefix) : new PluginComponentDef(config, prefix);
        def.setAttribute("name", "new" + config.getNodeName());
        return def;
    }

    public static IPropertyDescriptor[] getPropDescs(String compNodeName) {
        IComponentPluginConfig config = (IComponentPluginConfig)PluginDefFactory.getPluginConfigs().get(compNodeName);
        Iterator it = config.getPropertyNames();
        ArrayList temp = new ArrayList();
        while (it != null && it.hasNext()) {
            String propName = (String)it.next();
            Object propDesc = propDescriptors.get(new CustCompPropDescKey(compNodeName, propName));
            if (propDesc == null) continue;
            temp.add(propDesc);
        }
        IPropertyDescriptor[] result = new IPropertyDescriptor[temp.size()];
        return temp.toArray(result);
    }

    public static PropertyPluginConfig getPropConfig(String compNodeName, String propName) throws PluginDefUnavailableException {
        IComponentPluginConfig compConfig = (IComponentPluginConfig)PluginDefFactory.getPluginConfigs().get(compNodeName);
        if (compConfig == null) {
            throw new PluginDefUnavailableException("Component definition for \"" + compNodeName + "\" is not found.");
        }
        PropertyPluginConfig propConfig = compConfig.getPropertyConfig(propName);
        if (propConfig == null) {
            throw new PluginDefUnavailableException("Property definition for \"" + propName + "\" is not found in component " + compNodeName + ".");
        }
        return propConfig;
    }

    public static Iterator getPluginComps() {
        return new NoRemoveIterator(PluginDefFactory.getPluginConfigs().values().iterator());
    }
}

