/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.eventdef.Param;
import org.maskat.framework.eventdef.Source;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;

public class ParamProperty extends Param implements IPropertySource {

	private static String PROP_ROOTNODE = "_prop_rootnode_";

	private static String PROP_NS = "_prop_ns_";

	// private Param param;

	public ParamProperty() {
	}

	private static IPropertyDescriptor[] descriptors;
	static {
		descriptors = new IPropertyDescriptor[] {
				new MaskatTextPropertyDescriptor(PROP_ROOTNODE, "rootNode"),
				new MaskatTextPropertyDescriptor(PROP_NS, "ns") };
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		List sourcesPropDesc = new ArrayList();
		int i = 0;
		for (Iterator it = getTypedChildren(Source.class); it != null
				&& it.hasNext(); i++) {
			it.next();
			sourcesPropDesc
					.add(new PropertyDescriptor(new Integer(i), "source"));
		}

		List desc = Arrays.asList(descriptors);
		sourcesPropDesc.addAll(desc);

		return (IPropertyDescriptor[]) sourcesPropDesc
				.toArray(new PropertyDescriptor[0]);
	}

	public Object getPropertyValue(Object id) {
		if (id.equals(PROP_ROOTNODE)) {
			return getRootNode();
		}
		if (id.equals(PROP_NS)) {
			return getNs();
		}
		if (id instanceof Integer) {
			int idx = ((Integer) id).intValue();
			return (SourceProperty) getChildByTypeIdx(SourceProperty.class, idx);
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
		if (PROP_ROOTNODE.equals(id)) {
			setRootNode((String) value);
		}
		if (PROP_NS.equals(id)) {
			setNs((String) value);
		}
	}

}
