/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editpolicies;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.maskat.framework.IBasicDef;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.SplitterDef;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.framework.screendef.TabItemDef;
import org.maskat.ide.gef.commands.AddComponentCommand;
import org.maskat.ide.gef.commands.AddGridHeaderCommand;
import org.maskat.ide.gef.commands.ChangeConstraintCommand;
import org.maskat.ide.gef.commands.OrphanChildrenCommand;

public class MyXYLayoutEditPolicy extends XYLayoutEditPolicy {

	protected Command createAddCommand(EditPart child, Object constraint) {
		Object childModel = child.getModel();
		if (!(childModel instanceof IComponentDef)) {
			return null;
		}
		Object target = getHost().getModel();
		if (!(target instanceof IContainerDef)) {
			return null;
		}

		if (target instanceof TabFolderDef) {
			if (!(childModel instanceof TabItemDef)) {
				// TabFolderDef̎qvfƂāATabItemDefǉł܂B
				return null;
			}
		}
		if (childModel instanceof TabItemDef) {
			if (!(target instanceof TabFolderDef)) {
				// TabItemDefTabFolderDef̎qvfɂȂ܂B
				return null;
			}
		}
		if (childModel instanceof DivSplitDef) {
			if (!(target instanceof SplitterDef)) {
				return null;
			}
		}
		if (target instanceof SplitterDef) {
			if (!(childModel instanceof DivSplitDef)) {
				return null;
			}
		}

		AddComponentCommand command = new AddComponentCommand((IContainerDef) target,
				(IComponentDef) childModel);

		command.setConstraint((Rectangle) constraint);

		return command;
		// AddCommandOrphanChildrenCommandƃyAōp
	}

	protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
		if (child.getModel() instanceof IComponentDef) {
			ChangeConstraintCommand command = new ChangeConstraintCommand(
					(IComponentDef) child.getModel());
			command.setConstraint((Rectangle) constraint);
			return command;
		}
		return null;
	}

	protected Command getCreateCommand(CreateRequest request) {
		IBasicDef host = (IBasicDef) getHost().getModel();
		IContainerDef parent = null;
		Object newObj = request.getNewObject();
		if (newObj instanceof GridHeaderDef) {
			if (!(host instanceof GridDef)) {
				return null;
			}
			AddGridHeaderCommand command = new AddGridHeaderCommand((GridDef) host,
					(GridHeaderDef) newObj);
			return command;
		}
		IComponentDef node = (IComponentDef) request.getNewObject();

		// createCommand͐邩ǂ`FbN
		if (host instanceof IContainerDef) {
			parent = (IContainerDef) host;
			if (host instanceof TabFolderDef) {
				if (!(node instanceof TabItemDef)) {
					// TabFolderDef̎qvfƂāATabItemDefǉł܂B
					return null;
				}
			}
			if (node instanceof TabItemDef) {
				if (!(host instanceof TabFolderDef)) {
					// TabItemDefTabFolderDef̎qvfɂȂ܂B
					return null;
				}
			}
			if (host instanceof SplitterDef) {
				if (!(node instanceof DivSplitDef)) {
					return null;
				}
			}
		} else {
			// hostContainerDefȊOł΁Acreates
			return null;
		}

		AddComponentCommand command = new AddComponentCommand(parent, node);

		command.setConstraint((Rectangle) getConstraintFor(request));

		return command;
	}

	protected Command getOrphanChildrenCommand(Request request) {

		Object obj = getHost().getModel();
		if (obj instanceof IContainerDef) {
			List editParts = ((GroupRequest) request).getEditParts();
			List models = new ArrayList();
			for (int i = 0; i < editParts.size(); i++) {
				models.add(((EditPart) editParts.get(i)).getModel());
			}
			OrphanChildrenCommand command = new OrphanChildrenCommand(models);
			return command;
		}
		return null;
	}

	protected Command getDeleteDependantCommand(Request request) {
		return null;
	}

	protected Command getCloneCommand(ChangeBoundsRequest request) {

		return super.getCloneCommand(request);
	}
}
