/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.maskat.ide.wizards.FileExtensionFilter;

public class MaskatHtmlContainerNewWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private Text titleText;
    private Text layoutFileText;
    private Text eventFileText;
    private Text maskatFWPathText;
    private Text widthText;
    private Text heightText;
    private ISelection selection;
    private IContainer container = null;

    public MaskatHtmlContainerNewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("Maskat Container HTML");
        this.setDescription("This wizard creates a container html file for maskat framework.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        ModifyListener textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MaskatHtmlContainerNewWizardPage.this.dialogChanged();
            }
        };
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 5;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(textModifyListener);
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskatHtmlContainerNewWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(textModifyListener);
        label = new Label(container, 0);
        label.setText("&Title:");
        this.titleText = new Text(container, 2052);
        this.titleText.setText("Maskat Application");
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.titleText.setLayoutData((Object)gd);
        this.titleText.addModifyListener(textModifyListener);
        label = new Label(container, 0);
        label.setText("&Maskat FW Path:");
        this.maskatFWPathText = new Text(container, 2052);
        this.maskatFWPathText.setText("maskatFW");
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.maskatFWPathText.setLayoutData((Object)gd);
        this.maskatFWPathText.addModifyListener(textModifyListener);
        label = new Label(container, 0);
        label.setText("&Layout File:");
        this.layoutFileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.layoutFileText.setLayoutData((Object)gd);
        this.layoutFileText.addModifyListener(textModifyListener);
        button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskatHtmlContainerNewWizardPage.this.handleBrowseLayout();
            }
        });
        label = new Label(container, 0);
        label.setText("&Event File:");
        this.eventFileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.eventFileText.setLayoutData((Object)gd);
        this.eventFileText.addModifyListener(textModifyListener);
        button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskatHtmlContainerNewWizardPage.this.handleBrowseEvent();
            }
        });
        label = new Label(container, 0);
        label.setText("Div &width:");
        this.widthText = new Text(container, 2052);
        this.widthText.setText("800");
        gd = new GridData(768);
        this.widthText.setLayoutData((Object)gd);
        this.widthText.addModifyListener(textModifyListener);
        label = new Label(container, 0);
        label.setText("Div &height:");
        this.heightText = new Text(container, 2052);
        this.heightText.setText("600");
        gd = new GridData(768);
        this.heightText.setLayoutData((Object)gd);
        this.heightText.addModifyListener(textModifyListener);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    protected void handleBrowseLayout() {
        String value = this.handleBrowserResource();
        if (value != null) {
            this.layoutFileText.setText(value);
        }
    }

    protected void handleBrowseEvent() {
        String value = this.handleBrowserResource();
        if (value != null) {
            this.eventFileText.setText(value);
        }
    }

    protected String handleBrowserResource() {
        Object[] result;
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle("Select file");
        dialog.setMessage("Select a file from the list:");
        dialog.addFilter((ViewerFilter)new FileExtensionFilter("xml"));
        if (this.container != null && this.container.getProject() != null) {
            dialog.setInput((Object)this.container.getProject());
        } else {
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        }
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.getDialogSettings();
            return ((IFile)result[0]).getName();
        }
        return null;
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                this.container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(this.container.getFullPath().toString());
            }
        }
        this.fileText.setText("container.html");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("html")) {
            this.updateStatus("File extension must be \"html\"");
            return;
        }
        if (this.layoutFileText.getText().length() == 0) {
            this.updateStatus("Layout File Name must be specified");
            return;
        }
        if (this.eventFileText.getText().length() == 0) {
            this.updateStatus("Event File Name must be specified");
            return;
        }
        if (!this.isPositiveInteger(this.widthText.getText())) {
            this.updateStatus("Div width must be a positive integer.");
            return;
        }
        if (!this.isPositiveInteger(this.heightText.getText())) {
            this.updateStatus("Div height must be a positive integer.");
            return;
        }
        this.updateStatus(null);
    }

    private boolean isPositiveInteger(String value) {
        try {
            int intVal = Integer.parseInt(value);
            if (intVal > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return false;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getHTMLTitle() {
        return this.titleText.getText();
    }

    public String getLayoutFileName() {
        return this.layoutFileText.getText();
    }

    public String getEventFileName() {
        return this.eventFileText.getText();
    }

    public String getFWPath() {
        return this.maskatFWPathText.getText();
    }

    public int getDivWidth() {
        return Integer.parseInt(this.widthText.getText());
    }

    public int getDivHeight() {
        return Integer.parseInt(this.heightText.getText());
    }
}

