/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.wizards;

import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.maskat.ide.MaskatIDEPlugin;

public class FileExtensionFilter
extends ViewerFilter {
    private String fTargetExtension;

    public FileExtensionFilter(String targetExtension) {
        this.fTargetExtension = targetExtension;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            return ((IFile)element).getName().toLowerCase(Locale.ENGLISH).endsWith("." + this.fTargetExtension);
        }
        if (element instanceof IContainer) {
            try {
                IResource[] resources = ((IContainer)element).members();
                int i = 0;
                while (i < resources.length) {
                    if (this.select(viewer, parent, resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                MaskatIDEPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        return false;
    }
}

