/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.maskat.framework.eventdef.IEventDefSource;
import org.maskat.framework.eventdef.xml.TelegramSchemaGenerator;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.framework.screendef.MaskatDef;
import org.maskat.framework.screendef.RadioGroupDef;
import org.maskat.framework.screendef.xml.LayoutDefParser;
import org.maskat.framework.screendef.xml.LayoutDefXmlSerializer;
import org.maskat.ide.MaskatIDEPlugin;
import org.maskat.ide.editors.PaletteSupport;
import org.maskat.ide.editors.linkeventsrc.LinkEventDefSource;
import org.maskat.ide.gef.editparts.ComponentEditPart;
import org.maskat.ide.gef.editparts.GridHeaderEditPart;
import org.maskat.ide.gef.editparts.MaskatEditPartFactory;
import org.maskat.ide.gef.editparts.SplitEditPart;
import org.maskat.ide.gef.editparts.SplitPageEditPart;
import org.maskat.ide.gef.editparts.TabEditPart;
import org.maskat.ide.gef.editparts.TabFolderEditPart;
import org.maskat.ide.property.LayoutProperty;

public class MaskatEditor
extends GraphicalEditor {
    public static final String ID = "org.maskat.ide.gef.editor1";
    public boolean gettingFocus = false;
    protected MaskatDef maskatDef = null;
    protected int layoutIdx = 0;
    protected LayoutProperty layout = null;
    public static final int SCREEN_EDIT_MODE = 1;
    public static final int SOURCE_EDIT_MODE = 2;
    public static final int TARGET_EDIT_MODE = 4;
    public int editMode = 1;
    private PaletteSupport paletteSupport;
    Composite splitter;
    private boolean isThisEditorSaving = false;
    private IResourceChangeListener listener;
    private IFile layoutXmlFile;
    IEventDefSource eventDefSource;

    public void setFocus() {
        super.setFocus();
        this.gettingFocus = true;
    }

    public MaskatEditor() {
        DefaultEditDomain ed = new DefaultEditDomain((IEditorPart)this);
        this.paletteSupport = new PaletteSupport((EditDomain)ed);
        this.setEditDomain(ed);
    }

    public void createPartControl(Composite parent) {
        this.splitter = this.paletteSupport.getEditorComposite(parent, this.getSite().getPage());
        super.createPartControl(this.splitter);
        this.paletteSupport.setGraphicalControl(this.getGraphicalViewer().getControl());
    }

    protected Composite getControl() {
        return this.splitter;
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        this.genLayoutMenu();
        viewer.setContents((Object)this.getCurrentLayoutDef());
        this.createSourceListener();
    }

    protected void genLayoutMenu() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        MenuManager mm = viewer.getContextMenu();
        if (mm == null) {
            mm = new MenuManager();
            viewer.setContextMenu(mm);
        }
        mm.removeAll();
        MenuManager subMenu = new MenuManager("layouts");
        Iterator it = this.maskatDef.getTypedChildren(LayoutDef.class);
        int currentIdx = 0;
        while (it.hasNext()) {
            LayoutDef layoutDef = (LayoutDef)it.next();
            final int theIdx = currentIdx;
            Action action = new Action(layoutDef.getName() == null ? "anonymous" + theIdx : layoutDef.getName(), 8){

                public void run() {
                    MaskatEditor.this.switchLayout(theIdx);
                }
            };
            action.setId(String.valueOf(theIdx));
            if (currentIdx == 0) {
                action.setChecked(true);
            } else {
                action.setChecked(false);
            }
            subMenu.add((IAction)action);
            ++currentIdx;
        }
        mm.add((IContributionItem)subMenu);
    }

    protected void switchLayout(int theIdx) {
        this.layoutIdx = theIdx;
        this.connectLayoutEvent();
        this.getGraphicalViewer().setContents((Object)this.getCurrentLayoutDef());
    }

    protected LayoutDef getCurrentLayoutDef() {
        return (LayoutDef)this.maskatDef.getChildByTypeIdx(LayoutDef.class, this.layoutIdx);
    }

    private void createSourceListener() {
        this.listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (MaskatEditor.this.isThisEditorSaving) {
                    return;
                }
                IEditorInput editorInput = MaskatEditor.this.getEditorInput();
                IFile iFile = (IFile)editorInput.getAdapter(IFile.class);
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(iFile.getFullPath());
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                if (visitor.isHit()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            try {
                                MaskatEditor.this.initLoad(MaskatEditor.this.getEditorInput());
                                MaskatEditor.this.connectLayoutEvent();
                                MaskatEditor.this.genLayoutMenu();
                                MaskatEditor.this.getGraphicalViewer().setContents((Object)MaskatEditor.this.getCurrentLayoutDef());
                                MaskatEditor.this.getCommandStack().flush();
                            }
                            catch (PartInitException e) {
                                MaskatIDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.maskat.ide.gef", 4, e.getMessage(), (Throwable)e));
                            }
                        }
                    });
                }
            }
        };
        MaskatIDEPlugin.getWorkspace().addResourceChangeListener(this.listener);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            try {
                this.isThisEditorSaving = true;
                StringWriter strWriter = new StringWriter(1024);
                LayoutDefXmlSerializer serializer = new LayoutDefXmlSerializer(this.maskatDef, (Writer)strWriter);
                serializer.write();
                Iterator it = this.maskatDef.getTypedChildren(LayoutDef.class);
                while (it.hasNext()) {
                    ((LayoutDef)it.next()).removeAllByType(RadioGroupDef.class);
                }
                byte[] bytes = strWriter.toString().getBytes("UTF-8");
                this.layoutXmlFile.setContents((InputStream)new ByteArrayInputStream(bytes), false, false, monitor);
                String[] results = this.eventDefSource.save();
                boolean confirm = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"\u30b9\u30ad\u30fc\u30de\u751f\u6210", (String)"\u30b9\u30ad\u30fc\u30de\u81ea\u52d5\u751f\u6210\u3057\u307e\u3059\u3001\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f");
                if (confirm) {
                    int i = 0;
                    while (i < results.length) {
                        String result = results[i];
                        IPath path = this.layoutXmlFile.getProjectRelativePath();
                        IProject project = this.layoutXmlFile.getProject();
                        TelegramSchemaGenerator.generate(new ByteArrayInputStream(result.getBytes("UTF-8")), project, path.removeLastSegments(1));
                        ++i;
                    }
                }
                this.getCommandStack().markSaveLocation();
                this.firePropertyChange(257);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"\u4fdd\u5b58", (String)"\u4fdd\u5b58\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (IStatus)e.getStatus());
            }
            catch (Exception e) {
                Status status = new Status(4, "org.maskat.ide.gef", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"\u4fdd\u5b58", (String)"\u4fdd\u5b58\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (IStatus)status);
            }
        }
        finally {
            this.isThisEditorSaving = false;
        }
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.firePropertyChange(257);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new MaskatEditPartFactory());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.initLoad(input);
        super.init(site, input);
    }

    private void initLoad(IEditorInput input) throws PartInitException {
        this.layoutXmlFile = (IFile)input.getAdapter(IFile.class);
        if (this.layoutXmlFile != null) {
            this.setPartName(this.layoutXmlFile.getName());
        }
        try {
            this.loadLayout();
            this.loadEvent();
        }
        catch (CoreException e) {
            throw new PartInitException(e.getStatus());
        }
        catch (Exception e) {
            Status status = new Status(4, "org.maskat.ide.gef", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            throw new PartInitException((IStatus)status);
        }
        this.connectLayoutEvent();
    }

    private void loadLayout() throws Exception {
        InputStream inputS = null;
        try {
            this.layoutXmlFile.refreshLocal(1, null);
            if (this.layoutXmlFile.exists()) {
                inputS = this.layoutXmlFile.getContents();
                this.maskatDef = LayoutDefParser.parse(inputS);
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputS != null) {
                    inputS.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputS != null) {
                inputS.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void loadEvent() throws Exception {
        this.eventDefSource = new LinkEventDefSource(this.layoutXmlFile);
        this.eventDefSource.load();
    }

    private void connectLayoutEvent() {
        LayoutDef layoutDef = this.getCurrentLayoutDef();
        layoutDef.setLayoutEvtDefSrc(this.eventDefSource);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        if (selection instanceof TextSelection) {
            TextSelection txtSel = (TextSelection)selection;
            ArrayList targets = new ArrayList();
            if (txtSel.getText() == null) {
                return;
            }
            this.searchForNamedComponent(this.getGraphicalViewer().getRootEditPart().getContents(), txtSel.getText(), targets);
            this.getGraphicalViewer().deselectAll();
            int i = 0;
            while (i < targets.size()) {
                EditPart target = (EditPart)targets.get(i);
                this.getGraphicalViewer().appendSelection(target);
                if (i == 0) {
                    this.getGraphicalViewer().reveal(target);
                }
                ++i;
            }
        }
    }

    public void searchForNamedComponent(EditPart root, String name, List list) {
        if (root == null || root.getChildren() == null) {
            return;
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            EditPart editPart = (EditPart)root.getChildren().get(i);
            if (editPart.getModel() instanceof IComponentDef && name.equals(((IComponentDef)editPart.getModel()).getName())) {
                list.add(editPart);
            }
            this.searchForNamedComponent(editPart, name, list);
            ++i;
        }
    }

    public void dispose() {
        MaskatIDEPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        super.dispose();
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            PropertySheetPage page = new PropertySheetPage();
            UndoablePropertySheetEntry entry = new UndoablePropertySheetEntry(this.getCommandStack());
            entry.setPropertySourceProvider(new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    if (object instanceof ComponentEditPart) {
                        AbstractGraphicalEditPart part = (AbstractGraphicalEditPart)object;
                        return (IPropertySource)Platform.getAdapterManager().getAdapter(part.getModel(), IPropertySource.class);
                    }
                    if (object instanceof GridHeaderEditPart) {
                        GridHeaderEditPart part = (GridHeaderEditPart)((Object)object);
                        return (IPropertySource)Platform.getAdapterManager().getAdapter(part.getModel(), IPropertySource.class);
                    }
                    if (object instanceof SplitPageEditPart || object instanceof SplitEditPart) {
                        AbstractGraphicalEditPart part = (AbstractGraphicalEditPart)object;
                        return (IPropertySource)Platform.getAdapterManager().getAdapter(part.getModel(), IPropertySource.class);
                    }
                    if (object instanceof TabFolderEditPart || object instanceof TabEditPart) {
                        AbstractGraphicalEditPart part = (AbstractGraphicalEditPart)object;
                        return (IPropertySource)Platform.getAdapterManager().getAdapter(part.getModel(), IPropertySource.class);
                    }
                    if (object instanceof IPropertySource) {
                        return (IPropertySource)object;
                    }
                    return null;
                }
            });
            page.setRootEntry((IPropertySheetEntry)entry);
            return page;
        }
        Object result = this.paletteSupport.getAdapter(type);
        if (result != null) {
            return result;
        }
        return super.getAdapter(type);
    }

    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private IPath targetResourcePath;
        private boolean hit = false;

        public boolean isHit() {
            return this.hit;
        }

        public ResourceDeltaVisitor(IPath targetResourcePath) {
            this.targetResourcePath = targetResourcePath;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            switch (delta.getKind()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (!delta.getFullPath().equals((Object)this.targetResourcePath)) break;
                    this.hit = true;
                    break;
                }
                case 4: {
                    if (!delta.getFullPath().equals((Object)this.targetResourcePath)) break;
                    this.hit = true;
                }
            }
            return true;
        }
    }
}

