/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.maskat.ide.view.MaskatEditView;

public class MaskatIDEUtil {
    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = MaskatIDEUtil.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        return editorPart;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        return page;
    }

    public static MaskatEditView getMaskatEditView() {
        IViewReference[] refs = MaskatIDEUtil.getActivePage().getViewReferences();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                IViewReference ref = refs[i];
                if ("org.maskat.ide.views.MaskatEditView".equals(ref.getId())) {
                    return (MaskatEditView)ref.getView(true);
                }
                ++i;
            }
        }
        return null;
    }

    public static IFolder createFolder(IProject project, String path) throws CoreException {
        path = path.replaceAll("/", "\\");
        String[] paths = path.split("\\\\");
        IFolder folder = null;
        IPath iPath = null;
        int i = 0;
        while (i < paths.length) {
            if (paths[i] != null && !"".equals(paths[i].trim())) {
                if (iPath == null) {
                    folder = project.getFolder(paths[i]);
                } else {
                    iPath = iPath.append(paths[i]);
                    folder = project.getFolder(iPath);
                }
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                iPath = folder.getProjectRelativePath();
            }
            ++i;
        }
        return folder;
    }

    public static byte[] addBOMSignature_LE(byte[] src) {
        byte[] result = new byte[src.length + 2];
        result[0] = -1;
        result[1] = -2;
        System.arraycopy(src, 0, result, 2, src.length);
        return result;
    }
}

