/*
 * Copyright 2006 Mask@ Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function BackgroundLoad(){
}

/* 初期化関数。本ファイルの最後で呼び出している。 */
BackgroundLoad.init = function(){

  /* 内部変数の初期化 */
  BackgroundLoad.layoutHash = new Object();  // レイアウト名 => 親DIVDOM, 一時DIVDOM
  BackgroundLoad.containerHash = new Object();  // DIVDOMのID => 現在そのDIVDOMに表示されているレイアウト名
  BackgroundLoad.divUniqueID = 0;
  BackgroundLoad.HIDE_ZONE = {top:3000, left:3000};

  /* プログレスバーの作成 */
  BackgroundLoad.progressBarWindow = document.createElement("div");
  BackgroundLoad.progressBarWindow.style.position = "absolute";
  BackgroundLoad.progressBarWindow.style.zIndex = 32767;
  BackgroundLoad.progressBarWindow.style.top = "100px";
  BackgroundLoad.progressBarWindow.style.left = "100px";
  BackgroundLoad.progressBarWindow.style.border = "3px solid black";
  BackgroundLoad.progressBarWindow.style.width = "300px";
  BackgroundLoad.progressBarWindow.style.height = "50px";
  BackgroundLoad.progressBarWindow.style.padding = "1em";
  BackgroundLoad.progressBarWindow.style.backgroundColor = "pink";
}

/* プログレスバーを表示 */
BackgroundLoad.showProgressBar = function(){

  if(!BackgroundLoad.isProgressBarLoaded){
    document.body.appendChild(BackgroundLoad.progressBarWindow);
    BackgroundLoad.isProgressBarLoaded = true;
  }

  /* 画面中央に表示 */
  BackgroundLoad.progressBarWindow.style.top = 
    (document.body.clientHeight - BackgroundLoad.progressBarWindow.offsetHeight) / 2;
  BackgroundLoad.progressBarWindow.style.left =
    (document.body.clientWidth - BackgroundLoad.progressBarWindow.offsetWidth) / 2;

}

/* プログレスバーを非表示 */
BackgroundLoad.hideProgressBar = function(){

  BackgroundLoad.progressBarWindow.style.top = BackgroundLoad.HIDE_ZONE.top;
  BackgroundLoad.progressBarWindow.style.left = BackgroundLoad.HIDE_ZONE.left;

}

/* レイアウトをバックグラウンドでロード */
/* 引数: {'fileName':<レイアウトXMLファイル名>, 'refParentObjText':<親DIVタグのDOMのテキスト表現>} の配列 */
BackgroundLoad.loadLayout = function(args){

  BackgroundLoad.args = args;  // TODO: setTimeoutで引数に渡せなかった。後で直す
  BackgroundLoad.showProgressBar();
  
  BackgroundLoad.progressBarWindow.innerHTML = args.length + "つのファイルの取得・コンパイル中";

  setTimeout(BackgroundLoad.loadLayout2, 500);  // プログレスバーが表示されるよう、0.5秒待つ
}

BackgroundLoad.loadLayout2 = function(){
  var args = BackgroundLoad.args;  // TODO: setTimeoutで引数に渡せなかった。後で直す
  BackgroundLoad.args = null;  // TODO: setTimeoutで引数に渡せなかった。後で直す
  
  BackgroundLoad.layoutNameArray = new Array();
  
  for (var i = 0; i < args.length; i++){
    BackgroundLoad.loadLayout3(args[i]);
  }

  BackgroundLoad.progressBarWindow.innerHTML = "";
  for (var i = 0; i < args.length; i++){
    BackgroundLoad.progressBarWindow.innerHTML += "<div>[" + BackgroundLoad.layoutNameArray[i] + "] <span id='_maskat_layout_loadStatusMessage_" + BackgroundLoad.layoutNameArray[i] + "'>ロード待ち</span></div>";
  }
  
  BackgroundLoad.nextLayoutIndex = 0; 
  BackgroundLoad.loadLayout3_1();
}

BackgroundLoad.loadLayout3_1 = function(){

  if (BackgroundLoad.nextLayoutIndex > BackgroundLoad.layoutNameArray.length - 1){
    BackgroundLoad.hideProgressBar();
  }
  else{
    var statusMessageDOM = document.getElementById("_maskat_layout_loadStatusMessage_" + BackgroundLoad.layoutNameArray[BackgroundLoad.nextLayoutIndex]);
    statusMessageDOM.innerHTML = "ロード中";
    setTimeout(BackgroundLoad.loadLayout3_2, 500);  // 画面描画が反映されるように、0.5秒待つ
  }
}

BackgroundLoad.loadLayout3_2 = function(){
  loadLayout(BackgroundLoad.layoutNameArray[BackgroundLoad.nextLayoutIndex]);
  
  var statusMessageDOM = document.getElementById("_maskat_layout_loadStatusMessage_" + BackgroundLoad.layoutNameArray[BackgroundLoad.nextLayoutIndex]);
  statusMessageDOM.innerHTML = "ロード完了";


  BackgroundLoad.nextLayoutIndex++;
  setTimeout(BackgroundLoad.loadLayout3_1, 500);  // 画面描画が反映されるように、0.5秒待つ
}


/* BackgroundLoad.loadLayout関数の補助関数 */
BackgroundLoad.loadLayout3 = function(arg){
  var xmlhttp;
  try {
    xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
  } catch (e) {
    try {
      xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    } catch (e) {
      xmlhttp = false;
    }
  }
  if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
    xmlhttp = new XMLHttpRequest();
  }
  if (xmlhttp) {
    xmlhttp.open("GET", "http://localhost:8080/maskat/"+arg.fileName, false);
    xmlhttp.send(null);
    if (xmlhttp.status == 200) {
      BackgroundLoad.loadLayout4(xmlhttp.responseText, arg.refParentObjText);
    } else {
      alert("リソースの取得に失敗しました");
    }
  }
  else {
    alert('非同期通信モジュールの取得に失敗しました。\n処理を停止します。');
    return;
  }
}

/* BackgroundLoad.loadLayout関数の補助関数 */
BackgroundLoad.loadLayout4 = function(layoutXML, refParentObjText){
  // TODO: すでにそのレイアウトがロードされていた場合の処理

  var sourceDoc = CrossBrowser.XML2DOM(layoutXML);
//  var layoutName = CrossBrowser.getElementsByTagName(sourceDoc, "layout")[0].getAttribute("name");
  var layoutName = sourceDoc.getElementsByTagName("layout").item(0).getAttribute("name");
  var refParentObj = eval(refParentObjText);

  // refParentObjがDIVタグのDOMの場合
  if (refParentObj.tagName != null && refParentObj.tagName.toUpperCase() == "DIV"){

    /* 画面外にDIVのDOMを作成し、そのDOMに対して表示処理を行う(実際は画面外のため表示されない) */

    var layoutDIV = document.createElement("div");
    layoutDIV.id = "_maskat_" + refParentObj.id + "_" + BackgroundLoad.divUniqueID++;
    layoutDIV.style.position = "absolute";
    layoutDIV.style.top = BackgroundLoad.HIDE_ZONE.top;
    layoutDIV.style.left = BackgroundLoad.HIDE_ZONE.left;
    layoutDIV.style.width = refParentObj.style.width;
    layoutDIV.style.height = refParentObj.style.height;
    document.body.appendChild(layoutDIV);

    var rialtoJSSrc;
    try{
      rialtoJSSrc = maskat.interpretLayoutXML(sourceDoc, 'document.getElementById("' + layoutDIV.id + '")');
    } catch(e){
      alert("name: " + e.name + "\nmessage: " + e.message + "\nfileName: " + e.fileName);
    }
    maskat.loadJSSrc(rialtoJSSrc);
    
    BackgroundLoad.layoutNameArray.push(layoutName);

    BackgroundLoad.layoutHash[layoutName] = {"refParentObj":refParentObj, "layoutDIV":layoutDIV};
    BackgroundLoad.containerHash[refParentObj.id] = null;

  }
  // TODO: refParentObjがRialtoコンテナオブジェクトの場合
  

}

BackgroundLoad.unloadLayout = function(layoutName){
  if (BackgroundLoad.layoutHash[layoutName] != undefined){
    // TODO: layout配下の全コンポーネントをremove

    BackgroundLoad.hideLayout(layoutName);

    var layoutDIV = BackgroundLoad.layoutHash[layoutName].layoutDIV;
    layoutDIV.parentNode.removeChild(layoutDIV);

    delete BackgroundLoad.layoutHash[layoutName];
  }
  else {
    alert(layoutName + "レイアウトはロードされていないので、アンロードできません。");
  }
}

BackgroundLoad.showLayout = function(layoutName){
  if (BackgroundLoad.layoutHash[layoutName] != undefined){
    var currentLayoutName = BackgroundLoad.containerHash[BackgroundLoad.layoutHash[layoutName].refParentObj.id];
    if (currentLayoutName != null){
      // 既存のレイアウトをhideする
      BackgroundLoad.hideLayout(currentLayoutName);
    }
    
    var layoutDIV = BackgroundLoad.layoutHash[layoutName].layoutDIV;
    var refParentObj = BackgroundLoad.layoutHash[layoutName].refParentObj;
    layoutDIV.style.top = refParentObj.style.top;
    layoutDIV.style.left = refParentObj.style.left;
    
    BackgroundLoad.containerHash[BackgroundLoad.layoutHash[layoutName].refParentObj.id] = layoutName;
  }
  else {
    alert(layoutName + "レイアウトはロードされていないので、表示できません。");
  }
}

BackgroundLoad.hideLayout = function(layoutName){
  if (BackgroundLoad.layoutHash[layoutName] != undefined){
    var currentLayoutName = BackgroundLoad.containerHash[BackgroundLoad.layoutHash[layoutName].refParentObj.id];
    /* hide指定されたレイアウト名と、現在表示されているレイアウト名が等しい場合のみ処理を行う */
    if (currentLayoutName == layoutName){
      var layoutDIV = BackgroundLoad.layoutHash[layoutName].layoutDIV;
      layoutDIV.style.top = BackgroundLoad.HIDE_ZONE.top;
      layoutDIV.style.left = BackgroundLoad.HIDE_ZONE.left;
    
      BackgroundLoad.containerHash[BackgroundLoad.layoutHash[layoutName].refParentObj.id] = null;
    }
  }
  else {
    alert(layoutName + "レイアウトはロードされていないので、非表示にできません。");
  }
}

BackgroundLoad.init();

