/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.eventdef;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.maskat.framework.BasicDef;
import org.maskat.framework.DefChildIterator;

public class Target extends BasicDef {
	private String out;

	private String in;

	private String inkey;

	private String type;

	// TODO binds폜
	private List binds;

	private String teleType;

	public void addChild(Object child) {
		super.addChild(child);
		if (child instanceof Bind) {
			addBind((Bind) child);
		}
	}

	private void addBind(Bind bind) {
		if (binds == null) {
			binds = new ArrayList();
		}
		binds.add(bind);
	}

	public List getBinds() {
		return binds;
	}

	public Iterator getBindsIt() {
		if (binds == null)
			return null;
		return new DefChildIterator(this, binds.iterator());
	}

	/**
	 * 
	 * @deprecated
	 * @param binds
	 */
	public void setBinds(List binds) {
		this.binds = binds;// TODO BasicDef#childrenƈv悤ɁI
	}

	public String getIn() {
		return in;
	}

	public void setIn(String in) {
		this.in = in;
	}

	public String getInkey() {
		return inkey;
	}

	public void setInkey(String inkey) {
		this.inkey = inkey;
	}

	public String getOut() {
		return out;
	}

	public void setOut(String out) {
		this.out = out;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getTeleType() {
		return teleType;
	}

	public void setTeleType(String teleType) {
		this.teleType = teleType;
	}

}
