/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.eventdef.Target;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;

public class TargetProperty extends Target implements IPropertySource {

	private static final String PROP_OUT = "_prop_obj_";

	private static final String PROP_IN = "_prop_node_";

	private static final String PROP_INKEY = "_prop_childnode_";

	private static final String PROP_TYPE = "_prop_idxref_";

	private static final String PROP_TELETYPE = "_prop_teletype_";

	private IPropertyDescriptor[] descriptors = new PropertyDescriptor[] {
			new MaskatTextPropertyDescriptor(PROP_OUT, "out"),
			new MaskatTextPropertyDescriptor(PROP_IN, "in"),
			new MaskatTextPropertyDescriptor(PROP_INKEY, "inKey"),
			new MaskatTextPropertyDescriptor(PROP_TYPE, "type"),
			new MaskatTextPropertyDescriptor(PROP_TELETYPE, "teleType") };

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		if (getBinds() == null || getBinds().size() == 0)
			return descriptors;

		List binds = getBinds();
		List bindsPropDesc = new ArrayList();
		for (int i = 0; i < binds.size(); i++) {
			bindsPropDesc.add(new PropertyDescriptor(new Integer(i), "bind"));
		}
		List desc = Arrays.asList(descriptors);
		bindsPropDesc.addAll(desc);

		return (IPropertyDescriptor[]) bindsPropDesc
				.toArray(new PropertyDescriptor[0]);
	}

	public Object getPropertyValue(Object id) {
		Object result = doGetPropertyValue(id);
		if (result == null)
			return "";
		return result;
	}

	public Object doGetPropertyValue(Object id) {
		if (PROP_OUT.equals(id)) {
			return getOut();
		}
		if (PROP_IN.equals(id)) {
			return getIn();
		}
		if (PROP_INKEY.equals(id)) {
			return getInkey();
		}
		if (PROP_TYPE.equals(id)) {
			return getType();
		}
		if (id instanceof Integer) {
			int idx = ((Integer) id).intValue();
			return getBinds().get(idx);
		}
		if (PROP_TELETYPE.equals(id)) {
			return getTeleType();
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {

	}

	public void setPropertyValue(Object id, Object value) {
		if ("".equals(value)) {
			value = null;
			// PropertySourceɋ󔒕nȂ悤
			// xml name="" ̂悤attributeo͂Ȃ悤
		}
		doSetPropertyValue(id, value);
	}

	private void doSetPropertyValue(Object id, Object value) {
		if (PROP_IN.equals(id)) {
			setIn((String) value);
		}
		if (PROP_INKEY.equals(id)) {
			setInkey((String) value);
		}
		if (PROP_OUT.equals(id)) {
			setOut((String) value);
		}
		if (PROP_TYPE.equals(id)) {
			setType((String) value);
		}
		if (PROP_TELETYPE.equals(id)) {
			setTeleType((String) value);
		}
	}

}
