/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.framework.eventdef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.maskat.framework.BasicDef;
import org.maskat.framework.DefChildIterator;
import org.maskat.framework.eventdef.Component;
import org.maskat.framework.eventdef.Event;
import org.maskat.framework.eventdef.EventRef;
import org.maskat.framework.eventdef.Header;
import org.maskat.framework.eventdef.RemoteUrl;

public class Layout
extends BasicDef {
    private String id;
    private RemoteUrl remoteUrl;
    private Map headers;
    private Map events;
    private Map eventRefs;
    private Map components;

    public void shrinkEvent() {
        ArrayList eventList = new ArrayList();
        int refId = 1;
        if (this.getUnmodifiableChildren() == null) {
            return;
        }
        Iterator childrenIt = this.getUnmodifiableChildren().iterator();
        while (childrenIt.hasNext()) {
            Object child = childrenIt.next();
            if (!(child instanceof Component)) continue;
            Component comp = (Component)child;
            Iterator it = comp.getUnmodifiableChildren().iterator();
            while (it.hasNext()) {
                Object compChild = it.next();
                if (!(compChild instanceof Event)) continue;
                refId = this.processOneEvent(eventList, refId, (Event)compChild);
            }
        }
    }

    private int processOneEvent(List eventList, int refId, Event temp) {
        int idx = eventList.indexOf(temp);
        if (idx != -1) {
            Event existed = (Event)eventList.get(idx);
            existed.removeAllChildren();
            if (existed.getRef() != null) {
                temp.setRef(existed.getRef());
            } else {
                String ref = "ref" + refId++;
                existed.setRef(ref);
                temp.setRef(ref);
                EventRef eventRef = new EventRef();
                eventRef.setRefid(ref);
                Iterator childrenIt = temp.getUnmodifiableChildren().iterator();
                while (childrenIt.hasNext()) {
                    eventRef.addChild(childrenIt.next());
                }
                this.addChild(eventRef);
            }
            temp.removeAllChildren();
        } else {
            eventList.add(temp);
            temp.setRef(null);
            if (this.eventRefs != null && this.eventRefs.values() != null) {
                Iterator it = this.eventRefs.values().iterator();
                while (it.hasNext()) {
                    EventRef eventRef = (EventRef)it.next();
                    if (!eventRef.contentEquals(temp)) continue;
                    temp.setRef(eventRef.getRefid());
                    temp.removeAllChildren();
                }
            }
        }
        return refId;
    }

    public Set getAllObjNames() {
        Event event;
        Iterator it;
        HashSet result = new HashSet();
        if (this.events != null) {
            it = this.events.values().iterator();
            while (it != null && it.hasNext()) {
                event = (Event)it.next();
                event.getRelatedObjNames(result);
            }
        }
        if (this.eventRefs != null) {
            it = this.eventRefs.values().iterator();
            while (it != null && it.hasNext()) {
                event = (EventRef)it.next();
                event.getRelatedObjNames(result);
            }
        }
        if (this.components != null) {
            it = this.components.values().iterator();
            while (it != null && it.hasNext()) {
                Component component = (Component)it.next();
                Iterator it2 = component.getAllEvents();
                while (it2 != null && it2.hasNext()) {
                    Event event2 = (Event)it2.next();
                    event2.getRelatedObjNames(result);
                }
            }
        }
        return result;
    }

    public void addChild(Object child) {
        super.addChild(child);
        if (child instanceof Component) {
            this.addComponent((Component)child);
        }
        if (child instanceof Header) {
            this.addHeader((Header)child);
        }
        if (child instanceof Event) {
            this.addEvent((Event)child);
        }
        if (child instanceof RemoteUrl) {
            this.remoteUrl = (RemoteUrl)child;
        }
    }

    private void addComponent(Component comp) {
        if (comp == null || comp.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (this.components == null) {
            this.components = new HashMap();
        }
        this.components.put(comp.getId(), comp);
    }

    private void addHeader(Header header) {
        if (header == null || header.getName() == null) {
            throw new IllegalArgumentException();
        }
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(header.getName(), header);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRemoteUrl() {
        if (this.remoteUrl == null) {
            return null;
        }
        return this.remoteUrl.getUrl();
    }

    public void setRemoteUrl(String remoteUrl) {
        if (this.remoteUrl == null) {
            this.addChild(new RemoteUrl());
        }
        this.remoteUrl.setUrl(remoteUrl);
    }

    public Component findComponent(String id) {
        if (this.components == null) {
            return null;
        }
        return (Component)this.components.get(id);
    }

    public Iterator getAllComponents() {
        if (this.components == null) {
            return null;
        }
        return new DefChildIterator(this, this.components.values().iterator());
    }

    public boolean hasComponents() {
        return this.components != null && this.components.size() != 0;
    }

    public Header findHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return (Header)this.headers.get(name);
    }

    public Iterator getAllHeaders() {
        if (this.headers == null) {
            return null;
        }
        return new DefChildIterator(this, this.headers.values().iterator());
    }

    public boolean hasHeaders() {
        return this.headers != null && this.headers.size() != 0;
    }

    private void addEvent(Event event) {
        if (event instanceof EventRef) {
            EventRef er = (EventRef)event;
            if (this.eventRefs == null) {
                this.eventRefs = new HashMap();
            }
            this.eventRefs.put(er.getRefid(), er);
            return;
        }
        if (this.events == null) {
            this.events = new HashMap();
        }
        this.events.put(event.getId(), event);
    }

    public Event findEvent(String id) {
        if (this.events == null) {
            return null;
        }
        return (Event)this.events.get(id);
    }

    public void removeEvent(String id) {
        if (this.events == null) {
            return;
        }
        this.events.remove(id);
    }

    public Iterator getAllEvents() {
        if (this.events == null) {
            return null;
        }
        return new DefChildIterator(this, this.events.values().iterator());
    }

    public Event findEventRef(String id) {
        if (this.eventRefs == null) {
            return null;
        }
        return (Event)this.eventRefs.get(id);
    }

    public Iterator getAllEventRefs() {
        if (this.eventRefs == null) {
            return null;
        }
        return new DefChildIterator(this, this.eventRefs.values().iterator());
    }

    public void expandEventRefToEvent() {
        Iterator compIt = this.getAllComponents();
        while (compIt != null && compIt.hasNext()) {
            Component comp = (Component)compIt.next();
            Iterator eventIt = comp.getAllEvents();
            while (eventIt != null && eventIt.hasNext()) {
                Event evtRef;
                Event event = (Event)eventIt.next();
                if (event.getRef() == null || (evtRef = this.findEventRef(event.getRef())) == null) continue;
                event.removeAllChildren();
                Iterator it = evtRef.getAllChildren();
                while (it != null && it.hasNext()) {
                    event.addChild(it.next());
                }
            }
        }
    }
}

