/*
 * Copyright 2006 Mask@ Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

maskat.loadEventFile = function(fileName){
  try {
    var eventDefDOM = maskat.loadXMLFile(fileName);

    maskat.loadLayoutEvents(eventDefDOM);
    maskat.loadComponentEvents(eventDefDOM);
  }
  catch (e){
    throw e;
  }
}

maskat.loadLayoutEvents = function(eventDefDOM){
  try {
    var eventNode = maskat.xpath(eventDefDOM, 'event[@id="onload"]');
    if (eventNode){
      var IDs = {component:null, event:"onload"};
      var onloadFunc = maskat.autoGenEventFunc(eventNode, eventDefDOM, IDs);
      onloadFunc();
    }
  }
  catch (e){
    throw e;
  }
}

maskat.loadComponentEvents = function(eventDefDOM){
  try{
    var componentNodes = maskat.xpath(eventDefDOM, 'component');
    for (var i = 0; i < componentNodes.length; i++){
      var componentNode = componentNodes[i];
      var componentID = maskat.xpath(componentNode, '@id');
      var eventNodes = maskat.xpath(componentNode, 'event');
      for (var j = 0; j < eventNodes.length; j++){
        var eventNode = eventNodes[j];
        var eventID = maskat.xpath(eventNode, '@id');
      
        var IDs = {component:componentID, event:eventID};
      
        var componentObj = null;
        try {
          componentObj = eval(IDs.component);
        }
        catch (e){
          throw new MaskatError({name: "EventXML Syntax Error",
                                 message: "R|[lg'" + IDs.component + "'ʒ`XMLɒ`Ă܂B",
                                 fileName: "intpr.js",
                                 functionName: "maskat.loadComponentEvents"});
        }
        if (componentObj[IDs.event]){
          componentObj[IDs.event] = maskat.autoGenEventFunc(eventNode, eventDefDOM, IDs);
        }
        else{
          throw new MaskatError({name: "EventXML Syntax Error",
                                 message: "R|[lg'" + IDs.component + "'ɃCxg'" + IDs.event + "'ݒł܂B",
                                 fileName: "intpr.js",
                                 functionName: "maskat.loadComponentEvents"});
        }
      }
    }
  }
  catch (e){
    throw e;
  }
}


//Cxg֐
maskat.autoGenEventFunc = function(eventNode, eventDefDOM, IDs){
  try {
  
    // <event ref="..." ...>̏
    var eventRefID = maskat.xpath(eventNode, '@ref');
    if (eventRefID){
      var eventRefNode = maskat.xpath(eventDefDOM, 'eventRef[@id="' + eventRefID + '"]');
      if (eventRefNode){
        for (var i = 0; i < eventRefNode.childNodes.length; i++){
          eventNode.appendChild(eventRefNode.childNodes[i].cloneNode(true));
        }
        // eventNode.removeAttribute("ref");  // refxƗpłȂ
      }
      else {
        throw new MaskatError({name: "EventXML Syntax Error",
                               message: "idl'" + eventRefID + "'eventRefvf܂B",
                               fileName: "intpr.js",
                               functionName: "maskat.loadComponentEvents"});
      }
    }
  
    // <event type="local" ...>̏
    if (maskat.xpath(eventNode, '@type') == "local"){
      return function(x){
        try {
          maskat.startFunc(eventNode, IDs);
  
          // <result>̏
          var resultNodes = maskat.xpath(eventNode, 'result');
          if (resultNodes.length == 1){
            var resultNode = resultNodes[0];
            var targetNodes = maskat.xpath(resultNode, 'target');
            for (var i = 0; i < targetNodes.length; i++){
              var targetNode = targetNodes[i];
              maskat.parseLocalTarget(targetNode);
            }
          }
  
          maskat.finishFunc(eventNode);
        }
        catch (e){
          // ɃG[throwłȂ̂(ĂяoWebuEUƂȂ)Aalerto͂
          if (e instanceof MaskatError){
            alert("CxgsɃG[܂B"
                 + "\nname: " + e.name + "\nmessage: " + e.message
                 + "\nfileName: " + e.fileName + "\nfunctionName: " + e.functionName);
          }
          else if (e instanceof MaskatProcessInterruption){
            // Do Nothing
          }
          else{
            throw e;
          }
        }
      }
    }
  
    // <event type="remote" ...>̏
    else {
      return function(x){
        try {
          maskat.startFunc(eventNode, IDs);

          // Md̍쐬
          var sendXML;
          var paramNodes = maskat.xpath(eventNode, 'param');
          if (paramNodes.length == 1){
            var paramNode = paramNodes[0];
            var rootNode = maskat.xpath(paramNode, '@rootNode');
            var sourceNodes = maskat.xpath(paramNode, 'source');
          
            sendXML = '<' + rootNode;
            var ns = maskat.xpath(eventNode, 'param[1]/@ns');
            if (ns){
              sendXML += ' xmlns="' + ns + '"';
            }
            sendXML += '>';
            
            for (var i = 0; i < paramNode.childNodes.length; i++){
              var paramChildNode = paramNode.childNodes[i];
              if (paramChildNode.nodeType != 1){
                continue;
              }
              
              var validator = maskat.getValidator(false);

              var parserFunc = maskat.intprSendTele;
              if (paramChildNode.prefix && paramChildNode.prefix != ""){
                var parserFuncName = "maskat." + paramChildNode.prefix + "SendTeleParser";
                parserFunc = eval(parserFuncName);
                if (!parserFunc){
                  throw new MaskatError({name: "Extended Syntax Error",
                                         message: "Ǝg^O'" + paramChildNode.nodeName + "'𗘗pɂ͐pp[TƂ'" + parserFuncName + "'֐`Kv܂B",
                                         fileName: "intpr.js",
                                         functionName: "maskat.autoGenEventFunc"});
                }
              }

              try{
                sendXML += parserFunc(paramChildNode, validator);
              }
              catch (e){
                if (e instanceof maskat.ValidationError){
                  validator.acceptError(e);
                }
                else {
                  throw e;
                }
              }
              if (validator.errors.length > 0){
                if (maskat.validationErrorHandler){
                  maskat.validationErrorHandler(validator.errors);
                }
                return;
              }
            }
            
            sendXML += '</' + rootNode + '>';

            var soap = maskat.xpath(paramNode, '@soap');
            if (soap=="true"){
                sendXML = maskat.soap.wrapMessage(sendXML,paramNode);
            }

            sendXML = '<?xml version="1.0" encoding="UTF-8"?>' + sendXML;
          }

          maskat.asyncTele(sendXML, eventNode, eventDefDOM, IDs, soap);
        }
        catch (e){
          // ɃG[throwłȂ̂(ĂяoWebuEUƂȂ)Aalerto͂
          if (e instanceof MaskatError){
            alert("CxgsɃG[܂B"
                 + "\nname: " + e.name + "\nmessage: " + e.message
                 + "\nfileName: " + e.fileName + "\nfunctionName: " + e.functionName);
          }
          else if (e instanceof MaskatProcessInterruption){
            // Do Nothing
          }
          else{
            throw e;
          }
        }
      }
    }
  }
  catch (e){
    throw e;
  }
}

maskat.parseLocalTarget = function(targetNode){
  try {
    var inName = maskat.xpath(targetNode, '@in');
    var inObj = maskat.getObjByName(inName);
    var inObjWrap;
    if (inObj){
      inObjWrap = new ObjWrapper(inObj);
    }

    var outName = maskat.xpath(targetNode, '@out');
    var outObj = maskat.getObjByName(outName);
    var outObjWrap;
    if (outObj){
      outObjWrap = new ObjWrapper(outObj);
    }

    if (!inName && outObjWrap){
      // outl̃IuWFNgNA
      outObjWrap.clear();
    }
    else if (inObjWrap && outObjWrap){
      // TODO: in,out҂PlIuWFNgł邩̃`FbN
      outObjWrap.setSingleValue(inObjWrap.getSingleValue());
    }
    else if (inObjWrap && outName && !outObjWrap){
      eval(outName + " = inObjWrap.getSingleValue();");
    }    
    else {
      throw new MaskatError({name: "Mapping Error",
                             message: "in'" + inName + "'out'" + outName + "'ւ̃}bsOɑΉĂ܂B",
                             fileName: "intpr.js",
                             functionName: "maskat.parseLocalTarget"});
    }
  }
  catch (e){
    throw e;
  }
}

maskat.intprSendTele = function(sourceNode, validator){
  try {
    var objName = maskat.xpath(sourceNode, '@obj');
    var objObj = maskat.getObjByName(objName);

    if (!objObj){
      throw new MaskatError({name: "Mapping Error",
                             message: "MIuWFNg'" + objName + "'`łB",
                             fileName: "intpr.js",
                             functionName: "maskat.intprSendTele"});
    }
    
    var objObjWrap = new ObjWrapper(objObj);

    if (objObjWrap.isSingleDataObj()){
      //// Pl𑗐M
      
      var value = objObjWrap.getSingleValue();

      var typeName = maskat.xpath(sourceNode, '@type');
      var descName = maskat.xpath(sourceNode, '@desc');

      var sendBlankElementName = maskat.xpath(sourceNode, '@sendBlankElement');

      // 󔒂̓̓tB[hXMLvf𐶐Ȃ
      if ((value && value != "") || sendBlankElementName == "true"){
        var nodeName = maskat.xpath(sourceNode, '@node');
        
        var minName = maskat.xpath(sourceNode, '@min');
        var maxName = maskat.xpath(sourceNode, '@max');
        
        var regexp = maskat.xpath(sourceNode, '@regexp');
        
        validator.validate(objName, value, typeName, descName, minName, maxName, regexp);
        return "<" + nodeName + ">" + value + "</" + nodeName + ">";  // TODO: valuetoParamStr?
      }
      else {
        if (typeName == "required"){
          var vTarget = new Object;
          vTarget.desc = descName;
          validator.acceptError(new maskat.ValidationError(vTarget, "͂ĂB"));
        }
        else {
          return "";
        }
      }
    }
    else if (objObjWrap.isMultiDataObj()){
      var fromkeyName = maskat.xpath(sourceNode, '@fromkey');
      var idxRefName = maskat.xpath(sourceNode, '@idxRef');

      if (fromkeyName){
        //// Is(ŋߑI1s)̓̒l(Pl)𑗐M

        var selectedIndex = objObjWrap.getSelectedIndex();
        if (selectedIndex != -1){
        
          var targetObjWrap = objObjWrap;
        
          var idxRefName = maskat.xpath(sourceNode, '@idxRef');  // TODO: d錾
          var idxRefObj = maskat.getObjByName(idxRefName);
          if (idxRefObj){
            var idxRefObjWrap = new ObjWrapper(idxRefObj);
            if (!idxRefObjWrap.isMultiDataObj()){
              throw new MaskatError({name: "Mapping Error",
                                     message: "idxRef͕f[^^IuWFNgw肵ĉ",  // TODO:ڍׂ
                                     fileName: "intpr.js",
                                     functionName: "maskat.intprSendTele"});
            }
            targetObjWrap = idxRefObjWrap;
          }

          var value = targetObjWrap.getValueFromMultiData(selectedIndex, fromkeyName);
         
          var sendBlankElementName = maskat.xpath(sourceNode, '@sendBlankElement');
      
          if ((value && value != "") || sendBlankElementName == "true"){
            var nodeName = maskat.xpath(sourceNode, '@node');
            return "<" + nodeName + ">" + value + "</" + nodeName + ">";  // TODO: valuetoParamStr?
          }
        }
      }
      else if (idxRefName){
        //// Isf[^̑M

        if (objObjWrap.isMultiSelect()){
          // sI
          
          var childNodeName = maskat.xpath(sourceNode, '@childNode');
          if (!childNodeName){
            throw new MaskatError({name: "EventXML Syntax Error",
                                   message: "sIf[^̑M}bsO̍ۂɂ́AchildNode̎w肪K{łB",  // TODO:ڍׂ
                                   fileName: "intpr.js",
                                   functionName: "maskat.intprSendTele"});
          }
          var nodeName = maskat.xpath(sourceNode, '@node');
          
          var indexArray = objObjWrap.getSelectedIndexes();
          
          var bindNodes = maskat.xpath(sourceNode, 'bind');
          if (bindNodes.length == 0){
            return "";
          }
          var bindMapping = new Object();
          for (i = 0; i < bindNodes.length; i++){
            var bindNode = bindNodes[i];
            var fromkeyValue = maskat.xpath(bindNode, '@fromkey');
            var nodeValue = maskat.xpath(bindNode, '@node');
            bindMapping[fromkeyValue] = nodeValue;
          }

          var targetObjWrap = objObjWrap;

          var idxRefName = maskat.xpath(sourceNode, '@idxRef');
          var idxRefObj = maskat.getObjByName(idxRefName);
          if (idxRefObj){
            var idxRefObjWrap = new ObjWrapper(idxRefObj);
            if (!idxRefObjWrap.isMultiDataObj()){
              throw new MaskatError({name: "Mapping Error",
                                     message: "idxRef͕f[^^IuWFNgw肵ĉ",  // TODO:ڍׂ
                                     fileName: "intpr.js",
                                     functionName: "maskat.intprSendTele"});
            }
            targetObjWrap = idxRefObjWrap;
          }
          
          var resultXML = "";

          var sendBlankElementName = maskat.xpath(sourceNode, '@sendBlankElement');

// TODO: toParamStr
          
          for (var i = 0; i < indexArray.length; i++){
            var resultXMLRow = "";
            for (var fromkeyValue in bindMapping){
              var value = targetObjWrap.getValueFromMultiData(indexArray[i], fromkeyValue);
              if ((value && value != "") || sendBlankElementName == "true"){
                resultXMLRow += "<" + bindMapping[fromkeyValue] + ">" + value + "</" + bindMapping[fromkeyValue] + ">";
              }
            }
            if (resultXMLRow != ""){
              resultXMLRow = "<" + childNodeName + ">" + resultXMLRow + "</" + childNodeName + ">";
            }
            resultXML += resultXMLRow;
          }
          if (resultXML != ""){
            resultXML = "<" + nodeName + ">" + resultXML + "</" + nodeName + ">";
          }
          
          return resultXML;
        }
        else {
          // PsI

          var index = objObjWrap.getSelectedIndex();
          if (index == -1){
            return "";
          }
          
          var nodeName = maskat.xpath(sourceNode, '@node');
          
          var bindNodes = maskat.xpath(sourceNode, 'bind');
          if (bindNodes.length == 0){
            return "";
          }
          var bindMapping = new Object();
          for (i = 0; i < bindNodes.length; i++){
            var bindNode = bindNodes[i];
            var fromkeyValue = maskat.xpath(bindNode, '@fromkey');
            var nodeValue = maskat.xpath(bindNode, '@node');
            bindMapping[fromkeyValue] = nodeValue;
          }
          
          var targetObjWrap = objObjWrap;

          var idxRefName = maskat.xpath(sourceNode, '@idxRef');
          var idxRefObj = maskat.getObjByName(idxRefName);
          if (idxRefObj){
            var idxRefObjWrap = new ObjWrapper(idxRefObj);
            if (!idxRefObjWrap.isMultiDataObj()){
              throw new MaskatError({name: "Mapping Error",
                                     message: "idxRef͕f[^^IuWFNgw肵ĉ",  // TODO:ڍׂ
                                     fileName: "intpr.js",
                                     functionName: "maskat.intprSendTele"});
            }
            targetObjWrap = idxRefObjWrap;
          }
          
          var resultXML = "";
          
          var sendBlankElementName = maskat.xpath(sourceNode, '@sendBlankElement');
          
// TODO: toParamStr
          for (var fromkeyValue in bindMapping){
            var value = targetObjWrap.getValueFromMultiData(index, fromkeyValue);
            if ((value && value != "") || sendBlankElementName == "true"){
              resultXML += "<" + bindMapping[fromkeyValue] + ">" + value + "</" + bindMapping[fromkeyValue] + ">";
            }
          }

          resultXML = "<" + nodeName + ">" + resultXML + "</" + nodeName + ">";
  
          return resultXML;
        }
      }
      else {
        // f[^^̃f[^SĂ𑗐M

        var childNodeName = maskat.xpath(sourceNode, '@childNode');
        if (childNodeName){
          // TODO: MaskatError
        }
        var nodeName = maskat.xpath(sourceNode, '@node');
      
        var bindNodes = maskat.xpath(sourceNode, 'bind');
        if (bindNodes.length == 0){
          return "";
        }
        var bindMapping = new Object();
        for (var i = 0; i < bindNodes.length; i++){
          var bindNode = bindNodes[i];
          var fromkeyValue = maskat.xpath(bindNode, '@fromkey');
          var nodeValue = maskat.xpath(bindNode, '@node');
          bindMapping[fromkeyValue] = nodeValue;
        }

        var resultXML = "";
        
        var sendBlankElementName = maskat.xpath(sourceNode, '@sendBlankElement');
        
// TODO: toParamStr
        for (i = 0; i < objObjWrap.getRowNum(); i++){
          var resultXMLRow = "";
          for (var fromkeyValue in bindMapping){
            var value = objObjWrap.getValueFromMultiData(i, fromkeyValue);
            if ((value && value != "") || sendBlankElementName == "true"){
              resultXMLRow += "<" + bindMapping[fromkeyValue] + ">" + value + "</" + bindMapping[fromkeyValue] + ">";
            }
          }
          if (resultXMLRow != ""){
            resultXMLRow = "<" + childNodeName + ">" + resultXMLRow + "</" + childNodeName + ">";
          }
          resultXML += resultXMLRow;
        }
        if (resultXML != ""){
          resultXML = "<" + nodeName + ">" + resultXML + "</" + nodeName + ">";
        }
        return resultXML;
      }
    }
  }
  catch (e){
    throw e;
  }
}

maskat.toParamStr = function(obj){
    if (obj==null || obj==undefined){
        return "";
    }
    return obj.toString();
}


maskat.intprRecvTele = function(eventNode, teleDOM){
  try {
    var eventType = maskat.xpath(eventNode, '@type');
    var resultNodes = maskat.xpath(eventNode, 'result');
    var resultNode;
    if (resultNodes.length == 1){
      resultNode = resultNodes[0];
    }
    
    if (teleDOM.nodeName == "errors"){
      var onErrorTele;
      if (resultNode){
        onErrorTele = maskat.xpath(resultNode, '@onErrorTele');
      }
      
      if (onErrorTele){
        try {
          eval(onErrorTele + "(teleDOM);");
        }
        catch (e){
          throw new MaskatError({name: "onErrorTele Error",
                                 message: "onErrorTele֐`Ă܂B",
                                 fileName: "intpr.js",
                                 functionName: "maskat.intprRecvTele"});
        }
      }
      else {
        // ftHg̃G[d֐ŏ
        maskat.processErrorTele(teleDOM);
      }
      return;
    }
    else if (resultNode) {
      var rootNode = maskat.xpath(resultNode, '@rootNode');
      var soap = maskat.xpath(resultNode, '@soap');
      if (soap=="true"){
          teleDOM = maskat.soap.unwrapDOM(teleDOM,resultNode);
      }
      
      if (teleDOM.nodeName != rootNode){
        throw new MaskatError({name: "Received Tele Error",
                               message: "MdXML̃[gm[h'" + teleDOM.nodeName + "'ƃCxg`XMLŎw肵MdXML̃[gm[h'" + rootNode + "'vĂ܂B",
                               fileName: "intpr.js",
                               functionName: "maskat.intprRecvTele"});
      }
      else{
        var eventNodeType = maskat.xpath(eventNode, '@type');
        var targetNodes = maskat.xpath(resultNode, 'target');
        for (var i = 0; i < targetNodes.length; i++){
          var targetNode = targetNodes[i];
          var targetNodeType = maskat.xpath(targetNode, '@type');
          if (targetNodeType != "local" && eventNodeType != "local"){
            maskat.parseRemoteTarget(targetNode, teleDOM);
          }
          else {
            maskat.parseLocalTarget(targetNode);
          }
        }
      }
    }

    maskat.finishFunc(eventNode);
  }
  catch (e){
    throw e;
  }
}

maskat.parseRemoteTarget = function(targetNode, teleDOM){
  try {
    var outName = maskat.xpath(targetNode, '@out');
    var outObj = maskat.getObjByName(outName);
    var outObjWrap;
    if (outObj){
      outObjWrap = new ObjWrapper(outObj);
    }

    // Md̃f[^`ƁAo͐IuWFNg̎󂯓\f[^`Ƃ̐`FbN
    var isInSingleData = false;
    var isInMultiData = false;
    var isOutJSObj = false;
    var isOutSingleData = false;
    var isOutMultiData = false;
    if (maskat.xpath(targetNode, '@inkey')){
      isInMultiData = true;
    }
    else {
      isInSingleData = true;
    }
    if (!outObjWrap || outObjWrap.isJSObj()){
      isOutJSObj = true;
    }
    if (outObjWrap && outObjWrap.isSingleDataObj()){
      isOutSingleData = true;
    }
    else if (outObjWrap && outObjWrap.isMultiDataObj()){
      isOutMultiData = true;
    }
    if (!(isOutJSObj || (isInSingleData && isOutSingleData) || (isInMultiData && isOutMultiData))){
      var inDataType = "Ή^";
      var outDataType = "Ή^";
      if (isInSingleData){
        inDataType = "Pf[^^";
      }
      else if (isInMultiData){
        inDataType = "f[^^";
      }
      if (isOutSingleData && isOutMultiData){
        outDataType = "P/pf[^^";
      }
      else if (isOutSingleData){
        outDataType = "Pf[^^";
      }
      else if (isOutMultiData){
        outDataType = "f[^^";
      }
      throw new MaskatError({name: "Mapping Error",
                             message: "Md̃f[^`(" + inDataType + ")ƁAo͐IuWFNg̎󂯓\f[^`(" + outDataType + ")vĂ܂B",
                             fileName: "intpr.js",
                             functionName: "maskat.parseRemoteTarget"});
    }

    // Mdf[^擾
    var inData;
    if (isInSingleData){
      inData = maskat.xpath(teleDOM, maskat.xpath(targetNode, '@in') + '/text()');
    }
    else if (isInMultiData){
      var i;
      var bindNodes = maskat.xpath(targetNode, 'bind');
      var bindMapping;
      if (bindNodes.length != 0){
        bindMapping = new Object();
        for (i = 0; i < bindNodes.length; i++){
          var bindNode = bindNodes[i];
          var tokeyValue = maskat.xpath(bindNode, '@tokey');
          var nodeValue = maskat.xpath(bindNode, '@node');
          bindMapping[nodeValue] = tokeyValue;
        }
      }
 
      var inValue = maskat.xpath(targetNode, '@in');
      var inkeyValue = maskat.xpath(targetNode, '@inkey');
      var teleRowNodes = maskat.xpath(teleDOM, inValue + "[1]/" + inkeyValue);
      if (teleRowNodes.length == 0){
        // Mdgridf[^
        return;
      }

      var inData = new Array(teleRowNodes.length);
      for (i = 0; i < inData.length; i++){
        inData[i] = new Object();
      }

      if (bindMapping){
        for (i = 0; i < teleRowNodes.length; i++){
          var teleRowNode = teleRowNodes[i];
          for (var nodeValue in bindMapping){
            var colNodes = maskat.xpath(teleRowNode, nodeValue);
            if (colNodes.length == 1){
              inData[i][bindMapping[nodeValue]] = maskat.xpath(colNodes[0], "text()");
            }
          }
        }
      }
      else {
        for (i = 0; i < teleRowNodes.length; i++){
          var teleRowNode = teleRowNodes[i];
          for (var j = 0; j < teleRowNode.childNodes.length; j++){
            if (teleRowNode.childNodes[j].nodeType != 1){
              continue;
            }
            inData[i][teleRowNode.childNodes[j].nodeName] = teleRowNode.childNodes[j].childNodes[0].nodeValue;
          }
        }
      }
    }

    /*
    // Mdf[^̃fobOo
    if (maskat.isArray(inData)){
      for (var i = 0; i < inData.length; i++){
        for (var j in inData[i]){
          alert(inData[i][j]);
        }
      }
    }
    else{
      alert(inData);
    }
    */

    // o͐IuWFNgɎMdf[^ݒ
    if (isOutJSObj){
      eval(outName + " = inData");
    }
    else if (outObjWrap && outObjWrap.isSingleDataObj()){
      outObjWrap.setSingleValue(inData);
    }
    else if (outObjWrap && outObjWrap.isMultiDataObj()){
      outObjWrap.setMultiValue(inData);
    }
  }
  catch (e){
    throw e;
  }
}

//O[o͈͂nameϐ擾A`Ȃ΁Aundefined߂lƂ
maskat.getObjByName = function(name){
  var obj;
  try{
    obj = eval(name);
  }
  catch (e){
  }
  return obj;
}


// ftHg̃G[d֐
maskat.processErrorTele = function(teleDOM){
  try {
    var errorCodeText = maskat.xpath(teleDOM, 'error/errorCode/text()');
    var messageCodeText = maskat.xpath(teleDOM, 'error/messageCode/text()');
    var messageText = maskat.xpath(teleDOM, 'error/message/text()');
    var infoText = maskat.xpath(teleDOM, 'error/info/text()');
    var systemErrorMessageText = maskat.xpath(teleDOM, 'error/systemErrorMessage/text()');

    var errorMsg = "G[܂B\nerrorCode:" + errorCodeText + "\nmessageCode:"
                   + messageCodeText + "\nmessage:" + messageText;
    if (infoText){
      errorMsg += "\ninfo:" + infoText;
    }
    if (systemErrorMessageText){
      errorMsg += "\nsystemErrorMessage:" + systemErrorMessageText;
    }

    throw new MaskatError({name: "Received Tele Error",
                           message: errorMsg,
                           fileName: "intpr.js",
                           functionName: "maskat.processErrorTele"});
  }
  catch (e){
    throw e;
  }
}





// ʐMŃT[oXMLt@C擾ADOMdocumentElementԂ
maskat.loadXMLFile = function(xmlFile){
  var xhr;
  try {
    xhr = new ActiveXObject("Msxml2.XMLHTTP");
  } catch (e) {
    try {
      xhr = new ActiveXObject("Microsoft.XMLHTTP");
    } catch (e) {
      xhr = false;
    }
  }
  if (!xhr && typeof XMLHttpRequest != 'undefined') {
    xhr = new XMLHttpRequest();
  }
  if (xhr) {
    xhr.open("GET", xmlFile, false);
    xhr.send(null);
    if (xhr.readyState == 4){
      if (xhr.status == 200) {
        if (xhr.responseXML && xhr.responseXML.nodeType == 9){
          return(xhr.responseXML.documentElement);
        }
        else {
          throw new MaskatError({name: "File Error",
                               message: "T[o擾t@C'" + xmlFile + "'KXMLł͂܂B\nt@C̃eLXg: " + xhr.responseText,
                               fileName: "intpr.js",
                               functionName: "maskat.loadXMLFile"});
        }
      }
      else {
        throw new MaskatError({name: "XMLHttpRequest Error",
                               message: "T[ot@C'" + xmlFile + "'𐳏Ɏ擾ł܂łB\nXMLHttpRequest#readyState: " + xhr.readyState + "\nXMLHttpRequest#status: " + xhr.status,
                               fileName: "intpr.js",
                               functionName: "maskat.loadXMLFile"});
      }
    }
  }
  else{
    throw new MaskatError({name: "XMLHttpRequest Error",
                           message: "XMLHttpRequestIuWFNg擾ł܂łB",
                           fileName: "intpr.js",
                           functionName: "maskat.loadXMLFile"});
  }
}

maskat.asyncTele = function(data, eventNode, eventDefDOM, IDs, soap){
  try {
    // XMLHttpRequestIuWFNg̎擾
    var xhr;
    try {
      xhr = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
      try {
        xhr = new ActiveXObject("Microsoft.XMLHTTP");
      } catch (e) {
        xhr = false;
      }
    }
    if (!xhr && typeof XMLHttpRequest != 'undefined') {
      xhr = new XMLHttpRequest();
    }
    if (!xhr) {
      throw new MaskatError({name: "XMLHttpRequest Error",
                             message: "XMLHttpRequestIuWFNg擾ł܂łB",
                             fileName: "intpr.js",
                             functionName: "maskat.asyncTele"});
    }

    // remoteUrll̎擾
    var remoteUrl = maskat.xpath(eventNode, '@remoteUrl');
    if (!remoteUrl){
      remoteUrl = maskat.xpath(eventDefDOM, 'remoteUrl/@url');
      if (!remoteUrl){
        throw new MaskatError({name: "EventXML Syntax Error",
                               message: "[gʐMCxgvfɑ΂ĂremoteUrl̎w肪K{łB",
                               fileName: "intpr.js",
                               functionName: "maskat.autoGenEventFunc"});
      }
    }

    // asyncl̎擾
    var async = maskat.xpath(eventNode, '@async');
    xhr.open("POST", remoteUrl, true);  // async=true(ʐM)łIɂ͔񓯊ʐMs

    // R[obN֐̐ݒ
    var callbackFunc = maskat.autoCallBackFunc(eventNode, xhr);
    xhr.onreadystatechange = callbackFunc;

    // wb_
    var headerNodes = maskat.xpath(eventNode, 'header');
    for (var i = 0; i < headerNodes.length; i++){
      xhr.setRequestHeader(maskat.xpath(headerNodes[i], '@name'), maskat.xpath(headerNodes[i], '@value'));
    }
    headerNodes = maskat.xpath(eventDefDOM, 'header');
    for (var i = 0; i < headerNodes.length; i++){
      xhr.setRequestHeader(maskat.xpath(headerNodes[i], '@name'), maskat.xpath(headerNodes[i], '@value'));
    }
    if (soap=="true"){
       xhr.setRequestHeader("Content-Type", "application/soap+xml");
    }
    else {
       xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    }
    if (IDs.component){
      xhr.setRequestHeader("maskat_componentID", IDs.component);
    }
    xhr.setRequestHeader("maskat_eventID", IDs.event);

    maskat.beforeFunc(eventNode, xhr, data, IDs);

    var _maskat_connecting_popup;
    var _maskat_connecting_label;

    if (async == "false"){
      _maskat_connecting_popup = new rialto.widget.PopUp('_maskat_connecting_popup', 50, 50, 250, 50,
          null, 'ʐM', 'Transparent', null, true, null);
      _maskat_connecting_label = new rialto.widget.Label('_maskat_connecting_label', 10, 10,
          _maskat_connecting_popup, 'ʐMłB΂炭҂B', null,
          {name:'_maskat_connecting_label', top:10, left:10, text:'ʐMłB΂炭҂B',
          parent:_maskat_connecting_popup});
    }
    
    maskat.tempVar = new Object();
    maskat.tempVar.xhr = xhr;
    maskat.tempVar.async = async;
    maskat.tempVar._maskat_connecting_popup = _maskat_connecting_popup;
    
    var timeout = maskat.xpath(eventNode, '@timeout');
    maskat.tempVar.timeout = timeout;
    
    if (timeout){
      var onTimeoutError = maskat.xpath(eventNode, '@onTimeoutError');
      if (onTimeoutError){
        try {
          onTimeoutError = eval(onTimeoutError);
        }
        catch (e){
          throw new MaskatError({name: "onTimeoutError Error",
                                 message: "onTimeoutError֐`Ă܂B",
                                 fileName: "intpr.js",
                                 functionName: "maskat.asyncTele"});
        }
      }
      else {
        // ftHgonTimeoutError֐ŏ
        onTimeoutError = maskat.defaultOnTimeoutError;
      }
    
      onTimeoutError = maskat.onTimeoutErrorWrapper(onTimeoutError);
    
      var timeoutErrorID = setTimeout(onTimeoutError, timeout);
      maskat.tempVar.timeoutErrorID = timeoutErrorID;
    }

    xhr.send(data);

    if (CrossBrowser.isFF && async == "false"){
      // FireFoxXMLHttpRequestʐMł̓R[obNƂonreadystatechange͌Ă΂Ȃ̂ŁAŖIɌĂ
      callbackFunc();
    }

  }
  catch (e){
    throw e;
  }
}

maskat.onTimeoutErrorWrapper = function(func){
  return function() {
    if (maskat.tempVar.async == "false"){
      maskat.tempVar._maskat_connecting_popup.remove();
    }
    maskat.tempVar.xhr.abort();
    
    var ret = func.apply(this, arguments);
    return ret;
  };
}

maskat.defaultOnTimeoutError = function(){
  alert("defaultOnTimeoutError");
}
  
maskat.autoCallBackFunc = function(eventNode, xhr){
  return function(){
    try{
      if (xhr.readyState == 4){
        if (xhr.status == 200){
          if (maskat.tempVar.async == "false"){
            maskat.tempVar._maskat_connecting_popup.remove();
          }
          if (maskat.tempVar.timeout){
            clearTimeout(maskat.tempVar.timeoutErrorID);
          }
          
          maskat.afterFunc(eventNode, xhr);
          maskat.intprRecvTele(eventNode, xhr.responseXML.documentElement);
        }
        else if (xhr.status == 0){
          // timeoutG[XHR#abort
        }
        else{
          throw new MaskatError({name: "XMLHttpRequest Error",
                                 message: "T[oMd𐳏Ɏ擾ł܂łB\nXHR#readyState: " + xhr.readyState + "\nXHR#status: " + xhr.status,
                                 fileName: "intpr.js",
                                 functionName: "maskat.autoCallBackFunc"});
        }
      }
    }
    catch (e){
      // ɃG[throwłȂ̂(񓯊ʐMmaskat.autoCallBackFunc
      // ĂяoWebuEUƂȂ)Aalerto
      if (e instanceof MaskatError){
        alert("maskat.autoCallBackFuncĂяoɃG[܂B"
             + "\nname: " + e.name + "\nmessage: " + e.message
             + "\nfileName: " + e.fileName + "\nfunctionName: " + e.functionName);
      }
      else if (e instanceof MaskatProcessInterruption){
        // Do Nothing
      }
      else{
        throw e;
      }
    }
  };
}


maskat.startFunc = function(eventNode, IDs){
  try {
    var startFunc = maskat.xpath(eventNode, '@start');
    if (startFunc){
      var param = new Object();
      param.stopProcess = false;
      try{
        eval(startFunc + "(param);");
      }
      catch (e){
        throw e;  // TODO: MaskatErrorɕύXHIDsp
      }
      if (param.stopProcess){
        throw new MaskatProcessInterruption(
          {name: "Start Function Interruption",
           message: "componentID'" + IDs.component + "',eventID'" + IDs.event + "'start֐ŏ~",
           fileName: "intpr.js",
           functionName: "maskat.startFunc"});
      }
    }
  }
  catch (e){
    throw e;
  }
}

maskat.beforeFunc = function(eventNode, xhr, sendXML, IDs){
  try {
    var beforeFunc = maskat.xpath(eventNode, '@before');
    if (beforeFunc){
      var param = new Object();
      param.stopProcess = false;
      param.xhr = xhr;
      param.sendXML = sendXML;
      try{
        eval(beforeFunc + "(param);");
      }
      catch(e){
        throw e;  // TODO: MaskatErrorɕύXH
      }
      if (param.stopProcess){
        throw new MaskatProcessInterruption(
          {name: "Before Function Interruption",
           message: "componentID'" + IDs.component + "',eventID'" + IDs.event + "'before֐ŏ~",
           fileName: "intpr.js",
           functionName: "maskat.beforeFunc"});
      }
    }
  }
  catch (e){
    throw e;
  }
}

maskat.afterFunc = function(eventNode, xhr){
  try {
    var afterFunc = maskat.xpath(eventNode, '@after');
    if (afterFunc){
      var param = new Object();
      param.stopProcess = false;
      param.xhr = xhr;
      try{
        eval(afterFunc + "(param);");
      }
      catch(e){
        alert(e);  // TODO: G[IuWFNg
      }
      if (param.stopProcess){
        throw new MaskatProcessInterruption(
          {name: "After Function Interruption",
           message: "componentID'" + IDs.component + "',eventID'" + IDs.event + "'after֐ŏ~",
           fileName: "intpr.js",
           functionName: "maskat.afterFunc"});
      }
    }
  }
  catch (e){
    throw e;
  }
}

maskat.finishFunc = function(eventNode){
  try {
    var finishFunc = maskat.xpath(eventNode, '@finish');
    if (finishFunc){
      try{
        eval(finishFunc + "();");
      }
      catch(e){
        alert(e.message);  // TODO: G[IuWFNgԂ
      }
    }
  }
  catch (e){
    throw e;
  }
}

/* Mask@XPath
   EP[VpX͑΃P[VpX̂ݎw\B
   E(axis)childattributê݁Bchildattribute͂ꂼȗL@̂(child:(ȗĉȂ), attribute: @)
   Em[heXg(nodetest)͗vf(child̏ꍇ)A(attributȅꍇ)A'text()'̂
   Eq(predicate)childɑ΂Ă̂ݗp\
   Eq[n][@name="value"]̂݁BLq𕡐ׂĎw肷邱Ƃ֎~B
   E[] q[n]n1-indexB[n܂ł͂ȂB
   Mask@XPathg
   Eattribute̓P[VXebv̍ŌAPNodeɑ΂Ă̂ݗp\B
     ̏ꍇA߂l͑̕B`ĂȂꍇnullB
   Etext()m[heXg̓P[VXebv̍ŌAPeNodeɑ΂Ă̂ݗp\B
     ̏ꍇA߂l̓eLXgB
   EP[VXebv̍ŌɏqꂪgĂꍇA߂l͒PNodeƂ(qꂪ}b`ȂnullԂ)B
   Ȇ̏ꍇ̖߂l: NodeW
*/

maskat.xpath = function(dom, locationPath){
  var locationStep = locationPath.split("/");
  var i;
  var j;
  var k;
  
  if (!dom || dom.nodeType != 1){  // ELEMENT_NODE
    throw new MaskatError({name: "Mask@XPath Syntax Error",
                           message: "domsłBdomɂDOM̗vfm[hw肵ĉB",
                           fileName: "intpr.js",
                           functionName: "maskat.xpath"});
  }
  
  var domArray = new Array();

  domArray.push(dom);
  
  var isLastPredicate = false;
  
  for (i = 0; i < locationStep.length; i++){
    var domNextArray = new Array();
    for (j = 0; j < domArray.length; j++){

      // attributȅꍇ
      if (locationStep[i].charAt(0) == "@"){
        if (i != locationStep.length - 1 || domArray.length != 1){
          throw new MaskatError({name: "Mask@XPath Syntax Error",
                                 message: "attribute̓P[VXebv̍ŌAPNodeɑ΂Ă̂ݗp\łB\nG[P[VpX: " + locationPath,
                                 fileName: "intpr.js",
                                 functionName: "maskat.xpath"});
        }
        else {
          var attributeName = locationStep[i].substring(1, locationStep[i].length);
          var attributeNode = domArray[j].getAttributeNode(attributeName);
          if (attributeNode){
            // ɑl()Ԃ
            return attributeNode.nodeValue;
          }
          else {
            // ݒ肳ĂȂꍇ͂nullԂ
            return null;
          }
        }
      }
      
      // m[heXgtext()child̏ꍇ
      else if (locationStep[i] == "text()"){
        if (i != locationStep.length - 1 || domArray.length != 1){
          throw new MaskatError({name: "Mask@XPath Syntax Error",
                                 message: "text()m[heXg̓P[VXebv̍ŌAPeNodeɑ΂Ă̂ݗp\łB\nG[P[VpX: " + locationPath,
                                 fileName: "intpr.js",
                                 functionName: "maskat.xpath"});
        }
        else {
          if (domArray[j].childNodes && domArray[j].childNodes.length == 1
                                     && domArray[j].childNodes[0].nodeType == 3){  // TEXT_NODE
            return domArray[j].childNodes[0].nodeValue;
          }
          else if (domArray[j].childNodes && domArray[j].childNodes.length == 0){
            return "";
          }
          else {
            throw new MaskatError({name: "Mask@XPath Syntax Error",
                                   message: "text()m[heXgw肵m[hXML`słB\nG[P[VpX: " + locationPath,
                                   fileName: "intpr.js",
                                   functionName: "maskat.xpath"});
          }
        }
      }
      
      // m[heXgvfchild̏ꍇ
      else{

        var nodeTest = null;
        var predicate = null;
        var predicateAttributeName = null;
        var predicateAttributeValue = null;
        var nodePos = 0;
    
        if (locationStep[i].indexOf("[") != -1){
          nodeTest = locationStep[i].substring(0, locationStep[i].indexOf("["));
          predicate = locationStep[i].substring(locationStep[i].indexOf("[") + 1, locationStep[i].indexOf("]"));

          if (predicate.charAt(0) == "@"){
            predicateAttributeName = predicate.substring(1, predicate.indexOf("="));
            predicateAttributeValue = predicate.substring(predicate.indexOf("=") + 2, predicate.length - 1); // _uNH[ĝƂlɓ
          }
          else {
            nodePos = parseInt(predicate);
            if (isNaN(nodePos)){
              throw new MaskatError({name: "Mask@XPath Syntax Error",
                                     message: "qꂪsłB\nG[P[VpX: " + locationPath,
                                     fileName: "intpr.js",
                                     functionName: "maskat.xpath"});
            }
          }
          
          if (i == locationStep.length - 1){
            isLastPredicate = true;
          }
          
        }
        else{
          nodeTest = locationStep[i];
        }
        
        var currentNodePos = 0;  // q[n]邽߂ɗp

        for (k = 0; k < domArray[j].childNodes.length; k++){
          var childNode = domArray[j].childNodes[k];
          if (childNode.nodeType != 1){  // ELEMENT_NODE
            continue;
          }
          if (childNode.nodeName == nodeTest){
            currentNodePos++;
            if (predicate){
              if (predicateAttributeName){
                if (childNode.getAttribute(predicateAttributeName) != predicateAttributeValue){
                  continue;
                }
                else if (isLastPredicate){
                  return childNode;
                }
              }
              else {
                if (nodePos != currentNodePos){
                  continue;
                }
                else if (isLastPredicate){
                  return childNode;
                }
              }
            }
            domNextArray.push(childNode);
          }
        }
      }
    }
    domArray = domNextArray;
  }

  if (isLastPredicate){
    return null;
  }
  else {
    return domArray;
  }
}

