/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.kaoriha.marimite.viewer.Main;
import org.kaoriha.marimite.viewer.chart.ChartUtil;
import org.kaoriha.marimite.viewer.chart.Updater;
import org.kaoriha.marimite.viewer.dnd.DnDableTabDialog;
import org.kaoriha.marimite.viewer.jmx.JmxRemote;

public class LimitDialog
extends JDialog {
    private List<String> sectionList;
    private List<String> limitedSectionList;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextField limitTextField;
    private JList sectionJList;
    private JButton viewButton;

    public LimitDialog() {
        this.initComponents();
        this.setLocationByPlatform(true);
        try {
            this.initSectionList(JmxRemote.getConnection());
        }
        catch (Exception e) {
            JmxRemote.notifyLostConnection();
            JOptionPane.showMessageDialog(this, "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af \u30a8\u30e9\u30fc - Marimite", 0);
            this.dispose();
            return;
        }
        this.updateSectionList();
    }

    private void initSectionList(MBeanServerConnection connection) throws IOException, ReflectionException, InstanceNotFoundException {
        String[] currentSectionArray;
        String[] logSectionArray;
        HashSet<String> sectionSet = new HashSet<String>();
        String[] arg = new String[]{"SectionList"};
        AttributeList attributeList = connection.getAttributes(JmxRemote.MONITOR_LOG_OBJNAME, arg);
        Attribute attribute = (Attribute)attributeList.get(0);
        for (String s : logSectionArray = (String[])attribute.getValue()) {
            sectionSet.add(s);
        }
        attributeList = connection.getAttributes(JmxRemote.MONITOR_LIVE_OBJNAME, arg);
        attribute = (Attribute)attributeList.get(0);
        for (String s : currentSectionArray = (String[])attribute.getValue()) {
            sectionSet.add(s);
        }
        sectionSet.removeAll(Updater.getAllViewingSectionSet());
        this.sectionList = new ArrayList<String>(sectionSet);
        Collections.sort(this.sectionList);
    }

    private void updateSectionList() {
        this.limitedSectionList = new ArrayList<String>();
        String cont = this.limitTextField.getText();
        if (cont.length() == 0) {
            this.limitedSectionList.addAll(this.sectionList);
        } else {
            for (String s : this.sectionList) {
                if (!s.contains(cont)) continue;
                this.limitedSectionList.add(s);
            }
        }
        this.sectionJList.setModel(new AbstractListModel(){
            String[] strings;
            {
                this.strings = LimitDialog.this.limitedSectionList.toArray(new String[0]);
            }

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.sectionJList = new JList();
        this.jLabel1 = new JLabel();
        this.limitTextField = new JTextField();
        this.viewButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u672a\u8868\u793a\u306e\u30bb\u30af\u30b7\u30e7\u30f3\u3092\u8868\u793a");
        this.sectionJList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.sectionJList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LimitDialog.this.sectionJListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.sectionJList);
        this.jLabel1.setText("\u30bb\u30af\u30b7\u30e7\u30f3\u306b\u542b\u307e\u308c\u308b\u6587\u5b57\u5217");
        this.limitTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                LimitDialog.this.limitTextFieldKeyTyped(evt);
            }
        });
        this.viewButton.setText("\u3059\u3079\u3066\u8868\u793a");
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LimitDialog.this.viewButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.limitTextField, -1, 242, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.viewButton).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.limitTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 228, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void limitTextFieldKeyTyped(KeyEvent evt) {
        this.updateSectionList();
    }

    private void sectionJListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() != 2) {
            return;
        }
        int selected = this.sectionJList.locationToIndex(evt.getPoint());
        this.createDialog(this.limitedSectionList.get(selected));
    }

    private void viewButtonActionPerformed(ActionEvent evt) {
        while (!this.limitedSectionList.isEmpty()) {
            this.createDialog(this.limitedSectionList);
        }
        this.dispose();
    }

    private void createDialog(String section) {
        DnDableTabDialog f = new DnDableTabDialog((Window)Main.getRootFrame(), UUID.randomUUID().toString());
        f.getTabbedPane().addTab(section, null, (Component)ChartUtil.getChartPanel(), null);
        f.setVisible(true);
    }

    private void createDialog(List<String> sectionList) {
        DnDableTabDialog f = new DnDableTabDialog((Window)Main.getRootFrame(), UUID.randomUUID().toString());
        int i = 0;
        Iterator<String> iter = sectionList.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            f.getTabbedPane().addTab(s, null, (Component)ChartUtil.getChartPanel(), null);
            iter.remove();
            if (++i <= 3) continue;
            break;
        }
        f.setVisible(true);
    }
}

