/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXParser {
    protected SAXParser() {
    }

    public abstract void setProperty(String var1, Object var2) throws SAXNotRecognizedException, SAXNotSupportedException;

    public abstract Object getProperty(String var1) throws SAXNotRecognizedException, SAXNotSupportedException;

    public void parse(InputStream inputStream, HandlerBase handlerBase) throws SAXException, IOException {
        this.parse(new InputSource(inputStream), handlerBase);
    }

    public void parse(InputStream inputStream, HandlerBase handlerBase, String string) throws SAXException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        this.parse(inputSource, handlerBase);
    }

    public void parse(InputStream inputStream, DefaultHandler defaultHandler) throws SAXException, IOException {
        this.parse(new InputSource(inputStream), defaultHandler);
    }

    public void parse(InputStream inputStream, DefaultHandler defaultHandler, String string) throws SAXException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        this.parse(inputSource, defaultHandler);
    }

    public void parse(String string, HandlerBase handlerBase) throws SAXException, IOException {
        this.parse(new InputSource(string), handlerBase);
    }

    public void parse(String string, DefaultHandler defaultHandler) throws SAXException, IOException {
        this.parse(new InputSource(string), defaultHandler);
    }

    public void parse(File file, HandlerBase handlerBase) throws SAXException, IOException {
        this.parse(new InputSource(new FileInputStream(file)), handlerBase);
    }

    public void parse(File file, DefaultHandler defaultHandler) throws SAXException, IOException {
        this.parse(new InputSource(new FileInputStream(file)), defaultHandler);
    }

    public void parse(InputSource inputSource, HandlerBase handlerBase) throws SAXException, IOException {
        Parser parser = this.getParser();
        parser.setDocumentHandler(handlerBase);
        parser.setDTDHandler(handlerBase);
        parser.setEntityResolver(handlerBase);
        parser.setErrorHandler(handlerBase);
        parser.parse(inputSource);
    }

    public void parse(InputSource inputSource, DefaultHandler defaultHandler) throws SAXException, IOException {
        XMLReader xMLReader = this.getXMLReader();
        xMLReader.setContentHandler(defaultHandler);
        xMLReader.setDTDHandler(defaultHandler);
        xMLReader.setEntityResolver(defaultHandler);
        xMLReader.setErrorHandler(defaultHandler);
        xMLReader.parse(inputSource);
    }

    public abstract Parser getParser() throws SAXException;

    public abstract XMLReader getXMLReader() throws SAXException;

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();
}

