/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.pref;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/**
 *
 * @author NAKAZATO Hajime
 */
public class WindowLocator {

    private static final Set<WindowLocator> INSTANCE_SET = new CopyOnWriteArraySet<WindowLocator>();
    private static final String LOCATION_MAP_KEY = "locationMap";
    private static ClientPreference PREF;
    private String key;
    private Window target;

    public static void init(String address, String path) {
        PREF = ClientPreference.getInstance(address, path);
    }

    public WindowLocator(String key, Window window) {
        this.key = key;
        this.target = window;
        window.setLocationByPlatform(true);
        loadLocation();
        INSTANCE_SET.add(this);
    }

    private static class Location implements Serializable {

        public Dimension dimension;
        public Point point;

        public Location() {
        }

        public Location(Dimension dimension, Point point) {
            this.dimension = dimension;
            this.point = point;
        }
    }

    @SuppressWarnings("unchecked")
    private static HashMap<String, Location> getLocationMap() {
        Object o = PREF.deserialize(LOCATION_MAP_KEY);
        if (o == null) {
            return new HashMap<String, Location>();
        }
        return new HashMap<String, Location>((Map<String, Location>) o);
    }

    private void loadLocation() {
        Map<String, Location> locationMap = getLocationMap();
        if (locationMap.containsKey(key)) {
            Location l = locationMap.get(key);
            target.setSize(l.dimension);
            target.setLocation(l.point);
        }
    }

    public static void shutdown() {
        HashMap<String, Location> locationMap = new HashMap<String, Location>();
        for (WindowLocator dl : INSTANCE_SET) {
            locationMap.put(dl.key, new Location(dl.target.getSize(), dl.target.getLocation()));
        }
        try {
            PREF.serialize(LOCATION_MAP_KEY, locationMap);
        } catch (IOException e) {
            // ignore
        }
        INSTANCE_SET.clear();
    }

    public void dispose() {
        INSTANCE_SET.remove(this);
    }
}
