/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.pref;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

/**
 *
 * @author NAKAZATO Hajime
 */
class JnlpImpl extends ClientPreference {

    private static final long ALLOC_UNIT = 4096;
    private static final PersistenceService PS;
    private static final String CODEBASE;
    private final String storeBase;

    static {
        BasicService bs;
        try {
            PS = (PersistenceService) ServiceManager.lookup("javax.jnlp.PersistenceService");
            bs = (BasicService) ServiceManager.lookup("javax.jnlp.BasicService");
        } catch (UnavailableServiceException e) {
            throw new RuntimeException(e);
        }
        CODEBASE = bs.getCodeBase().toString();
    }

    JnlpImpl(String path) {
        super();
        String sb = CODEBASE;
        if (!sb.endsWith("/")) {
            sb += "/";
        }
        sb += path + "_";
        storeBase = sb;
    }

    private URL getUrl(String key) throws MalformedURLException {
        return new URL(storeBase + key);
    }

    @Override
    public void serialize(String key, Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        long size = ((baos.size() / ALLOC_UNIT) + 1) * ALLOC_UNIT;
        boolean isFcOk = false;
        FileContents fc = null;
        URL url = getUrl(key);
        synchronized (this) {
            try {
                fc = PS.get(url);
                if (fc.getMaxLength() >= size) {
                    isFcOk = true;
                } else {
                    PS.delete(url);
                }
            } catch (FileNotFoundException e) {
            }
            if (!isFcOk) {
                long allocated = PS.create(url, size);
                if (allocated < size) {
                    throw new IOException("cannot allocate persistence size:" + size);
                }
                fc = PS.get(url);
            }

            OutputStream os = fc.getOutputStream(true);
            os.write(baos.toByteArray());
            os.close();
        }
    }

    @Override
    public Object deserialize(String key) {
        FileContents fc = null;
        try {
            URL url = getUrl(key);
            synchronized (this) {
                fc = PS.get(url);
                ObjectInputStream ois = new ObjectInputStream(fc.getInputStream());
                Object o = ois.readObject();
                ois.close();
                return o;
            }
        } catch (FileNotFoundException e) {
            return null;
        } catch (MalformedURLException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } catch (ClassNotFoundException e) {
            try {
                removeAll();
                return null;
            } catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    @Override
    public Object deserialize(String key, Object alt) {
        Object o = deserialize(key);
        if (o == null) {
            return alt;
        }
        return o;
    }

    @Override
    public void removeAll() throws IOException {
        synchronized (this) {
            try {
                for (String n : PS.getNames(new URL(CODEBASE))) {
                    PS.delete(new URL(n));
                }
            } catch (MalformedURLException ex) {
                Logger.getLogger(JnlpImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}
