/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;

/**
 *
 * @author NAKAZATO Hajime
 */
class TabTransfer implements Transferable {

    public static final String NAME = "TabTransfer";
    public static final DataFlavor FLAVOR = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType, NAME);
    private final DnDableTabbedPane sourcePane;
    private final int sourceTabIndex;
    private DnDableTabbedPane targetPane;
    private final Point cursorOffset;
    private boolean dropable = true;

    public TabTransfer(DnDableTabbedPane sourcePane, int sourceTabIndex, Point cursorOffset) {
        this.sourcePane = sourcePane;
        this.sourceTabIndex = sourceTabIndex;
        this.cursorOffset = cursorOffset;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] f = new DataFlavor[1];
        f[0] = FLAVOR;
        return f;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.getHumanPresentableName().equals(NAME);
    }

    public DnDableTabbedPane getSourcePane() {
        return sourcePane;
    }

    public int getSourceTabIndex() {
        return sourceTabIndex;
    }

    public DnDableTabbedPane getTargetPane() {
        return targetPane;
    }

    public void setTargetPane(DnDableTabbedPane targetPane) {
        this.targetPane = targetPane;
    }

    public Point getCursorOffset() {
        return cursorOffset;
    }

    public void setDropable(boolean dropable) {
        this.dropable = dropable;
    }

    public boolean isDropable() {
        return dropable;
    }
}
