/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.kaoriha.marimite.viewer.chart;

import java.io.Serializable;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

/**
 *
 * @author NAKAZATO Hajime
 */
public class ToolTipGenerator implements XYToolTipGenerator, Serializable {
    private long current = 0;

    public void setCurrent(long current) {
        this.current = current;
    }

    @Override
    public String generateToolTip(XYDataset dataset, int series, int item) {
        if (current == 0) {
            return null;
        }
        long date = current - dataset.getX(series, item).longValue();
        double med = dataset.getYValue(0, item);
        double tail = dataset.getYValue(1, item);
        double worst = dataset.getYValue(2, item);
        return String.format("%tF %<tR med: %.1f tail: %.1f worst: %.1f", date, med, tail, worst);
    }
}
