/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.chart;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.kaoriha.marimite.viewer.ImageResource;
import org.kaoriha.marimite.viewer.MessageResource;
import org.kaoriha.marimite.viewer.dnd.DnDableTabbedPane;
import org.kaoriha.marimite.viewer.jmx.JmxRemote;

/**
 *
 * @author NAKAZATO Hajime
 */
public class ChartUtil {

    public static ChartPanel getChartPanel() {
        XYIntervalSeriesCollection dataset = new XYIntervalSeriesCollection();
        DateLogAxis xAxis = new DateLogAxis();
        xAxis.setInverted(true);
        NumberAxis yAxis = new NumberAxis();
        DeviationRenderer renderer = new DeviationRenderer(true, true);
        renderer.setAlpha(0.2f);
        renderer.setSeriesPaint(0, Color.BLUE);
        renderer.setSeriesPaint(1, Color.RED);
        renderer.setSeriesPaint(2, Color.GREEN);
        renderer.setSeriesFillPaint(0, renderer.getSeriesPaint(0));
        renderer.setSeriesFillPaint(1, renderer.getSeriesPaint(1));
        renderer.setSeriesFillPaint(2, renderer.getSeriesPaint(2));
        renderer.setBaseToolTipGenerator(new ToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, xAxis, yAxis, renderer);
        XYLineAndShapeRenderer sr = new XYLineAndShapeRenderer(false, true);
        sr.setSeriesPaint(0, Color.YELLOW);
        plot.setRenderer(1, sr);
        plot.setBackgroundPaint(Color.LIGHT_GRAY);
        JFreeChart chart = new JFreeChart(null,
                UIManager.getFont("Label.font"),
                plot,
                true);
        ChartPanel panel = new ChartPanel(chart);

        JPopupMenu pm = panel.getPopupMenu();
        pm.addSeparator();
        JMenuItem removeMenu = new JMenuItem(MessageResource.ContextMenu.REMOVE_SECTION);
        removeMenu.addActionListener(new RemoveListener(panel));
        pm.add(removeMenu);

        return panel;
    }

    private static class RemoveListener implements ActionListener {

        private ChartPanel panel;

        RemoveListener(ChartPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DnDableTabbedPane tabbedPane = (DnDableTabbedPane) panel.getParent();
            if (tabbedPane.getSelectedIndex() == -1) {
                return;
            }
            String section = tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
            int r = JOptionPane.showConfirmDialog(tabbedPane,
                    MessageResource.ConfirmDialog.getRemoveSectionMessage(section),
                    MessageResource.ConfirmDialog.REMOVE_SECTION_TITLE,
                    JOptionPane.OK_CANCEL_OPTION);
            if (r != JOptionPane.OK_OPTION) {
                return;
            }

            try {
                removeImpl(JmxRemote.getConnection(), tabbedPane);
            } catch (Exception e) {
                JmxRemote.notifyLostConnection();
                if (tabbedPane.getSelectedIndex() == -1) {
                    return;
                }
                Icon icon = ImageResource.getCrossIcon();
                int index = tabbedPane.getSelectedIndex();
                if (tabbedPane.getIconAt(index) != icon) {
                    tabbedPane.setIconAt(index, icon);
                    tabbedPane.setToolTipTextAt(index, MessageResource.TabToolTip.NO_CONNECTION);
                    tabbedPane.repaint();
                }
            }
        }

        private void removeImpl(MBeanServerConnection connection, DnDableTabbedPane tabbedPane) throws IOException, InstanceNotFoundException, MBeanException, ReflectionException {
            int selectedTabIdx = tabbedPane.getSelectedIndex();
            Object[] params = {tabbedPane.getTitleAt(selectedTabIdx)};
            String[] signature = {"java.lang.String"};
            connection.invoke(JmxRemote.MONITOR_LIVE_OBJNAME, "removeSection", params, signature);
            connection.invoke(JmxRemote.MONITOR_LOG_OBJNAME, "removeSection", params, signature);

            tabbedPane.remove(selectedTabIdx);
            if (tabbedPane.getTabCount() == 0) {
                tabbedPane.getRootWindow().dispose();
            }
        }
    }
}
