/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer;

/**
 *
 * @author NAKAZATO Hajime
 */
public class MessageResource {

    public static class TabToolTip {

        public static final String NO_LOG = "ログがありません";
        public static final String NO_LIVE = "ライブがありません";
        public static final String NO_SECTION = "このセクションは存在しません";
        public static final String NO_CONNECTION = "ネットワーク接続にエラー";
    }

    public static class Legend {

        public static final String MEDIAN = "Median";
        public static final String TAIL = "Tail";
        public static final String WORST = "Worst";
        public static final String LIVE = "Live";
    }

    public static class ConnectionStatus {

        public static final String OK = "正常に接続中";
        public static final String NOT_YET_OPEN = "未接続";

        public static String getError(long occured) {
            return String.format("エラー: %tF %<tR から接続不能", occured);
        }
    }

    public static class TitleBar {

        public static String getRootFrame() {
            return Main.getServerAddress() + "/" + Main.getJndiName() + " - Marimite";
        }

        public static String getDnDableTabDialog() {
            return Main.getServerAddress() + "/" + Main.getJndiName();
        }
    }

    public static class ErrorMessageDialog {

        public static final String NO_CONNECTION_TITLE = "ネットワーク エラー - Marimite";
        public static final String NO_CONNECTION_MESSAGE = "ネットワーク接続に失敗しました。";
    }

    public static class ContextMenu {

        public static final String REMOVE_SECTION = "Remove";
    }

    public static class ConfirmDialog {
        
        public static final String REMOVE_SECTION_TITLE = "セクションの削除 - Marimite";
        public static String getRemoveSectionMessage(String section) {
            return String.format("%s を削除します。よろしいですか？", section);
        }
    }
}
