/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer;

import java.awt.Component;
import java.io.IOException;
import java.rmi.registry.Registry;
import org.kaoriha.marimite.viewer.chart.ChartUtil;
import org.kaoriha.marimite.viewer.dnd.DnDableTabDialog;
import org.kaoriha.marimite.viewer.dnd.DnDableTabbedPane;
import org.kaoriha.marimite.viewer.dnd.DnDableTabbedPane.Updater;
import org.kaoriha.marimite.viewer.pref.ClientPreference;
import org.kaoriha.marimite.viewer.dnd.PanePacker;
import org.kaoriha.marimite.viewer.pref.WindowLocator;

/**
 *
 * @author NAKAZATO Hajime
 */
public class Main {

    private static String SERVER_ADDRESS = "localhost";
    private static int RMI_PORT = Registry.REGISTRY_PORT;
    private static String JMX_DOMAIN_NAME = "org.kaoriha.marimite";
    private static final String JMX_SERVICE_URL_BASE = "service:jmx:rmi:///jndi/rmi://";
    private static String JNDI_NAME = "marimite-testbench";
    private static RootFrame ROOT_FRAME;

    public static String getServerAddress() {
        if (RMI_PORT == Registry.REGISTRY_PORT) {
            return SERVER_ADDRESS;
        } else {
            return SERVER_ADDRESS + ":" + RMI_PORT;
        }
    }

    public static String getJndiName() {
        return JNDI_NAME;
    }

    public static String getJmxDomainName() {
        return JMX_DOMAIN_NAME;
    }

    public static String getJmxServiceUrl() {
        return JMX_SERVICE_URL_BASE + SERVER_ADDRESS + ":" + RMI_PORT + "/" + JNDI_NAME;
    }

    /**
     * @param args
     *            args[0] is server address where RMI repository is runnning.
     *            It also accepts URL like "http://hogehoge:8080/foo". Default:"localhost".
     *            args[1] is MBean domain name. Same value as marimite.properties.
     *            Default: "org.kaoriha.marimite".
     *            args[2] is JNDI name. Same value as marimite.properties.
     *            Default: "marimite-testbench".
     *            args[3] is RMI port which exports platform MBean server. Same value as
     *            marimite.properties. Default:"1099".
     */
    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].startsWith("http://")) {
                SERVER_ADDRESS = args[0].split("[:/]")[3];
            } else {
                SERVER_ADDRESS = args[0];
            }
        }
        if (args.length > 1) {
            JMX_DOMAIN_NAME = args[1];
        }
        if (args.length > 2) {
            JNDI_NAME = args[2];
        }
        if (args.length > 3) {
            RMI_PORT = Integer.parseInt(args[3]);
        }
        /*
        try {
        ClientPreference.getInstance().removeAll();
        } catch (IOException ex) {
        }
         */

        DnDableTabbedPane.init(new DnDableTabbedPane.UpdaterGenerator() {

            @Override
            public Updater getUpdater(DnDableTabbedPane tabbedPane) {
                return new org.kaoriha.marimite.viewer.chart.Updater(tabbedPane);
            }
        });
        DnDableTabDialog.init(MessageResource.TitleBar.getDnDableTabDialog());
        PanePacker.init(SERVER_ADDRESS, JNDI_NAME, new PanePacker.ComponentPacker() {

            @Override
            public Component getComponent() {
                return ChartUtil.getChartPanel();
            }
        });
        WindowLocator.init(SERVER_ADDRESS, JNDI_NAME);

        RootFrame root = new RootFrame();
        root.setVisible(true);
        ROOT_FRAME = root;
        PanePacker.resume(root);
    }

    public static RootFrame getRootFrame() {
        return ROOT_FRAME;
    }
}
