/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer.chart;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.kaoriha.marimite.viewer.ImageResource;
import org.kaoriha.marimite.viewer.chart.ToolTipGenerator;
import org.kaoriha.marimite.viewer.dnd.DnDableTabbedPane;
import org.kaoriha.marimite.viewer.jmx.JmxRemote;

public class Updater
implements DnDableTabbedPane.Updater {
    private static final Set<Updater> INSTANCE_SET = new CopyOnWriteArraySet<Updater>();
    private final JTabbedPane tabbedPane;

    public Updater(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        INSTANCE_SET.add(this);
    }

    public static void updateAll() {
        for (Updater u : INSTANCE_SET) {
            u.update();
        }
    }

    private void updateImpl(MBeanServerConnection connection) throws IOException, InstanceNotFoundException, MBeanException, ReflectionException {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        String section = this.tabbedPane.getTitleAt(selectedIndex);
        ChartPanel chartPanel = (ChartPanel)this.tabbedPane.getSelectedComponent();
        XYPlot plot = (XYPlot)chartPanel.getChart().getPlot();
        Object[] params = new Object[]{section};
        String[] signature = new String[]{"java.lang.String"};
        Map logLap = (Map)connection.invoke(JmxRemote.MONITOR_LOG_OBJNAME, "getLog", params, signature);
        if (logLap != null) {
            XYIntervalSeries medSeries = new XYIntervalSeries((Comparable)((Object)"Median"));
            XYIntervalSeries tailSeries = new XYIntervalSeries((Comparable)((Object)"Tail"));
            XYIntervalSeries worstSeries = new XYIntervalSeries((Comparable)((Object)"Worst"));
            long current = System.currentTimeMillis();
            ToolTipGenerator ttg = (ToolTipGenerator)plot.getRenderer().getBaseToolTipGenerator();
            ttg.setCurrent(current);
            for (Map.Entry me : logLap.entrySet()) {
                long t = current - (Long)me.getKey();
                if (t < 50L) {
                    t = 50L;
                }
                Double[] v = (Double[])me.getValue();
                double med = v[0];
                double medSD = Math.pow(v[1], 0.5);
                double tail = v[2];
                double tailSD = Math.pow(v[3], 0.5);
                double worst = v[4];
                double worstSD = Math.pow(v[5], 0.5);
                medSeries.add((double)t, (double)t, (double)t, med, med - medSD, med + medSD);
                tailSeries.add((double)t, (double)t, (double)t, tail, tail - tailSD, tail + tailSD);
                worstSeries.add((double)t, (double)t, (double)t, worst, worst - worstSD, worst + worstSD);
            }
            XYIntervalSeriesCollection logDS = new XYIntervalSeriesCollection();
            logDS.addSeries(medSeries);
            logDS.addSeries(tailSeries);
            logDS.addSeries(worstSeries);
            plot.setDataset((XYDataset)logDS);
        }
        plot.getDomainAxis().setAutoRange(true);
        plot.getDomainAxis().setLowerBound(900.0);
        Long[] liveLap = (Long[])connection.invoke(JmxRemote.MONITOR_LIVE_OBJNAME, "getLap", params, signature);
        if (liveLap != null) {
            XYSeries liveSeries = new XYSeries((Comparable)((Object)"Live"));
            Long[] arr$ = liveLap;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long l = arr$[i$];
                liveSeries.add(1000.0, (double)l);
            }
            XYSeriesCollection liveDS = new XYSeriesCollection();
            liveDS.addSeries(liveSeries);
            plot.setDataset(1, (XYDataset)liveDS);
        }
        String toolTip = null;
        Icon icon = null;
        if (logLap == null) {
            if (liveLap == null) {
                icon = ImageResource.getExclamationIcon();
                toolTip = "\u3053\u306e\u30bb\u30af\u30b7\u30e7\u30f3\u306f\u5b58\u5728\u3057\u307e\u305b\u3093";
            } else {
                icon = ImageResource.getInfoIcon();
                toolTip = "\u30ed\u30b0\u304c\u3042\u308a\u307e\u305b\u3093";
            }
        } else if (liveLap == null) {
            icon = ImageResource.getWarnIcon();
            toolTip = "\u30e9\u30a4\u30d6\u304c\u3042\u308a\u307e\u305b\u3093";
        } else {
            icon = null;
            toolTip = null;
        }
        this.setStatusAt(selectedIndex, icon, toolTip);
        chartPanel.repaint();
    }

    private void setStatusAt(int index, Icon icon, String toolTip) {
        if (this.tabbedPane.getIconAt(index) != icon) {
            this.tabbedPane.setIconAt(index, icon);
            this.tabbedPane.setToolTipTextAt(index, toolTip);
            this.tabbedPane.repaint();
        }
    }

    public void update() {
        if (!(this.tabbedPane.getSelectedComponent() instanceof ChartPanel)) {
            return;
        }
        if (this.tabbedPane.getSelectedIndex() == -1) {
            return;
        }
        try {
            this.updateImpl(JmxRemote.getConnection());
        }
        catch (Exception e) {
            JmxRemote.notifyLostConnection();
            if (this.tabbedPane.getSelectedIndex() == -1) {
                return;
            }
            this.setStatusAt(this.tabbedPane.getSelectedIndex(), ImageResource.getCrossIcon(), "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u63a5\u7d9a\u306b\u30a8\u30e9\u30fc");
        }
    }

    @Override
    public void dispose() {
        INSTANCE_SET.remove(this);
    }

    public static Set<String> getAllViewingSectionSet() {
        HashSet<String> r = new HashSet<String>();
        for (Updater u : INSTANCE_SET) {
            for (int i = 0; i < u.tabbedPane.getTabCount(); ++i) {
                r.add(u.tabbedPane.getTitleAt(i));
            }
        }
        return r;
    }
}

