/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class DateLogAxis
extends LogarithmicAxis {
    public DateLogAxis() {
        super(null);
    }

    public DateLogAxis(String label) {
        super(label);
    }

    private int nextTV(int prev) {
        String start;
        String ps = Integer.toString(prev);
        switch (ps.charAt(0)) {
            case '1': {
                start = "2";
                break;
            }
            case '2': {
                start = "5";
                break;
            }
            case '5': {
                start = "10";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Integer.parseInt(start + ps.substring(1));
    }

    protected List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        Range range = this.getRange();
        double lowerBoundVal = range.getLowerBound();
        double upperBoundVal = range.getUpperBound();
        TextAnchor anchor = null;
        TextAnchor rotationAnchor = null;
        double angle = 0.0;
        if (this.isVerticalTickLabels()) {
            anchor = TextAnchor.CENTER_RIGHT;
            rotationAnchor = TextAnchor.CENTER_RIGHT;
            angle = edge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
        } else if (edge == RectangleEdge.TOP) {
            anchor = TextAnchor.BOTTOM_CENTER;
            rotationAnchor = TextAnchor.BOTTOM_CENTER;
        } else {
            anchor = TextAnchor.TOP_CENTER;
            rotationAnchor = TextAnchor.TOP_CENTER;
        }
        for (int i = 0; i < DateTick.values().length; ++i) {
            long currentVal;
            DateTick dt = DateTick.values()[i];
            if ((double)dt.val > upperBoundVal) break;
            long limit = Long.MAX_VALUE;
            if (i + 1 < DateTick.values().length) {
                if ((double)DateTick.values()[i + 1].val < lowerBoundVal) continue;
                limit = DateTick.values()[i + 1].val / 2L;
            }
            int r = 1;
            while (dt.val * (long)r < limit && !((double)(currentVal = dt.val * (long)r) > upperBoundVal)) {
                NumberTick tick = new NumberTick((Number)new Double(currentVal), Long.toString(currentVal / dt.val) + dt.label, anchor, rotationAnchor, angle);
                ticks.add(tick);
                r = this.nextTV(r);
            }
        }
        return ticks;
    }

    private static enum DateTick {
        SECOND("s", 1000L),
        MINUTE("m", 60000L),
        HOUR("h", 3600000L),
        DAY("d", 86400000L),
        WEEK("w", 604800000L),
        YEAR("y", 31536000000L);

        public final String label;
        public final long val;

        private DateTick(String label, long val) {
            this.label = label;
            this.val = val;
        }
    }
}

