package org.kaoriha.marimite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

import junit.framework.Assert;
import junit.framework.TestCase;

public class ConnTest extends TestCase {
	public void testSimple() throws Exception {
		Class.forName("org.h2.Driver");
		Connection conn = DriverManager.getConnection("jdbc:h2:mem:test_mem",
				"user", "sa");
		conn.setAutoCommit(false);

		Statement st = conn.createStatement();
		ResultSet rs = null;

		// create table
		st.execute("create table TEST ( " + "id int primary key,"
				+ "name varchar(100)," + "price int" + ")");
		st.execute("insert into TEST values (1, 'apple', 100)");
		st.execute("insert into TEST values (2, 'orange', 200)");
		st.execute("update TEST set price = 150 where id = 2");

		rs = st.executeQuery("select * from TEST");

		int count = 0;
		while (rs.next()) {
			count++;
			/*
			 * System.out.println("id=" + rs.getInt("id") + ", " + "name=" +
			 * rs.getString("name") + ", " + "price=" + rs.getInt("price"));
			 */
		}
		Assert.assertEquals(2, count);

		rs.close();
		st.close();

		conn.commit();
		conn.close();
	}
}
