package org.kaoriha.marimite;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Random;

import junit.framework.Assert;
import junit.framework.TestCase;

public class CompressorTest extends TestCase {
	private Random rnd = new Random();

	public void testSimple() throws Exception {
		MarimiteConfig.start();
		Thread.sleep(1000L);

		Section s = Section.getInstance("START", "END");
		for (int i = 0; i < 31000; i++) {
			long[] buf = new long[100];
			for (int k = 0; k < 100; k++) {
				buf[k] = (long) (100L * rnd.nextDouble());
			}
			LapInserter li = new LapInserter(buf, 100, s);
			li.run();
		}

		Compressor c = new Compressor();
		c.run();
		c.run();
		c.run();

		Connection conn = MarimiteConfig.getConnection();
		PreparedStatement ps = conn
				.prepareStatement("select * from lap where section_id = ?");
		ps.setLong(1, s.getId());
		ResultSet rs = ps.executeQuery();
		int nSample3Count = 0;
		int nSample2Count = 0;
		int nSample1Count = 0;
		while (rs.next()) {
			switch (rs.getInt("n_sample")) {
			case 1:
				nSample1Count++;
				break;
			case 2:
				nSample2Count++;
				break;
			case 3:
				nSample3Count++;
				break;
			default:
				Assert.fail("invalid n_sample found");
			}
			/*
			  System.out.println(rs.getLong("section_id") + ": " +
			  rs.getInt("n_sample") + ": " + rs.getTimestamp("sample_date") + ": " +
			  rs.getDouble("elapse_med") + ": " +
			  rs.getDouble("elapse_med_var") + ": " +
			  rs.getDouble("elapse_tail") + ": " +
			  rs.getDouble("elapse_tail_var") + ": " +
			  rs.getDouble("elapse_worst") + ": " +
			  rs.getDouble("elapse_worst_var"));
			 */
		}
		Assert.assertEquals(100, nSample1Count);
		Assert.assertEquals(109, nSample2Count);
		Assert.assertEquals(2, nSample3Count);

		LogJMX obj = new LogJMX();
		Assert.assertEquals(s.toString(), obj.getSectionList()[0]);
		Map<Long, Double[]> r = obj.getLog(obj.getSectionList()[0]);
		Assert.assertEquals(211, r.size());

		obj.removeSection(s.toString());
		Assert.assertEquals(0, obj.getSectionList().length);

		rs.close();
		conn.close();
		TestUtil.cleanup();
		MarimiteConfig.stop();
	}
}
