package org.kaoriha.marimite;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

class RingBuffer implements Collection<Long> {
	private final long[] buffer;
	private final Section section;
	private int size = 0;
	private AtomicInteger index = new AtomicInteger(0);
	private final int capacity;

	RingBuffer(int capacity, Section s) {
		buffer = new long[capacity];
		this.capacity = capacity;
		this.section = s;
	}

	public void put(Long l) {
		int i = index.get();
		if (i >= capacity) {
			if (index.compareAndSet(i, 1)) {
				MarimiteConfig.QueueLapInserter(new LapInserter(buffer, size, section));
				buffer[0] = l;
				return;
			} else {
				i = index.get();
				if (i >= capacity) {
					return; // intensive race condition?
				}
			}
		}

		if (index.compareAndSet(i, i + 1)) {
			buffer[i] = l;
			if (size < i + 1) {
				size = i + 1;
			}
		} else {
			i = index.get();
			if (i < capacity && index.compareAndSet(i, i + 1)) {
				buffer[i] = l;
				if (size < i + 1) {
					size = i + 1;
				}
			}
		}
	}

	public int size() {
		return size;
	}

	public boolean isEmpty() {
		return size == 0;
	}

	public boolean contains(Object o) {
		throw new UnsupportedOperationException();
	}

	public Iterator<Long> iterator() {
		return new Iterator<Long>() {
			private int i = 0;
			public boolean hasNext() {
				return i < size;
			}

			public Long next() {
				i++;
				return buffer[i - 1];
			}

			public void remove() {
				throw new UnsupportedOperationException();
			}
		};
	}

	public Object[] toArray() {
		throw new UnsupportedOperationException();
	}

	public <T> T[] toArray(T[] o) {
		throw new UnsupportedOperationException();
	}

	public Long[] getArray() {
		Long[] r = new Long[size];
		for (int i = 0; i < size; i++) {
			r[i] = buffer[i];
		}
		return r;
	}

	public boolean add(Long l) {
		throw new UnsupportedOperationException();
	}

	public boolean remove(Object o) {
		throw new UnsupportedOperationException();
	}

	public boolean containsAll(Collection<?> o) {
		throw new UnsupportedOperationException();
	}

	public boolean addAll(Collection<? extends Long> l) {
		throw new UnsupportedOperationException();
	}

	public boolean removeAll(Collection<?> o) {
		throw new UnsupportedOperationException();
	}

	public boolean retainAll(Collection<?> o) {
		throw new UnsupportedOperationException();
	}

	public void clear() {
		throw new UnsupportedOperationException();
	}

	public Section getSection() {
		return section;
	}
}
