package org.kaoriha.marimite;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

class LogJMX implements LogJMXMBean {

	public Map<Long, Double[]> getLog(String section) {
		Connection conn = null;
		try {
			conn = MarimiteConfig.getConnection();
			Section s;
			try {
				s = Section.fromString(section);
			} catch (IllegalArgumentException e) {
				return null;
			}
			return getLogImpl(conn, s);
		} catch (SQLException e) {
			// ignore
		} finally {
			if (conn != null) {
				try {
					conn.close();
				} catch (SQLException e1) {
				}
			}
		}

		return null;
	}

	private Map<Long, Double[]> getLogImpl(Connection conn, Section section)
			throws SQLException {
		PreparedStatement selLap = conn
				.prepareStatement("select id, section_id, elapse_med, elapse_med_var, elapse_tail, elapse_tail_var, elapse_worst, elapse_worst_var, sample_date, n_sample from lap where section_id = ?");
		long sectionId = section.getIdAsPersistent(conn);
		if (sectionId == Section.ID_EMPTY) {
			return null;
		}

		selLap.setLong(1, sectionId);

		Map<Long, Double[]> r = new IdentityHashMap<Long, Double[]>();

		ResultSet rs = null;
		try {
			rs = selLap.executeQuery();
			while (rs.next()) {
				Double[] d = new Double[6];
				d[0] = rs.getDouble("elapse_med");
				d[1] = rs.getDouble("elapse_med_var");

				d[2] = rs.getDouble("elapse_tail");
				d[3] = rs.getDouble("elapse_tail_var");

				d[4] = rs.getDouble("elapse_worst");
				d[5] = rs.getDouble("elapse_worst_var");

				Timestamp ts = rs.getTimestamp("sample_date");

				r.put(ts.getTime(), d);
			}
			return r;
		} finally {
			if (rs != null) {
				rs.close();
			}
		}
	}

	public String[] getSectionList() {
		Connection conn = null;
		try {
			conn = MarimiteConfig.getConnection();
			return getSectionListImpl(conn);
		} catch (SQLException e) {
			// ignore
		} finally {
			if (conn != null) {
				try {
					conn.close();
				} catch (SQLException e1) {
				}
			}
		}

		return null;
	}

	private String[] getSectionListImpl(Connection conn) throws SQLException {
		List<String> r = new ArrayList<String>();
		PreparedStatement selSection = conn
				.prepareStatement("select start, goal from section");
		ResultSet rs = null;
		try {
			rs = selSection.executeQuery();
			while (rs.next()) {
				Section s = Section.getInstance(rs.getString(1), rs
						.getString(2));
				r.add(s.toString());
			}
		} finally {
			if (rs != null) {
				rs.close();
			}
		}

		return r.toArray(new String[r.size()]);
	}

	public void removeSection(String section) {
		Section s = Section.fromString(section);
		Connection conn = null;
		try {
			conn = MarimiteConfig.getConnection();
			removeSectionImpl(conn, s);
		} catch (SQLException e) {
			// ignore
		} finally {
			if (conn != null) {
				try {
					conn.close();
				} catch (SQLException e1) {
				}
			}
		}
	}

	public void removeSectionImpl(Connection conn, Section s)
			throws SQLException {
		long sectionId = s.getIdAsPersistent(conn, false);
		if (sectionId != Section.ID_EMPTY) {
			PreparedStatement delLap = conn
					.prepareStatement("delete from lap where section_id = ?");
			delLap.setLong(1, sectionId);
			PreparedStatement delSection = conn
					.prepareStatement("delete from section where id = ?");
			delSection.setLong(1, sectionId);

			delLap.executeUpdate();
			delSection.executeUpdate();
			try {
				conn.commit();
				s.disposeId();
			} catch (SQLException e) {
				conn.rollback();
				throw e;
			}
		}
	}
}
