/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kaoriha.marimite.RingBuffer;
import org.kaoriha.marimite.Section;

public class Stopwatch {
    private static final int BUFFER_SIZE = 100;
    private static final ConcurrentMap<Section, RingBuffer> spanMap = new ConcurrentHashMap<Section, RingBuffer>();
    private static ThreadLocal<Stopwatch> pmTL = new ThreadLocal<Stopwatch>(){

        @Override
        protected synchronized Stopwatch initialValue() {
            return new Stopwatch("default");
        }
    };
    private long lastSplitTime = System.currentTimeMillis();
    private String lastPoint;

    Stopwatch(String startPoint) {
        this.lastPoint = startPoint;
    }

    void lapImpl(String point) {
        try {
            long current = System.currentTimeMillis();
            Section s = Section.getInstance(this.lastPoint, point);
            RingBuffer rb = (RingBuffer)spanMap.get(s);
            if (rb == null) {
                spanMap.putIfAbsent(s, new RingBuffer(100, s));
                rb = (RingBuffer)spanMap.get(s);
            }
            rb.put(current - this.lastSplitTime);
            this.lastSplitTime = current;
            this.lastPoint = point;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void start(String point) {
        if (pmTL == null) {
            return;
        }
        pmTL.set(new Stopwatch(point));
    }

    public static void lap(String point) {
        if (pmTL == null) {
            return;
        }
        Stopwatch s = pmTL.get();
        if (s != null) {
            s.lapImpl(point);
        }
    }

    static Long[] get(Section s) {
        RingBuffer b = (RingBuffer)spanMap.get(s);
        if (b == null) {
            return null;
        }
        return b.getArray();
    }

    static String[] getSectionSet() {
        HashSet<String> ss = new HashSet<String>();
        for (Section s : spanMap.keySet()) {
            ss.add(s.toString());
        }
        return ss.toArray(new String[ss.size()]);
    }

    static void removeSection(Section s) {
        spanMap.remove(s);
    }
}

