/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class Section {
    public static final long ID_EMPTY = -1L;
    private static final String SPLITTER = " - ";
    private static final ConcurrentMap<Section, Section> INSTANCE = new ConcurrentHashMap<Section, Section>();
    private final String start;
    private final String end;
    private final int hashCode;
    private long id = -1L;

    private Section(String start, String end) {
        this.start = start;
        this.end = end;
        this.hashCode = start.hashCode() ^ end.hashCode();
    }

    public static Section getInstance(String start, String end) {
        Section temp = new Section(start, end);
        Section r = (Section)INSTANCE.get(temp);
        if (r != null) {
            return r;
        }
        if (start.contains(SPLITTER) || end.contains(SPLITTER)) {
            throw new IllegalArgumentException("must not contain ' - '");
        }
        INSTANCE.putIfAbsent(temp, temp);
        return (Section)INSTANCE.get(temp);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getEnd() {
        return this.end;
    }

    public String getStart() {
        return this.start;
    }

    public boolean equals(Object obj) {
        Section s = (Section)obj;
        return s.start.equals(this.start) && s.end.equals(this.end);
    }

    public String toString() {
        return this.start + SPLITTER + this.end;
    }

    public static Section fromString(String s) {
        String[] ss = s.split(SPLITTER);
        if (ss.length != 2) {
            throw new IllegalArgumentException("bad string");
        }
        return Section.getInstance(ss[0], ss[1]);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getIdAsPersistent(Connection conn) throws SQLException {
        return this.getIdAsPersistent(conn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIdAsPersistent(Connection conn, boolean create) throws SQLException {
        if (this.getId() != -1L) {
            return this.getId();
        }
        PreparedStatement sidByName = conn.prepareStatement("select id from section where start=? and goal=?");
        sidByName.setString(1, this.getStart());
        sidByName.setString(2, this.getEnd());
        ResultSet rs = null;
        try {
            rs = sidByName.executeQuery();
            if (rs.next()) {
                long r = rs.getLong(1);
                this.setId(r);
                long l = r;
                return l;
            }
        }
        finally {
            rs.close();
        }
        if (!create) {
            return -1L;
        }
        PreparedStatement insSection = conn.prepareStatement("insert into section (id, start, goal) values (NEXT VALUE FOR seq_section_id, ?, ?)");
        insSection.setString(1, this.getStart());
        insSection.setString(2, this.getEnd());
        insSection.executeUpdate();
        try {
            conn.commit();
        }
        catch (SQLException e) {
            conn.rollback();
            throw e;
        }
        insSection.close();
        return this.getIdAsPersistent(conn);
    }

    public void disposeId() {
        this.id = -1L;
    }
}

