/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.kaoriha.marimite.LapInserter;
import org.kaoriha.marimite.MarimiteConfig;
import org.kaoriha.marimite.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RingBuffer
implements Collection<Long> {
    private final long[] buffer;
    private final Section section;
    private int size = 0;
    private AtomicInteger index = new AtomicInteger(0);
    private final int capacity;

    RingBuffer(int capacity, Section s) {
        this.buffer = new long[capacity];
        this.capacity = capacity;
        this.section = s;
    }

    public void put(Long l) {
        int i = this.index.get();
        if (i >= this.capacity) {
            if (this.index.compareAndSet(i, 1)) {
                MarimiteConfig.QueueLapInserter(new LapInserter(this.buffer, this.size, this.section));
                this.buffer[0] = l;
                return;
            }
            i = this.index.get();
            if (i >= this.capacity) {
                return;
            }
        }
        if (this.index.compareAndSet(i, i + 1)) {
            this.buffer[i] = l;
            if (this.size < i + 1) {
                this.size = i + 1;
            }
        } else {
            i = this.index.get();
            if (i < this.capacity && this.index.compareAndSet(i, i + 1)) {
                this.buffer[i] = l;
                if (this.size < i + 1) {
                    this.size = i + 1;
                }
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < RingBuffer.this.size;
            }

            @Override
            public Long next() {
                ++this.i;
                return RingBuffer.this.buffer[this.i - 1];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] o) {
        throw new UnsupportedOperationException();
    }

    public Long[] getArray() {
        Long[] r = new Long[this.size];
        for (int i = 0; i < this.size; ++i) {
            r[i] = this.buffer[i];
        }
        return r;
    }

    @Override
    public boolean add(Long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Long> l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Section getSection() {
        return this.section;
    }
}

