/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.kaoriha.marimite.MarimiteConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Compressor
implements Runnable {
    private static final int N_COMPRESS = 100;
    private PreparedStatement selLap;
    private PreparedStatement countLap;
    private PreparedStatement insLap;
    private PreparedStatement delLap;
    private Connection conn = null;

    Compressor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.conn = null;
        try {
            this.conn = MarimiteConfig.getConnection();
            this.selLap = this.conn.prepareStatement("select id, section_id, elapse_med, elapse_med_var, elapse_tail, elapse_tail_var, elapse_worst, elapse_worst_var, sample_date, n_sample from lap where n_sample = ? and section_id = ?  order by id limit ?");
            this.selLap.setInt(3, 100);
            this.countLap = this.conn.prepareStatement("select count(*) from lap where n_sample = ? and section_id = ?");
            this.insLap = this.conn.prepareStatement("insert into lap (id, section_id, elapse_med, elapse_med_var, elapse_tail, elapse_tail_var, elapse_worst, elapse_worst_var, sample_date, n_sample) values (NEXT VALUE FOR seq_lap_id, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.delLap = this.conn.prepareStatement("delete from lap where n_sample = ? and section_id = ? and id <= ?");
            Class<Compressor> clazz = Compressor.class;
            synchronized (Compressor.class) {
                this.runImpl();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.selLap.close();
                this.countLap.close();
                this.insLap.close();
                this.delLap.close();
            }
        }
        catch (SQLException e) {
        }
        finally {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e1) {}
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() throws SQLException {
        PreparedStatement selSection = this.conn.prepareStatement("select id from section");
        ResultSet rs = null;
        try {
            rs = selSection.executeQuery();
            while (rs.next()) {
                long sectionId = rs.getLong(1);
                this.compress(1, sectionId);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(int nSample, long sectionId) throws SQLException {
        int nLap;
        this.countLap.setInt(1, nSample);
        this.countLap.setLong(2, sectionId);
        ResultSet rs = null;
        try {
            rs = this.countLap.executeQuery();
            if (!rs.next()) {
                throw new IllegalStateException("never run here.");
            }
            nLap = rs.getInt(1);
            if (nLap < 200) {
                return;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        this.selLap.setInt(1, nSample);
        this.selLap.setLong(2, sectionId);
        rs = null;
        try {
            BigInteger sumTimestamp = BigInteger.valueOf(0L);
            long lastId = 0L;
            ArrayList<Double> elapseMedList = new ArrayList<Double>(100);
            ArrayList<Double> elapseTailList = new ArrayList<Double>(100);
            ArrayList<Double> elapseWorstList = new ArrayList<Double>(100);
            double sumElapseMed = 0.0;
            double sumElapseTail = 0.0;
            double sumElapseWorst = 0.0;
            double sumVarMed = 0.0;
            double sumVarTail = 0.0;
            double sumVarWorst = 0.0;
            rs = this.selLap.executeQuery();
            while (rs.next()) {
                double med = rs.getDouble("elapse_med");
                sumElapseMed += med;
                elapseMedList.add(med);
                sumVarMed += rs.getDouble("elapse_med_var");
                double tail = rs.getDouble("elapse_tail");
                sumElapseTail += tail;
                elapseTailList.add(tail);
                sumVarTail += rs.getDouble("elapse_tail_var");
                double worst = rs.getDouble("elapse_worst");
                sumElapseWorst += worst;
                elapseWorstList.add(worst);
                sumVarWorst += rs.getDouble("elapse_worst_var");
                Timestamp ts = rs.getTimestamp("sample_date");
                sumTimestamp = sumTimestamp.add(BigInteger.valueOf(ts.getTime()));
                lastId = rs.getLong("id");
            }
            this.insLap.setLong(1, sectionId);
            Timestamp nts = new Timestamp(sumTimestamp.divide(BigInteger.valueOf(100L)).longValue());
            this.insLap.setTimestamp(8, nts);
            this.insLap.setInt(9, nSample + 1);
            double aveElapseMed = sumElapseMed / 100.0;
            this.insLap.setDouble(2, aveElapseMed);
            double aveElapseTail = sumElapseTail / 100.0;
            this.insLap.setDouble(4, aveElapseTail);
            double aveElapseWorst = sumElapseWorst / 100.0;
            this.insLap.setDouble(6, aveElapseWorst);
            if (nSample == 1) {
                this.insLap.setDouble(3, this.getUnbiasedVariance(elapseMedList, aveElapseMed));
                this.insLap.setDouble(5, this.getUnbiasedVariance(elapseTailList, aveElapseTail));
                this.insLap.setDouble(7, this.getUnbiasedVariance(elapseWorstList, aveElapseWorst));
            } else {
                this.insLap.setDouble(3, sumVarMed / 100.0);
                this.insLap.setDouble(5, sumVarTail / 100.0);
                this.insLap.setDouble(7, sumVarWorst / 100.0);
            }
            this.insLap.executeUpdate();
            this.delLap.setInt(1, nSample);
            this.delLap.setLong(2, sectionId);
            this.delLap.setLong(3, lastId);
            int deletedCount = this.delLap.executeUpdate();
            try {
                if (deletedCount == 100) {
                    this.conn.commit();
                } else {
                    this.conn.rollback();
                }
            }
            catch (SQLException e) {
                this.conn.rollback();
                throw e;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        if (nLap > 300) {
            this.compress(nSample, sectionId);
        }
        this.compress(nSample + 1, sectionId);
    }

    private double getUnbiasedVariance(List<Double> sampleList, double ave) {
        double ds = 0.0;
        for (double sample : sampleList) {
            ds += Math.pow(sample - ave, 2.0);
        }
        return ds / (double)(sampleList.size() - 1);
    }
}

