#include "HPLError.h"
#include "stdarg.h"
#include <cstdio>
#include <cstdlib>

const int BUF_MAX = 1024;

#ifdef WX

#include <wx/wx.h>

#endif
#ifdef WIN32

#include <windows.h>

#endif

/**
    bZ[W\܂
*/
void hpl::error::caution(const char* format, ...)
{
    char message[BUF_MAX];
    va_list maker;
    va_start(maker, format);
    vsprintf(message, format, maker);
//    int len = strlen(message);

#ifdef WX
#ifdef UNICODE/*
    wchar_t wmsg[BUF_MAX];
    size_t wlen = wxMBConv::MB2WC(wmsg, message, BUF_MAX);*/
    wxMessageBox(wxConvCurrent->cMB2WX(message));
#else
    wxMessageBox(message);
#endif
#endif
#ifdef WIN32
//    MessageBox(NULL, 
#endif
    fprintf(stderr, message);
}

/**
    bZ[W\ĈُI܂
*/
void hpl::error::halt(const char* format, ...)
{
    char message[BUF_MAX];
    va_list maker;
    va_start(maker, format);
    vsprintf(message, format, maker);
    caution(message);
    exit(-1);
}
