#include "ToolDialog.h"
#include "MapEditorWX.h"

#include <string>
#include "PolygonNumDialog.h"
#include "MapEditorMainFrame.h"

BEGIN_EVENT_TABLE(ToolDialog, wxDialog)
    EVT_PAINT(ToolDialog::OnPaint)
    EVT_LEFT_DOWN(ToolDialog::OnLeftDown)
END_EVENT_TABLE()

ToolDialog::ToolDialog():wxDialog()
{
    
    //C[WXgǂݍ
    hpl::aleph::Information infos[NUMBER_OF_TOOL_BAR_ICON_FILES];
    {
        std::string path = std::string(DATA_DIR_NAME) + std::string(TOOL_BAR_ICONS_IMAGE_LIST_FILE_NAME);
        hpl::aleph::loadInformation(path.c_str(), NUMBER_OF_TOOL_BAR_ICON_FILES,
            infos);
    }

    //
    for(int i = 0; i < ToolType::NUMBER_OF_TOOLS * 2; i ++){
        std::string imgPath = std::string(DATA_DIR_NAME) + std::string(TOOL_BAR_ICONS_DIR_NAMR);
        //ŏʏ탂[hB㔼͑ĨC[Wt@CɂȂĂ
        bool select = (i >= ToolType::NUMBER_OF_TOOLS);
        if(select){
            imgPath += std::string(SELECTED_ICONS_DIR_NAME);
        }
        int index = i % ToolType::NUMBER_OF_TOOLS;
        imgPath += infos[index].jname;
        if(select){
            wxGetApp().loadBitmap(imgPath.c_str(), &this->selectedToolBitmaps[index]);
        }else{
            wxGetApp().loadBitmap(imgPath.c_str(), &this->toolBitmaps[index]);
        }
    }

}
ToolDialog::~ToolDialog()
{
    
}
bool ToolDialog::Create(wxWindow* parent, wxWindowID id)
{
    //wxTHICK_FRAME wxSTAY_ON_TOP
    long style = wxCAPTION;
    bool result = wxDialog::Create(parent, id, _T("Tool"), wxDefaultPosition//);
    ,        wxSize(TOOL_DIALOG_W, TOOL_DIALOG_H), style);

/*    wxBitmapButton *bmpBtn = new wxBitmapButton(this, -1, toolBitmaps[0]);
    wxGridSizer *boxSizer = new wxGridSizer(2);
    this->SetSizer(boxSizer);
    boxSizer->Add(bmpBtn);
*/
    return result;
}

//paint
void ToolDialog::OnPaint(wxPaintEvent& ev)
{
    //c[ACR\
    wxPaintDC dc(this);
    PrepareDC(dc);

    for(int i = 0; i < ToolType::NUMBER_OF_TOOLS; i ++){
#ifdef MAP_VIEWER
        //}bvr[A[dl
        if(i % 2 == 1 || i >= 6){
            continue;
        }
#endif
        int x = (i % 2) * TOOL_WIDTH;
        int y = (i / 2) * TOOL_HEIGHT;

        bool select = (wxGetApp().getEventManager()->getToolType() == i);
        wxImage* bmp = &this->toolBitmaps[i];
        if(select){
            bmp = &this->selectedToolBitmaps[i];
        }
        dc.DrawBitmap(*bmp, x, y);
    }
}

void ToolDialog::OnLeftDown(wxMouseEvent& ev)
{
    hpl::aleph::HPLEventManager* emgr = wxGetApp().getEventManager();
    int oldIndex = emgr->getToolType();
    //Ic[ɐݒ肷
    for(int i = 0; i < ToolType::NUMBER_OF_TOOLS; i ++){
        int left = (i % 2) * TOOL_WIDTH;
        int top = (i / 2) * TOOL_HEIGHT;
        int right = left + TOOL_WIDTH;
        int bottom = top + TOOL_HEIGHT;

        if(hpl::math::isPointInRect<int>(ev.m_x, ev.m_y,
            left, top, right, bottom))
        {
            //ω
            emgr->setToolType(i);

            //ǉc[̏
            wxGetApp().resetLineEditInfo();

            if(i == ToolType::TI_SKULL){
                //IuWFNgc[
                //vpeB\
                ((MapEditorMainFrame*)GetParent())->objPropDialog.setObjIndex(NONE);
                ((MapEditorMainFrame*)GetParent())->objPropDialog.Show();

            }else if(i == ToolType::TI_POLYGON){
                //|Sc[
                //K̃|Sǉc[
                //TODO Preset polygons
                PolygonNumDialog polyNumDialog;
                polyNumDialog.Create(this, wxID_ANY);
                int num = polyNumDialog.ShowModal();
                if(num >= 3 && num <= 8){
                    //lݒ
                    wxGetApp().presetPolygonVertexCount = num;
                }
                
            }
            if(i != oldIndex){
                //TODO
                //͈͑I[h
                emgr->setSelectingGroup(false);
                //I
                //wxGetApp().selectData.clear();
            }
            Refresh();
            //J[\ω
            //TODO cursor
            wxGetApp().setCursor();
        }
    }
}
