package MaceWindu;

import gnu.io.*;
import java.awt.event.ItemEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MaceWindu extends javax.swing.JFrame {
    SerialPort COM;
    OutputStream ComOut;
    InputStream ComInputStream;
    BufferedReader COMReader;
    String PreviousPortname;
    String PortName;
    byte[] buffer = new byte[1024];
    int Recieve;
    int BaudRate=0;
    int DataBits=8;
    int StopBits=1;
    int Parity=0;
    int HandShake=0;
    
    boolean ButtonState = false;
    
    public MaceWindu() {
        //System.setProperty("awt.useSystemAAFontSettings","on");
        //System.setProperty("swing.aatext", "true");
        ChangeLookAndFeel();
        initComponents();
        AvailableComPort();
        ReadListenerEnable();
        MsgLabel.setText(null);
    }
    
    private void ChangeLookAndFeel(){
        try
        {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch(Exception e)
        {
            MsgLabel.setText("Some Expention While Change LookAndFeel");
        }
    }
        
    private int ConvertStr2Int(String Strvalue, int Intvalue){
        //文字列(string)を整数(int)にする関数
        //IntValueはエラーの時に返すやつ。だから，実行するときにエラーで返してほしいやつ指定する
        try 
        {
            return Integer.parseInt(Strvalue);
        } 
        catch (NumberFormatException e) 
        {
            return Intvalue;
        }
    }
   
    private void AvailableComPort(){
        PortsComboBox.removeAllItems();
        PortsComboBox.addItem("-Ports-");
        CommPortIdentifier portID = null;
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        if (portEnum.hasMoreElements()){
            while (portEnum.hasMoreElements()){
                CommPortIdentifier currPortId = (CommPortIdentifier) portEnum.nextElement();
                PortsComboBox.addItem(currPortId.getName());
            }
            PortsComboBox.setSelectedIndex(0);
            
        }else{
            JOptionPane.showMessageDialog(rootPane, "There Is No Available COM Port");
        }
    }
    
    private void OpenComPort(String port){
        try
        {
            CommPortIdentifier comID = CommPortIdentifier.getPortIdentifier(port);
            CommPort commPort = comID.open("Com", 2000);
            //引数はstring アプリケーション名 int タイムアウト時間 らしい (アプリケーション名は何にしてもおｋ!!ww)
            COM = (SerialPort)commPort;
            COM.setSerialPortParams(BaudRate, DataBits, StopBits, Parity);
            //COM.setSerialPortParams(2400, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
            COM.setFlowControlMode(SerialPort.FLOWCONTROL_NONE);
            MsgLabel.setText(PortName + " Opened Successfully");
            ComboBoxEnSelect(true);
            ReadListenerEnable();
            ReadEnable();
            WriteEnable();
        }
        catch (Exception e)
        {
            MsgLabel.setText("Failed to Open " + PortName);
            ComboBoxEnSelect(false);
        }
    }
    
    private void CloseComPort(){
        try
        {
            COM.close();
        }
        catch(Exception e)
        {
            MsgLabel.setText("Failed To Close " + PreviousPortname);
        }
    }
    
    private void ComboBoxEnSelect(boolean i){
        if (i == true){
            BaudRateComboBox.setEnabled(true);
            DataBitsComboBox.setEnabled(true);
            StopBitsComboBox.setEnabled(true);
            ParityComboBox.setEnabled(true);
            HandShakeComboBox.setEnabled(true);
        }else{
            BaudRateComboBox.setEnabled(false);
            DataBitsComboBox.setEnabled(false);
            StopBitsComboBox.setEnabled(false);
            ParityComboBox.setEnabled(false);
            HandShakeComboBox.setEnabled(false);
        }
    }
    
    public void WriteEnable(){
            try {
            ComOut = COM.getOutputStream();            
        } catch (Exception e) {
             MsgLabel.setText("Error_OutputStream");
        } 
    }
    
    public void ReadEnable(){
        try {
            ComInputStream = COM.getInputStream();
            COMReader = new BufferedReader(new InputStreamReader(COM.getInputStream()));
        } catch (Exception e) {
            MsgLabel.setText("Exception In ReadEnable()");
        }
    }
    
    private void ReadLine(){
        String RecievedString;
        //JOptionPane.showMessageDialog(rootPane, "受け取ったけどtryの外");
        try {
            while(COMReader.ready()){
                RecievedString = COMReader.readLine();
                //RecieveString = String.valueOf(Recieve);
                DataLabel.setText(RecievedString);
                RecievedDataTextArea.append(RecievedString);
                System.out.println(RecievedString);
                //JOptionPane.showMessageDialog(rootPane, "受信成功！");
                MsgLabel.setText("Data Received Successfully!!");
            }
        }
        catch (IOException e) {
        }        
    }
    
    private void ReadListenerEnable(){
        try {
            COM.addEventListener(new SerialPortlistener());
            COM.notifyOnDataAvailable(true);
            COM.enableReceiveThreshold(1);
        } catch (TooManyListenersException e) {
            MsgLabel.setText("Error : TooManyListenersException");
        }
        catch(Exception e){
            MsgLabel.setText("Error Occured While ReadListenerEnable");
        }
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        RecievedDataTextArea = new javax.swing.JTextArea();
        jButton1 = new javax.swing.JButton();
        MsgLabel = new javax.swing.JLabel();
        PortsComboBox = new javax.swing.JComboBox();
        BaudRateComboBox = new javax.swing.JComboBox();
        DataBitsComboBox = new javax.swing.JComboBox();
        StopBitsComboBox = new javax.swing.JComboBox();
        ParityComboBox = new javax.swing.JComboBox();
        HandShakeComboBox = new javax.swing.JComboBox();
        DataLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("MaceWindu");

        jPanel1.setMaximumSize(new java.awt.Dimension(50000, 50000));

        jScrollPane1.setAutoscrolls(true);

        RecievedDataTextArea.setColumns(20);
        RecievedDataTextArea.setRows(5);
        jScrollPane1.setViewportView(RecievedDataTextArea);

        jButton1.setText("jButton1");
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButton1MouseClicked(evt);
            }
        });

        MsgLabel.setText("jLabel1");

        PortsComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "-Ports-" }));
        PortsComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                PortsComboBoxItemStateChanged(evt);
            }
        });

        BaudRateComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "-Baud Rate-", "300", "600", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200" }));
        BaudRateComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                BaudRateComboBoxItemStateChanged(evt);
            }
        });

        DataBitsComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "-Data Bits-", "5", "6", "7", "8" }));
        DataBitsComboBox.setSelectedIndex(4);
        DataBitsComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                DataBitsComboBoxItemStateChanged(evt);
            }
        });

        StopBitsComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "-Stop Bits-", "1", "1.5", "2" }));
        StopBitsComboBox.setSelectedIndex(1);
        StopBitsComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                StopBitsComboBoxItemStateChanged(evt);
            }
        });

        ParityComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "-Parity-", "Even", "Mark", "None", "Odd", "Space" }));
        ParityComboBox.setSelectedIndex(3);
        ParityComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                ParityComboBoxItemStateChanged(evt);
            }
        });

        HandShakeComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "-Hand Shake-", "None", "RTSCTS_IN", "TRSCTS_OUT", "XOnXOff_IN", "XOnXOff_OUT" }));
        HandShakeComboBox.setSelectedIndex(1);
        HandShakeComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                HandShakeComboBoxItemStateChanged(evt);
            }
        });

        DataLabel.setText("jLabel1");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(MsgLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 730, Short.MAX_VALUE)
                        .addComponent(jButton1))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 804, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(DataLabel)
                                .addGroup(jPanel1Layout.createSequentialGroup()
                                    .addComponent(PortsComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 122, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(BaudRateComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 122, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(DataBitsComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 122, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(StopBitsComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 122, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(ParityComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 122, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(HandShakeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 170, javax.swing.GroupLayout.PREFERRED_SIZE))))
                        .addGap(0, 0, Short.MAX_VALUE))))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(PortsComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(BaudRateComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(DataBitsComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(StopBitsComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ParityComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(HandShakeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 233, Short.MAX_VALUE)
                .addComponent(DataLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton1)
                    .addComponent(MsgLabel)))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents


    
    private void WriteLine(String strsend){
        if (BaudRateComboBox.getSelectedIndex() == 0){
            MsgLabel.setText("Error : Please Select Baud Rate");
        }
        try {
            byte[] data = strsend.getBytes();
            //Thread.sleep(1000);
            ComOut.write(data);
            //JOptionPane.showMessageDialog(rootPane, "送信完了!!!");
        } catch (Exception e) {
            MsgLabel.setText("Error_WriteLine");
        }
    }
    
    private void jButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseClicked
        //COM.setSerialPortParams(2400, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
        WriteLine("String For Test !!!! lol\r");
    }//GEN-LAST:event_jButton1MouseClicked

    private void PortsComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_PortsComboBoxItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED){
                PortName = PortsComboBox.getSelectedItem().toString();
                if (PortsComboBox.getSelectedIndex() >= 1){
                    ComboBoxEnSelect(true);
                    MsgLabel.setVisible(true);
                    CloseComPort();
                    OpenComPort(PortName);
                    PreviousPortname = PortsComboBox.getSelectedItem().toString();
                }else{
                    ComboBoxEnSelect(false);
                    MsgLabel.setVisible(false);
                }
            }
    }//GEN-LAST:event_PortsComboBoxItemStateChanged

    private void BaudRateComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_BaudRateComboBoxItemStateChanged
        CloseComPort();
        if (evt.getStateChange() == ItemEvent.SELECTED){
            if (BaudRateComboBox.getSelectedIndex() >= 1){
                BaudRate = ConvertStr2Int(BaudRateComboBox.getSelectedItem().toString(), 0);
                if (BaudRate != 0){
                    try {
                        OpenComPort(PortName);
                        MsgLabel.setText("BaudRate Successfully Changed to " + BaudRateComboBox.getSelectedItem().toString());
                    } 
                    catch (Exception e)
                    {
                        MsgLabel.setText("Failed to Change BaudRate");
                    }

                }else{
                    MsgLabel.setText("Unknown BaudRate Value");
                }
            }else{
                MsgLabel.setText("");
            }
        }
    }//GEN-LAST:event_BaudRateComboBoxItemStateChanged

    private void DataBitsComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_DataBitsComboBoxItemStateChanged
        CloseComPort();
        if (evt.getStateChange() == ItemEvent.SELECTED){
            if (DataBitsComboBox.getSelectedIndex() >= 1){
                DataBits = ConvertStr2Int(DataBitsComboBox.getSelectedItem().toString(), 0);
                if (DataBits != 0){
                    try
                    {
                        OpenComPort(PortName);
                        MsgLabel.setText("Data Bits Successfully Changed to " + DataBitsComboBox.getSelectedItem().toString());
                    }
                    catch (Exception e)
                    {
                        MsgLabel.setText("Failed to Change Data Bits");
                    }
                }
            }else{
                MsgLabel.setText("");
            }
        }
    }//GEN-LAST:event_DataBitsComboBoxItemStateChanged

    private void StopBitsComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_StopBitsComboBoxItemStateChanged
        CloseComPort();
        if (evt.getStateChange() == ItemEvent.SELECTED){
            if (StopBitsComboBox.getSelectedIndex() >= 1){
                if (StopBitsComboBox.getSelectedIndex() == 1){
                    StopBits = 1;
                }
                if (StopBitsComboBox.getSelectedIndex() == 2){
                    StopBits = 3;
                }
                if (StopBitsComboBox.getSelectedIndex() == 3){
                    StopBits = 2;
                }
                try {
                    OpenComPort(PortName);
                    MsgLabel.setText("Stop Bits Successfully Changed to " + StopBitsComboBox.getSelectedItem().toString());
                } catch (Exception e) {
                    MsgLabel.setText("Failed to Change Stop Bits");
                }
            }else{
                MsgLabel.setText("");
            }
        }
    }//GEN-LAST:event_StopBitsComboBoxItemStateChanged

    private void ParityComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_ParityComboBoxItemStateChanged
        CloseComPort();
        if (evt.getStateChange() == ItemEvent.SELECTED){
            if (ParityComboBox.getSelectedIndex() >= 1){
                if (ParityComboBox.getSelectedIndex() == 1){
                    Parity = 2;
                }
                if (ParityComboBox.getSelectedIndex() == 2){
                    Parity = 3;
                }
                if (ParityComboBox.getSelectedIndex() == 3){
                    Parity = 0;
                }
                if (ParityComboBox.getSelectedIndex() == 4){
                    Parity  =1;
                }
                if (ParityComboBox.getSelectedIndex() == 5){
                    Parity = 4;
                }
                try {
                    OpenComPort(PortName);
                    MsgLabel.setText("Parity Successfully Changed to " + ParityComboBox.getSelectedItem().toString());
                } catch (Exception e) {
                    MsgLabel.setText("Failed to Change Parity");
                }
            }else{
                MsgLabel.setText("");
            }
        }
    }//GEN-LAST:event_ParityComboBoxItemStateChanged

    private void HandShakeComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_HandShakeComboBoxItemStateChanged
        CloseComPort();
        if (evt.getStateChange() == ItemEvent.SELECTED){
            if (HandShakeComboBox.getSelectedIndex() >= 1){
                if (HandShakeComboBox.getSelectedIndex() == 1){
                    HandShake = 0;
                }
                if (HandShakeComboBox.getSelectedIndex() == 2){
                    HandShake = 1;
                }
                if (HandShakeComboBox.getSelectedIndex() == 3){
                    HandShake = 2;
                }
                if (HandShakeComboBox.getSelectedIndex() == 4){
                    HandShake = 4;
                }
                if (HandShakeComboBox.getSelectedIndex() == 5){
                    HandShake = 8;
                }
                try {
                    OpenComPort(PortName);
                    MsgLabel.setText("HandShake Successfully Changed to " + HandShakeComboBox.getSelectedItem().toString());
                } catch (Exception e) {
                    MsgLabel.setText("Failed to Change HandShake");
                }
            }else{
                MsgLabel.setText("");
            }
        }
    }//GEN-LAST:event_HandShakeComboBoxItemStateChanged

    public class SerialPortlistener implements  SerialPortEventListener{
        @Override
        public void serialEvent(SerialPortEvent e){
            if (e.getEventType() == SerialPortEvent.DATA_AVAILABLE){
                ReadLine();
            }
        }
    }
    
    public static void main(String args[]) {
        
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new MaceWindu().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JComboBox BaudRateComboBox;
    public javax.swing.JComboBox DataBitsComboBox;
    public javax.swing.JLabel DataLabel;
    public javax.swing.JComboBox HandShakeComboBox;
    public javax.swing.JLabel MsgLabel;
    public javax.swing.JComboBox ParityComboBox;
    public javax.swing.JComboBox PortsComboBox;
    private javax.swing.JTextArea RecievedDataTextArea;
    public javax.swing.JComboBox StopBitsComboBox;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
}