/*
 * Decompiled with CFR 0.152.
 */
package MaceWindu;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class MaceWindu
extends JFrame {
    SerialPort COM;
    OutputStream ComOut;
    InputStream ComInputStream;
    BufferedReader COMReader;
    String PreviousPortname;
    String PortName;
    byte[] buffer = new byte[1024];
    int Recieve;
    int BaudRate = 0;
    int DataBits = 8;
    int StopBits = 1;
    int Parity = 0;
    int HandShake = 0;
    boolean ButtonState = false;
    public JComboBox BaudRateComboBox;
    public JComboBox DataBitsComboBox;
    public JLabel DataLabel;
    public JComboBox HandShakeComboBox;
    public JLabel MsgLabel;
    public JComboBox ParityComboBox;
    public JComboBox PortsComboBox;
    public JComboBox StopBitsComboBox;
    private JButton jButton1;
    private JPanel jPanel1;

    public MaceWindu() {
        this.ChangeLookAndFeel();
        this.initComponents();
        this.AvailableComPort();
        this.ReadListenerEnable();
        this.MsgLabel.setText(null);
    }

    private void ChangeLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            this.MsgLabel.setText("Some Expention While Change LookAndFeel");
        }
    }

    private int ConvertStr2Int(String Strvalue, int Intvalue) {
        try {
            return Integer.parseInt(Strvalue);
        }
        catch (NumberFormatException e) {
            return Intvalue;
        }
    }

    private void AvailableComPort() {
        this.PortsComboBox.removeAllItems();
        this.PortsComboBox.addItem("-Ports-");
        Object portID = null;
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        if (portEnum.hasMoreElements()) {
            while (portEnum.hasMoreElements()) {
                CommPortIdentifier currPortId = (CommPortIdentifier)portEnum.nextElement();
                this.PortsComboBox.addItem(currPortId.getName());
            }
            this.PortsComboBox.setSelectedIndex(0);
        } else {
            JOptionPane.showMessageDialog(this.rootPane, "There Is No Available COM Port");
        }
    }

    private void OpenComPort(String port) {
        try {
            CommPortIdentifier comID = CommPortIdentifier.getPortIdentifier(port);
            CommPort commPort = comID.open("Com", 2000);
            this.COM = (SerialPort)commPort;
            this.COM.setSerialPortParams(this.BaudRate, this.DataBits, this.StopBits, this.Parity);
            this.COM.setFlowControlMode(0);
            this.MsgLabel.setText(this.PortName + " Opened Successfully");
            this.ComboBoxEnSelect(true);
            this.ReadListenerEnable();
            this.ReadEnable();
            this.WriteEnable();
        }
        catch (Exception e) {
            this.MsgLabel.setText("Failed to Open " + this.PortName);
            this.ComboBoxEnSelect(false);
        }
    }

    private void CloseComPort() {
        try {
            this.COM.close();
        }
        catch (Exception e) {
            this.MsgLabel.setText("Failed To Close " + this.PreviousPortname);
        }
    }

    private void ComboBoxEnSelect(boolean i) {
        if (i) {
            this.BaudRateComboBox.setEnabled(true);
            this.DataBitsComboBox.setEnabled(true);
            this.StopBitsComboBox.setEnabled(true);
            this.ParityComboBox.setEnabled(true);
            this.HandShakeComboBox.setEnabled(true);
        } else {
            this.BaudRateComboBox.setEnabled(false);
            this.DataBitsComboBox.setEnabled(false);
            this.StopBitsComboBox.setEnabled(false);
            this.ParityComboBox.setEnabled(false);
            this.HandShakeComboBox.setEnabled(false);
        }
    }

    public void WriteEnable() {
        try {
            this.ComOut = this.COM.getOutputStream();
        }
        catch (Exception e) {
            this.MsgLabel.setText("Error_OutputStream");
        }
    }

    public void ReadEnable() {
        try {
            this.ComInputStream = this.COM.getInputStream();
            this.COMReader = new BufferedReader(new InputStreamReader(this.COM.getInputStream()));
        }
        catch (Exception e) {
            this.MsgLabel.setText("Exception In ReadEnable()");
        }
    }

    private void DataRead() {
        try {
            while (this.COMReader.ready()) {
                String RecieveString = this.COMReader.readLine();
                this.DataLabel.setText(RecieveString);
                System.out.println(RecieveString);
                this.MsgLabel.setText("Data Received Successfully!!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ReadListenerEnable() {
        try {
            this.COM.addEventListener(new SerialPortlistener());
            this.COM.notifyOnDataAvailable(true);
            this.COM.enableReceiveThreshold(1);
        }
        catch (TooManyListenersException e) {
            this.MsgLabel.setText("TooManyListenersException");
        }
        catch (Exception e) {
            this.MsgLabel.setText("Error Occured While ReadListenerEbale");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.MsgLabel = new JLabel();
        this.PortsComboBox = new JComboBox();
        this.BaudRateComboBox = new JComboBox();
        this.DataBitsComboBox = new JComboBox();
        this.StopBitsComboBox = new JComboBox();
        this.ParityComboBox = new JComboBox();
        this.HandShakeComboBox = new JComboBox();
        this.DataLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("MaceWindu");
        this.jPanel1.setMaximumSize(new Dimension(50000, 50000));
        this.jButton1.setText("jButton1");
        this.jButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MaceWindu.this.jButton1MouseClicked(evt);
            }
        });
        this.MsgLabel.setText("jLabel1");
        this.PortsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Ports-"}));
        this.PortsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.PortsComboBoxItemStateChanged(evt);
            }
        });
        this.BaudRateComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Baud Rate-", "300", "600", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200"}));
        this.BaudRateComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.BaudRateComboBoxItemStateChanged(evt);
            }
        });
        this.DataBitsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Data Bits-", "5", "6", "7", "8"}));
        this.DataBitsComboBox.setSelectedIndex(4);
        this.DataBitsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.DataBitsComboBoxItemStateChanged(evt);
            }
        });
        this.StopBitsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Stop Bits-", "1", "1.5", "2"}));
        this.StopBitsComboBox.setSelectedIndex(1);
        this.StopBitsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.StopBitsComboBoxItemStateChanged(evt);
            }
        });
        this.ParityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Parity-", "Even", "Mark", "None", "Odd", "Space"}));
        this.ParityComboBox.setSelectedIndex(3);
        this.ParityComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.ParityComboBoxItemStateChanged(evt);
            }
        });
        this.HandShakeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Hand Shake-", "None", "RTSCTS_IN", "TRSCTS_OUT", "XOnXOff_IN", "XOnXOff_OUT"}));
        this.HandShakeComboBox.setSelectedIndex(1);
        this.HandShakeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.HandShakeComboBoxItemStateChanged(evt);
            }
        });
        this.DataLabel.setText("jLabel1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.MsgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 730, Short.MAX_VALUE).addComponent(this.jButton1)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.PortsComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BaudRateComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DataBitsComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StopBitsComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ParityComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HandShakeComboBox, -2, 170, -2)).addComponent(this.DataLabel)).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PortsComboBox, -2, -1, -2).addComponent(this.BaudRateComboBox, -2, -1, -2).addComponent(this.DataBitsComboBox, -2, -1, -2).addComponent(this.StopBitsComboBox, -2, -1, -2).addComponent(this.ParityComboBox, -2, -1, -2).addComponent(this.HandShakeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 395, Short.MAX_VALUE).addComponent(this.DataLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.MsgLabel))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void WriteLine(String strsend) {
        try {
            byte[] data = strsend.getBytes();
            this.ComOut.write(data);
        }
        catch (Exception e) {
            this.MsgLabel.setText("Error_WriteLine");
        }
    }

    private void jButton1MouseClicked(MouseEvent evt) {
        this.WriteLine("String For Test !!!! lol\r");
    }

    private void PortsComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.PortName = this.PortsComboBox.getSelectedItem().toString();
            if (this.PortsComboBox.getSelectedIndex() >= 1) {
                this.ComboBoxEnSelect(true);
                this.MsgLabel.setVisible(true);
                this.CloseComPort();
                this.OpenComPort(this.PortName);
                this.PreviousPortname = this.PortsComboBox.getSelectedItem().toString();
            } else {
                this.ComboBoxEnSelect(false);
                this.MsgLabel.setVisible(false);
            }
        }
    }

    private void BaudRateComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1) {
            if (this.BaudRateComboBox.getSelectedIndex() >= 1) {
                this.BaudRate = this.ConvertStr2Int(this.BaudRateComboBox.getSelectedItem().toString(), 0);
                if (this.BaudRate != 0) {
                    try {
                        this.OpenComPort(this.PortName);
                        this.MsgLabel.setText("BaudRate Successfully Changed to " + this.BaudRateComboBox.getSelectedItem().toString());
                    }
                    catch (Exception e) {
                        this.MsgLabel.setText("Failed to Change BaudRate");
                    }
                } else {
                    this.MsgLabel.setText("Unknown BaudRate Value");
                }
            } else {
                this.MsgLabel.setText("");
            }
        }
    }

    private void DataBitsComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1) {
            if (this.DataBitsComboBox.getSelectedIndex() >= 1) {
                this.DataBits = this.ConvertStr2Int(this.DataBitsComboBox.getSelectedItem().toString(), 0);
                if (this.DataBits != 0) {
                    try {
                        this.OpenComPort(this.PortName);
                        this.MsgLabel.setText("Data Bits Successfully Changed to " + this.DataBitsComboBox.getSelectedItem().toString());
                    }
                    catch (Exception e) {
                        this.MsgLabel.setText("Failed to Change Data Bits");
                    }
                }
            } else {
                this.MsgLabel.setText("");
            }
        }
    }

    private void StopBitsComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1) {
            if (this.StopBitsComboBox.getSelectedIndex() >= 1) {
                if (this.StopBitsComboBox.getSelectedIndex() == 1) {
                    this.StopBits = 1;
                }
                if (this.StopBitsComboBox.getSelectedIndex() == 2) {
                    this.StopBits = 3;
                }
                if (this.StopBitsComboBox.getSelectedIndex() == 3) {
                    this.StopBits = 2;
                }
                try {
                    this.OpenComPort(this.PortName);
                    this.MsgLabel.setText("Stop Bits Successfully Changed to " + this.StopBitsComboBox.getSelectedItem().toString());
                }
                catch (Exception e) {
                    this.MsgLabel.setText("Failed to Change Stop Bits");
                }
            } else {
                this.MsgLabel.setText("");
            }
        }
    }

    private void ParityComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1) {
            if (this.ParityComboBox.getSelectedIndex() >= 1) {
                if (this.ParityComboBox.getSelectedIndex() == 1) {
                    this.Parity = 2;
                }
                if (this.ParityComboBox.getSelectedIndex() == 2) {
                    this.Parity = 3;
                }
                if (this.ParityComboBox.getSelectedIndex() == 3) {
                    this.Parity = 0;
                }
                if (this.ParityComboBox.getSelectedIndex() == 4) {
                    this.Parity = 1;
                }
                if (this.ParityComboBox.getSelectedIndex() == 5) {
                    this.Parity = 4;
                }
                try {
                    this.OpenComPort(this.PortName);
                    this.MsgLabel.setText("Parity Successfully Changed to " + this.ParityComboBox.getSelectedItem().toString());
                }
                catch (Exception e) {
                    this.MsgLabel.setText("Failed to Change Parity");
                }
            } else {
                this.MsgLabel.setText("");
            }
        }
    }

    private void HandShakeComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1) {
            if (this.HandShakeComboBox.getSelectedIndex() >= 1) {
                if (this.HandShakeComboBox.getSelectedIndex() == 1) {
                    this.HandShake = 0;
                }
                if (this.HandShakeComboBox.getSelectedIndex() == 2) {
                    this.HandShake = 1;
                }
                if (this.HandShakeComboBox.getSelectedIndex() == 3) {
                    this.HandShake = 2;
                }
                if (this.HandShakeComboBox.getSelectedIndex() == 4) {
                    this.HandShake = 4;
                }
                if (this.HandShakeComboBox.getSelectedIndex() == 5) {
                    this.HandShake = 8;
                }
                try {
                    this.OpenComPort(this.PortName);
                    this.MsgLabel.setText("HandShake Successfully Changed to " + this.HandShakeComboBox.getSelectedItem().toString());
                }
                catch (Exception e) {
                    this.MsgLabel.setText("Failed to Change HandShake");
                }
            } else {
                this.MsgLabel.setText("");
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MaceWindu().setVisible(true);
            }
        });
    }

    public class SerialPortlistener
    implements SerialPortEventListener {
        @Override
        public void serialEvent(SerialPortEvent e) {
            if (e.getEventType() == 1) {
                MaceWindu.this.DataRead();
            }
        }
    }
}

