/*
 * Copyright (c) since 2006 NTT DATA CORPORATION.
 * All rights reserved.
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>

#ifdef TEXTPORTER
#include <text_oem.h>

static inline BOOL CallBackFunc(LDDMC_OLEERR* OleErr)
{
  return 0;
}

int _DMC_GetText_V4(unsigned char *path_bin, unsigned char *path_txt,
                    unsigned char *groupname, unsigned char *deflangname,
                    int bbigendian, unsigned int option, unsigned int option1,
                    long long size, unsigned short csv_c, int flag)
{
  int iRet;
  DMC_TEXTINFO_V4 textinfo;

  strcpy((char *)textinfo.GroupName, groupname);
  strcpy((char *)textinfo.DefLangName, deflangname);
  textinfo.bBigEndian = bbigendian;
  textinfo.Option = option;
  if (flag) {
    textinfo.Option = textinfo.Option | DMC_GETTEXT_OPT_OUT;
  } else {
    textinfo.Option = textinfo.Option;
  }
  textinfo.Option1 = option1;
  textinfo.Size    = size;
  textinfo.Csv_c   = csv_c;
  iRet = DMC_GetText_V4((Byte*)path_bin,
                        (Byte*)path_txt,
                        &textinfo,
                        (DMC_OLEERR_CALLBACK)CallBackFunc);
  return iRet;
}

#endif   /* TEXTPORTER */
