/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2014 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiLastBoss.h,v 1.13 2014/01/07 23:44:46 bowkenken Exp $
***************************************************************/

#ifndef GUI_LAST_BOSS_H
#define GUI_LAST_BOSS_H	1

////////////////////////////////////////////////////////////////
// 饹ܥ (GUI)
////////////////////////////////////////////////////////////////

#include "last-boss.h"
#include "last-boss-prot.h"

#include "Pcg.h"

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

union XxAttackData {
	xx_heat_t heat;
	xx_cold_t cold;
	xx_mind_t mind;
	xx_acid_t acid;
	xx_rotation_t rotation;
	xx_whirl_t whirl;
	xx_fan_t fan;
};

struct XxAttack {
	xx_act_kind_t kind;
	XxAttackData data;
};

////////////////////////////////////////////////////////////////

class GuiLastBoss {

	//////// ץ饤١ȡСѿ ////////
private:

	// ѥ
	Pcg pcgSkull;
	Pcg pcgJaw;
	Pcg pcgBody;
	Pcg pcgUpperArmLeft;
	Pcg pcgUpperArmRight;
	Pcg pcgForeArmLeft;
	Pcg pcgForeArmRight;
	Pcg pcgForeArmSlapLeft;
	Pcg pcgForeArmSlapRight;
	Pcg pcgHandLeft;
	Pcg pcgHandRight;
	Pcg pcgHandSlapLeft;
	Pcg pcgHandSlapRight;

	// XX ι
	XxAttack xxAttack;
	Pcg pcgXxHeat;
	Pcg pcgXxCold;
	Pcg pcgXxBit;
	Pcg pcgXxMind;
	Pcg pcgXxAcid;
	Pcg pcgXxRotation;
	Pcg pcgXxWhirl;
	Pcg pcgXxFan;

	// Ƭκɸ

	long skullW;
	long skullH;
	long skullX;
	long skullY;

	// κɸ

	long jawW;
	long jawH;
	long jawX;
	long jawY;

	// κɸ ()

	long jawOpenW;
	long jawOpenH;
	long jawOpenX;
	long jawOpenY;

	// Τκɸ

	long bodyW;
	long bodyH;
	long bodyX;
	long bodyY;

	// Ӥκɸ

	long upperArmLeftW;
	long upperArmLeftH;
	long upperArmLeftX;
	long upperArmLeftY;

	// Ӥκɸ

	long upperArmRightW;
	long upperArmRightH;
	long upperArmRightX;
	long upperArmRightY;

	// Ӥκɸ

	long foreArmLeftW;
	long foreArmLeftH;
	long foreArmLeftX;
	long foreArmLeftY;

	// Ӥκɸ (ʿǤ)

	long foreArmSlapLeftW;
	long foreArmSlapLeftH;
	long foreArmSlapLeftX;
	long foreArmSlapLeftY;

	// Ӥκɸ

	long foreArmRightW;
	long foreArmRightH;
	long foreArmRightX;
	long foreArmRightY;

	// Ӥκɸ (ʿǤ)

	long foreArmSlapRightW;
	long foreArmSlapRightH;
	long foreArmSlapRightX;
	long foreArmSlapRightY;

	// κɸ

	long handLeftW;
	long handLeftH;
	long handLeftX;
	long handLeftY;

	// κɸ (ʿǤ)

	long handSlapLeftW;
	long handSlapLeftH;
	long handSlapLeftX;
	long handSlapLeftY;

	// κɸ

	long handRightW;
	long handRightH;
	long handRightX;
	long handRightY;

	// κɸ (ʿǤ)

	long handSlapRightW;
	long handSlapRightH;
	long handSlapRightX;
	long handSlapRightY;

	//////// ѥ֥åСѿ ////////
public:

	//////// ѥ֥åСؿ ////////
public:

	GuiLastBoss();
	~GuiLastBoss();
	void init();
	void initPcg( Pcg *pcg, WSCstring dirName );

	void setDraw();
	void drawBg();
	void drawFg();
	void drawPcg( Pcg *p, long x, long y, long w, long h );

	void setXxAttack( xx_act_kind_t kind, void *p );
	bool drawXxAttack(
		long mapX, long mapY, long mapW, long mapH );

	//////// ץ饤١ȡСؿ ////////
private:

	bool drawXxAttackHeat(
		long mapX, long mapY, long mapW, long mapH );
	bool drawXxAttackCold(
		long mapX, long mapY, long mapW, long mapH );
	bool drawXxAttackMind(
		long mapX, long mapY, long mapW, long mapH );
	bool drawXxAttackAcid(
		long mapX, long mapY, long mapW, long mapH );
	bool drawXxAttackRotation(
		long mapX, long mapY, long mapW, long mapH );
	bool drawXxAttackWhirl(
		long mapX, long mapY, long mapW, long mapH );
	bool drawXxAttackFan(
		long mapX, long mapY, long mapW, long mapH );
};

#endif // GUI_LAST_BOSS_H
