/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2014 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: CuiMouse.h,v 1.9 2014/01/07 23:44:46 bowkenken Exp $
***************************************************************/

#ifndef CUI_MOUSE_H
#define CUI_MOUSE_H	1

////////////////////////////////////////////////////////////////
// 󥽡롦ޥ
////////////////////////////////////////////////////////////////

#include	<stdio.h>

#ifdef	HAVE_GLIB_H
# include	<glib.h>
#else
typedef	unsigned int guint;
#endif

#include	"menu.h"

////////////////////////////////////////////////////////////////
// ϥɥ顦ơ֥
////////////////////////////////////////////////////////////////

#define	CUI_MOUSE_HANDLER_TAB_MAX_N	80

struct CuiMouseHandlerTab {
	// ̵ͭե饰
	bool flagEnable;
	// åȿû
	long x, y, w, h;
	// ݥȻΥϥɥ
	bool_t (*funcPoint)( long btn, long n, const char *macro );
	// åΥϥɥ
	bool_t (*funcClick)( long btn, long n, const char *macro );
	// Υϥɥ
	bool_t (*funcScroll)( long btn, long n, const char *macro );
	// ϥɥؤΰ ()
	long argN;
	// ϥɥؤΰ (ޥ)
	char argMacro[MACRO_MAX_LEN + 1];
};

////////////////////////////////////////////////////////////////

class CuiMouse {

// ץ饤١ȡСѿ
private:

	bool flagReset;
	bool flagEnable;
	bool flagTerm;
	bool flagNoButtonRight;
	bool flagSwapButtonMiddleAndRight;
	const char *envTerm;
	const char *termName;
	FILE *ttyFP;

	guint doubleClickTimer;
	bool flagDoubleClickTime;

	long handlerTabCurN;
	CuiMouseHandlerTab handlerTab[CUI_MOUSE_HANDLER_TAB_MAX_N];

// ѥ֥åСѿ
public:

// ѥ֥åСؿ
public:

	CuiMouse();
	~CuiMouse();
	void init();
	void close();

	long checkEvent( long c );
	long getCharX();
	long getCharY();

	void enableTimer();
	void disableTimer();
	long getDoubleClickMsec();
	void setDoubleClickMsec( long msec );

	void resetHandlerTab();
	long addHandler(
		bool flagEnable,
		long x, long y, long w, long h,
		bool_t (*funcPoint)( long btn, long n, const char *macro ),
		bool_t (*funcClick)( long btn, long n, const char *macro ),
		bool_t (*funcScroll)( long btn, long n, const char *macro ),
		long argN,
		const char *argMacro
	);
	bool checkCallHandler(
		long nBtn,
		long x, long y,
		bool flagPoint,
		bool flagClick = false,
		bool flagScroll = false
	);

// ץ饤١ȡСؿ
private:
};

#endif /* CUI_MOUSE_H */
