#ifndef	__TRAP_H__
#define	__TRAP_H__

#include	"gmain.h"
#include	"msg.h"

#if	defined( NDEBUG ) || !defined( D_TEST_TRAP )
# define	TRAP_AVE_N	16
# define	TRAP_MAX_N	512
#else
# define	TRAP_AVE_N	1024
# define	TRAP_MAX_N	2048
#endif

typedef enum {
	TRAP_KIND_NULL,
	TRAP_KIND_SLEEP,
	TRAP_KIND_ARW,
	TRAP_KIND_POISON_DARTS,
	TRAP_KIND_TELEPORT_PARTY,
	TRAP_KIND_TELEPORT,
	TRAP_KIND_MAX_N
} trap_kind_t;

typedef struct {
	trap_kind_t	kind;
	char	*name;
	n_msg_t	name_n;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
} trap_tab_t;

typedef struct trap_t {
	struct trap_t	*next, *prev;
	trap_kind_t	kind;
	long	x, y;
	long	difficulty;
	trap_tab_t	*tab;
} trap_t;

#endif	/* __TRAP_H__ */
