/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
/*#include	<string.h>*/
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
#include	"dun.h"
/*#include	"town.h"*/
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
#include	"fx.h"
#include	"trap.h"
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
/*#include	"item_prot.h"*/
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
/*#include	"party_prot.h"*/
/*#include	"mnstr_prot.h"*/
/*#include	"fight_prot.h"*/
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

#define	TRAP_DIFFICULTY_LEV_RATE	20

#define	TRAP_MAX_RATE	100
#define	TRAP_MIN_RATE	50

#define	FX_AVE_TURN_TRAP_SLEEP	64
#define	FX_AVE_TURN_TRAP_POISON_DARTS	(FX_AVE_TURN_POISON_DEC * 32)
#define	POISON_DEC_N_TRAP	1

#define	TRAP_ROOM_RATE	1
#define	TRAP_ROOM_N	50

/**/

trap_t	trap_buf[TRAP_MAX_N];
trap_t	trap_free;
trap_t	dun_trap_asgn;

long	trap_tab_max_n;

trap_tab_t	trap_tab[] = {
	{ TRAP_KIND_SLEEP, NULL, N_MSG_TRAP_SLEEP,
		80, 1, DUN_MAX_LEV, -1 },

	{ TRAP_KIND_ARW, NULL, N_MSG_TRAP_ARW,
		80, 2, DUN_MAX_LEV, -1 },

	{ TRAP_KIND_POISON_DARTS, NULL, N_MSG_TRAP_POISON_DARTS,
		80, 3, DUN_MAX_LEV, -1 },

	{ TRAP_KIND_TELEPORT_PARTY, NULL, N_MSG_TRAP_TELEPORT_PARTY,
		80, 1, DUN_MAX_LEV, -1 },

	{ TRAP_KIND_TELEPORT, NULL, N_MSG_TRAP_TELEPORT,
		80, 3, DUN_MAX_LEV, -1 },

	{ TRAP_KIND_NULL, NULL, N_MSG_NULL,
		0, DUN_MAX_LEV, DUN_MAX_LEV, 0 },
};

/**/

void	init_trap( void )
{
	long	i;

	trap_tab_max_n = 0;
	for( i = 0; i < 1024; i++ ){
		if( trap_tab[i].kind == TRAP_KIND_NULL )
			break;
		trap_tab[i].name = MSG( trap_tab[i].name_n );
	}
	trap_tab_max_n = i;

	dun_trap_asgn.prev = &dun_trap_asgn;
	dun_trap_asgn.next = &dun_trap_asgn;

	i = 0;
	trap_free.next = &(trap_buf[i]);
	trap_buf[i].prev = &trap_free;
	trap_buf[i].next = &(trap_buf[i + 1]);
	for( i++; i < TRAP_MAX_N - 1; i++ ){
		trap_buf[i].prev = &(trap_buf[i - 1]);
		trap_buf[i].next = &(trap_buf[i + 1]);
	}
	trap_buf[i].prev = &(trap_buf[i - 1]);
	trap_buf[i].next = &trap_free;
	trap_free.prev = &(trap_buf[i]);
}

/**/

void	reset_trap( void )
{
	trap_t	*p, *end;

	end = &dun_trap_asgn;
	for( p = end->next->next; p->prev != end; p = p->next )
		free_trap( p->prev );
}

/**/

trap_t	*make_trap( long x, long y, long dun_lev )
{
	long	i;
	dun_t	*dun;
	trap_t	*trap, dmy;
	long	n;

	dun = get_dun();

	if( (x != MAP_DEL_X) && (y != MAP_DEL_Y) )
		if( dun->map.obj.mjr[y][x] != FACE_MJR_FLOOR )
			return NULL;

	trap = alloc_trap( &dmy );
	if( trap == NULL )
		return NULL;

	n = 0;
	for( i = 128; i > 0; i-- ){
		n = randm( trap_tab_max_n );
		if( trap_tab[n].kind == TRAP_KIND_NULL )
			continue;
		if( !rate_randm( trap_tab[n].rate ) )
			continue;
		if( abs( dun_lev ) < trap_tab[n].min_lev )
			continue;
		if( trap_tab[n].max_lev < abs( dun_lev ) )
			continue;
		if( sgn( dun_lev ) != trap_tab[n].sgn_lev )
			continue;

		break;
	}
	do {
		if( i <= 0 )
			break;
		if( !make_trap_std( dun_lev, trap, n ) )
			break;
		if( (x != MAP_DEL_X) && (y != MAP_DEL_Y) )
			if( !set_trap( x, y, trap ) )
				break;

		return trap;
	} while( 0 );

	free_trap( trap );

	return NULL;
}

/**/

bool_t	make_trap_std( long dun_lev, trap_t *trap, long n )
{
	if( trap == NULL )
		return FALSE;

	trap->kind = trap_tab[n].kind;
	trap->x = MAP_DEL_X;
	trap->y = MAP_DEL_Y;
	trap->difficulty = abs( dun_lev );
	trap->difficulty *= TRAP_DIFFICULTY_LEV_RATE;
	trap->difficulty /= _100_PERCENT;
	trap->difficulty += 1;
	trap->tab = &(trap_tab[n]);

	return TRUE;
}

/**/

bool_t	set_trap( long x, long y, trap_t *trap )
{
	dun_t	*dun;

	if( trap == NULL )
		return FALSE;

	if( (x == MAP_DEL_X) || (y == MAP_DEL_Y) )
		return FALSE;

	dun = get_dun();

	if( dun->map.obj.mjr[y][x] != FACE_MJR_FLOOR )
		return FALSE;

	trap->x = x;
	trap->y = y;

	dun->map.obj.mjr[y][x] = FACE_MJR_TRAP;
	dun->map.obj.mnr[y][x] = FACE_MNR_NULL;
	dun->map.obj.flg[y][x] |= (FLG_OBJ_PASS | FLG_OBJ_LOOK_FLOOR);

	ins_ls_trap( &dun_trap_asgn, trap );

	return TRUE;
}

/**/

void	make_trap_room( long area_x, long area_y, long lev )
{
	dun_t	*dun = get_dun();
	long	n;
	long	i;

	if( !rate_randm( TRAP_ROOM_RATE ) )
		return;

	n = 0;
	for( i = 0; i < 10240; i++ ){
		long	mx, my;
		trap_t	*trap;

		mx = area_x * AREA_MAX_X + randm( AREA_MAX_X );
		my = area_y * AREA_MAX_Y + randm( AREA_MAX_Y );

		if( dun->map.obj.mjr[my][mx] != FACE_MJR_FLOOR )
			continue;

		trap = make_trap( mx, my, lev );
		if( trap != NULL )
			n++;
		if( n >= TRAP_ROOM_N )
			break;
	}
}

/**/

void	chk_trap_chest( item_t *item, mbr_t *mbr, rate_t rate )
{
	if( mbr == NULL )
		return;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;
	if( item == NULL )
		return;
	if( item->kind != ITEM_KIND_CHEST )
		return;

	if( !rate_randm( rate ) )
		return;

	caught_trap( item->dat.chest.trap, mbr );

	free_trap_chest( item );
}

/**/

void	chk_trap( mbr_t *mbr )
{
	trap_t	*trap;
	dun_t	*dun;

	if( mbr == NULL )
		return;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;
	if( chk_flg( mbr->stat, FLG_STAT_FLY ) )
		return;

	dun = get_dun();

	if( dun->map.obj.mjr[mbr->y][mbr->x] != FACE_MJR_TRAP )
		return;

	trap = get_trap( mbr->x, mbr->y );
	if( trap == NULL )
		return;

	dun->map.obj.flg[mbr->y][mbr->x] &= ~FLG_OBJ_LOOK_FLOOR;
	dun->map.obj.flg[mbr->y][mbr->x] |= FLG_OBJ_FIND;
	draw_trap( trap );

	if( chr_roll( mbr, ABL_KIND_THI, ABL_KIND_AGI, trap->difficulty ) )
		print_msg( FLG_NULL, MSG_NOT_TRAPPED, mbr->name );
	else
		caught_trap( trap, mbr );
}

/**/

void	caught_trap( trap_t *trap, mbr_t *mbr )
{
	fx_t	*fx;

	if( mbr == NULL )
		return;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;
	if( trap == NULL )
		return;

	switch( trap->kind ){
	case TRAP_KIND_NULL:
	case TRAP_KIND_MAX_N:
		return;
	case TRAP_KIND_SLEEP:
		print_msg( FLG_NULL, MSG_FX_SLEEP, mbr->name );
		set_fx( mbr, FX_KIND_SLEEP,
				FX_AVE_TURN_TRAP_SLEEP );
		break;
	case TRAP_KIND_ARW:
		break;
	case TRAP_KIND_POISON_DARTS:
		print_msg( FLG_NULL, MSG_FX_POISON, mbr->name );
		fx = set_fx( mbr, FX_KIND_POISON,
				FX_AVE_TURN_TRAP_POISON_DARTS );
		if( fx == NULL )
			return;
		if( fx->n < POISON_DEC_N_TRAP )
			fx->n = POISON_DEC_N_TRAP;

		break;
	case TRAP_KIND_TELEPORT_PARTY:
		teleport_party();
		break;
	case TRAP_KIND_TELEPORT:
		teleport_mbr( mbr );
		break;
	}
}

/**/

void	disarm_trap( trap_t *p )
{
	dun_t	*dun;

	if( p == NULL )
		return;

	dun = get_dun();

	dun->map.obj.mjr[p->y][p->x] = FACE_MJR_FLOOR;
	dun->map.obj.mnr[p->y][p->x] = FACE_MNR_FLOOR;
	draw_map( p->x, p->y, 1, 1 );

	free_trap( p );
}

/**/

void	ins_ls_trap( trap_t *ls, trap_t *p )
{
	if( ls == NULL )
		return;
	if( p == NULL )
		return;

	if( p->next != NULL )
		p->next->prev = p->prev;
	if( p->prev != NULL )
		p->prev->next = p->next;

	p->prev = ls->prev;
	p->next = ls;

	if( ls->prev != NULL )
		ls->prev->next = p;
	ls->prev = p;
}

/**/

trap_t	*alloc_trap( trap_t *dmy )
{
	trap_t	*p;
	/* $B0l;~E*$J%"%$%F%`%j%9%H$K$V$i2<$2$k(B */

	dmy->prev = dmy;
	dmy->next = dmy;

	p = get_trap_free_next();
	if( p == NULL )
		return NULL;

	ins_ls_trap( dmy, p );

	return p;
}

/**/

void	free_trap_chest( item_t *chest )
{
	if( chest == NULL )
		return;
	if( chest->kind != ITEM_KIND_CHEST )
		return;

	free_trap( chest->dat.chest.trap );
	chest->dat.chest.trap = NULL;
}

/**/

void	free_trap( trap_t *p )
{
	trap_t	*ls;

	ls = get_trap_free_next();
	if( ls == NULL )
		return;

	ins_ls_trap( ls, p );
}

/**/

trap_t	*get_trap_free_next( void )
{
	if( trap_free.next == &trap_free )
		return NULL;

	return trap_free.next;
}

/**/

trap_t	*get_trap( long x, long y )
{
	trap_t	*p;

	for( p = dun_trap_asgn.next; p != &dun_trap_asgn; p = p->next )
		if( (p->x == x) && (p->y == y) )
			return p;

	return NULL;
}

/**/

trap_t	*get_dun_trap_asgn( void )
{
	return &dun_trap_asgn;
}

/**/
