/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
/*#include	"dun.h"*/
#include	"town.h"
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
#include	"menu.h"
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
#include	"town_prot.h"
#include	"item_prot.h"
#include	"spell_prot.h"
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
#include	"fight_prot.h"
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
#include	"menu_prot.h"
/*#include	"tmenu_prot.h"*/
#include	"amenu_prot.h"
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

#define	DFLT_EXP	200
#define	DFLT_GOLD	1200

#define	MBR_NEAR_R	4

#define	FRIEND_MAX_TURN	(TURN_A_DAY * 1)

mbr_t	*ls_mbr[LS_MBR_MAX_N + 1];
mbr_t	ls_mbr_buf[LS_MBR_MAX_N + 1];
party_t	party;

long	abl_init[MAIN_RACE_MAX_N][ABL_KIND_MAX_N] = {

	/* HP  MP  DEX STR */
	/* QUI WIS INT CHA */
	/* FIG MON HUN THI */
	/* MAG SOR ENC SUM */
	/* PRI SHA BAR NIN */

	/* MAIN_RACE_HUMAN, */
	{  2,  2,  2,  2,
	   2,  2,  2,  2,
	   0,  0,  0,  0,
	   0,  0,  0,  0,
	   0,  0,  0,  0, },

	/* MAIN_RACE_HALF_ELF, */
	{  2,  2,  2,  1,
	   3,  2,  2,  2,
	   0,  0,  1,  0,
	   0,  0,  0,  0,
	   0,  0,  0,  0, },

	/* MAIN_RACE_ELF, */
	{  1,  2,  2,  1,
	   3,  2,  2,  3,
	   0,  0,  1,  0,
	   0,  0,  0,  0,
	   0,  1,  0,  0, },

	/* MAIN_RACE_DWARF, */
	{  3,  1,  3,  3,
	   1,  2,  2,  1,
	   1,  0,  0,  0,
	   0,  0,  0,  0,
	   0,  0,  0,  0, },

	/* MAIN_RACE_VIVID, */
	{  1,  2,  3,  1,
	   3,  2,  2,  2,
	   0,  0,  0,  1,
	   0,  0,  0,  0,
	   0,  0,  0,  0, },
};

rate_t	resi_init[MAIN_RACE_MAX_N][RESI_KIND_MAX_N] = {
	/* KNOC,SLAS,STIN,HEAT,COLD,WIND,ACID,ELEC,POIS, */
/* MAIN_RACE_HUMAN */
	{   100, 100, 100, 100, 100, 100, 100, 100, 100 },
/* MAIN_RACE_HALF_ELF */
	{    90,  90,  90, 100, 100, 100, 100, 100, 100 },
/* MAIN_RACE_ELF */
	{    80,  80,  80, 100, 100, 150, 100, 100, 100 },
/* MAIN_RACE_DWARF */
	{   150, 150, 150, 100, 100, 100, 100, 100, 200 },
/* MAIN_RACE_VIVID */
	{    70,  70,  70, 100, 100, 200, 100, 100, 100 },
};

stomach_t	ave_stomach[MAIN_RACE_MAX_N] = {
#if	0
typedef struct {
	rate_t	rate;
	rate_t	full_rate;
	long	digest_p_day;
	rate_t	hungry_rate, starvation_rate;
} stomach_t;
#endif
	{ 100, 100, 20, 70, 30 },	/* MAIN_RACE_HUMAN, */
	{ 100,  80, 15, 70, 30 },	/* MAIN_RACE_HALF_ELF, */
	{ 100,  50, 10, 70, 30 },	/* MAIN_RACE_ELF, */
	{ 100, 200, 25, 70, 30 },	/* MAIN_RACE_DWARF, */
	{ 100, 180, 25, 70, 30 },	/* MAIN_RACE_VIVID, */
};

/* auto mark */

char	msg_ttl_auto_mark[AUTO_MARK_MAX_N][MSG_TTL_AUTO_MARK_MAX_LEN + 1];

auto_mark_t	dflt_auto_mark_fight = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

auto_mark_t	dflt_auto_mark_throw = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_MEDIUM,
	AUTO_MARK_ACT_THROW,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

auto_mark_t	dflt_auto_mark_fight_far = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_FAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

auto_mark_t	dflt_auto_mark_fight_all = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

auto_mark_t	dflt_auto_mark_item_all = {
	AUTO_MARK_TRGT_ITEM,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_PICK_UP,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

auto_mark_t	dflt_auto_mark_item_own = {
	AUTO_MARK_TRGT_ITEM,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_PICK_UP,
	AUTO_MARK_COND_OWN,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

auto_mark_t	dflt_auto_mark_unchange = {
	AUTO_MARK_TRGT_UNCHANGE,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY,
};

auto_mark_t	dflt_auto_mark_clear = {
	AUTO_MARK_TRGT_CLEAR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY,
};

/**/

/* class */

#include	"class_tab.h"

/**/

void	init_party( void )
{
	long	i, j, max_n;
	race_t	race;

	for( i = 0; i < LS_MBR_MAX_N + 1; i++ )
		ls_mbr[i] = &(ls_mbr_buf[i]);

	for( i = 0; i < MBR_MAX_N; i++ )
		party.mbr[i] = ls_mbr[LS_MBR_MAX_N];

	for( i = 0; i < LS_MBR_MAX_N + 1; i++ ){
		ls_mbr[i]->mbr_n = MBR_N_NOT_JOIN;
		ls_mbr[i]->ls_mbr_n = i;
		ls_mbr[i]->x = -1;
		ls_mbr[i]->y = -1;
		ls_mbr[i]->pre_x = -1;
		ls_mbr[i]->pre_y = -1;
		ls_mbr[i]->stat = FLG_STAT_NOT_EXIST;
		ls_mbr[i]->fx.next = &(ls_mbr[i]->fx);
		ls_mbr[i]->fx.prev = &(ls_mbr[i]->fx);
	}

	max_n = sizeof( class_tab ) / sizeof( class_tab[0] );
	for( j = 0; j < max_n; j++ ){
		class_tab[j].n_name = N_MSG_NULL;
		class_tab[j].name[0] = '\0';
	}
	for( j = 0; j < CLASS_MAX_N; j++ ){
		class_tab[j] = class_dflt_tab[j];
		if( class_tab[j].n_name == N_MSG_NULL )
			break;

		strncpy( class_tab[j].name,
				MSG( class_tab[j].n_name ),
				CLASS_NAME_MAX_LEN );
	}

	party.square.x = 1;
	party.square.y = 1;
	party.square.dir_x = +1;
	party.square.dir_y = +-0;
	party.square.chr_pos_n[0][0] = 0;
	party.square.chr_pos_n[0][1] = MBR_NO_POS;
	party.square.chr_pos_n[0][2] = 1;
	party.square.chr_pos_n[1][0] = 2;
	party.square.chr_pos_n[1][1] = MBR_NO_POS;
	party.square.chr_pos_n[1][2] = 3;
	party.square.chr_pos_n[2][0] = 4;
	party.square.chr_pos_n[2][1] = MBR_NO_POS;
	party.square.chr_pos_n[2][2] = 5;
	set_mbr_dir();

	party.flg = FLG_NULL;
	party.flg |= FLG_PARTY_SRCH_AUTO_OFF;

	/**/

	race.main = MAIN_RACE_HUMAN;
	race.sub = SUB_RACE_NULL;
	strncpy( race.name, MSG_MAIN_RACE_HUMAN, RACE_NAME_MAX_LEN );
	new_mbr( ls_mbr[0], "<///BLADE//}===o", 'B', race,
			MALE, CLASS_N_FIGHTER, 0 );

	race.main = MAIN_RACE_DWARF;
	race.sub = SUB_RACE_NULL;
	strncpy( race.name, MSG_MAIN_RACE_DWARF, RACE_NAME_MAX_LEN );
	new_mbr( ls_mbr[1], ")(==DRANK======>", 'D', race,
			MALE, CLASS_N_FIGHTER, 1 );

	race.main = MAIN_RACE_HALF_ELF;
	race.sub = SUB_RACE_NULL;
	strncpy( race.name, MSG_MAIN_RACE_HALF_ELF, RACE_NAME_MAX_LEN );
	new_mbr( ls_mbr[2], "<---ELSIE----<<<", 'E', race,
			MALE, CLASS_N_HUNTER, 2 );

	race.main = MAIN_RACE_HUMAN;
	race.sub = SUB_RACE_NULL;
	strncpy( race.name, MSG_MAIN_RACE_HUMAN, RACE_NAME_MAX_LEN );
	new_mbr( ls_mbr[3], "+-==CECILE=====X", 'C', race,
			FEMALE, CLASS_N_PRIEST, 3 );

	race.main = MAIN_RACE_VIVID;
	race.sub = SUB_RACE_NULL;
	strncpy( race.name, MSG_MAIN_RACE_VIVID, RACE_NAME_MAX_LEN );
	new_mbr( ls_mbr[4], "m-o HALLE  <<<)=", 'F', race,
			MALE, CLASS_N_THIEF, 4 );

	race.main = MAIN_RACE_ELF;
	race.sub = SUB_RACE_NULL;
	strncpy( race.name, MSG_MAIN_RACE_ELF, RACE_NAME_MAX_LEN );
	new_mbr( ls_mbr[5], "O>==BEAUT====---", 'U', race,
			FEMALE, CLASS_N_WIZARD, 5 );

	race.main = MAIN_RACE_HUMAN;
	race.sub = SUB_RACE_MONKEY;
	strncpy( race.name, MSG_RACE_NAME_VEGE, RACE_NAME_MAX_LEN );
	new_mbr( ls_mbr[6], "====GOKOU=======", 'G', race,
			MALE, CLASS_N_MONK, 6 );

	/**/

	init_party_auto_mark();
}

/**/

void	init_party_debug( void )
{
	long	i;
	item_t	*item;
	item_kind_dat_t	sub_kind;

	for( i = 0; i < 7; i++ ){
		ls_mbr[i]->max_dun_lev_floor = 0;
		ls_mbr[i]->max_dun_lev_base = 128;
	}

	/* item */

	for( i = 0; i < MBR_MAX_N; i++ ){
		sub_kind.armor = ARMOR_KIND_SOFT_LEATHER_ARMOR;
		init_mbr_item( ls_mbr[i], ITEM_KIND_ARMOR, &sub_kind,
				TRUE, FALSE, TRUE );

		sub_kind.light = LIGHT_KIND_LANTERN;
		init_mbr_item( ls_mbr[i], ITEM_KIND_LIGHT, &sub_kind,
				TRUE, FALSE, TRUE );

		sub_kind.potion = POTION_KIND_CURE_HP_MAX;
		init_mbr_item( ls_mbr[i], ITEM_KIND_POTION, &sub_kind,
				TRUE, FALSE, FALSE );

		sub_kind.potion = POTION_KIND_OIL;
		init_mbr_item( ls_mbr[i], ITEM_KIND_POTION, &sub_kind,
				FALSE, FALSE, FALSE );
	}

	/* weapon */

	i = 0;
	sub_kind.wpn = WPN_KIND_GREAT_SWORD;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 1;
	sub_kind.wpn = WPN_KIND_GREAT_AXE;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 2;
	sub_kind.wpn = WPN_KIND_SHORT_SWORD;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, TRUE, TRUE );

	i = 3;
	sub_kind.wpn = WPN_KIND_LIGHT_MACE;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 4;
	sub_kind.wpn = WPN_KIND_KNIFE;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 5;
	sub_kind.wpn = WPN_KIND_WOODEN_CLUB;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 6;
	sub_kind.wpn = WPN_KIND_QUARTER_STAFF;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 0;
	sub_kind.wpn = WPN_KIND_JAVELIN;
	item = init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, FALSE );
	equip_item( ls_mbr[i], item, EQUIP_KIND_ARW );

	i = 1;
	sub_kind.wpn = WPN_KIND_BOOMERANG;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 2;
	sub_kind.wpn = WPN_KIND_LIGHT_CROSS_BOW;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 2;
	sub_kind.wpn = WPN_KIND_BOLT;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 3;
	sub_kind.wpn = WPN_KIND_SLING;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 3;
	sub_kind.wpn = WPN_KIND_STONE;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 4;
	sub_kind.wpn = WPN_KIND_DAGGER;
	init_mbr_item( ls_mbr[i], ITEM_KIND_WPN, &sub_kind,
			TRUE, FALSE, TRUE );

	/* armor */

	i = 0;
	sub_kind.armor = ARMOR_KIND_SALLET;
	init_mbr_item( ls_mbr[i], ITEM_KIND_ARMOR, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 1;
	sub_kind.armor = ARMOR_KIND_SALLET;
	init_mbr_item( ls_mbr[i], ITEM_KIND_ARMOR, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 0;
	sub_kind.armor = ARMOR_KIND_CHAIN_MAIL;
	init_mbr_item( ls_mbr[i], ITEM_KIND_ARMOR, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 1;
	sub_kind.armor = ARMOR_KIND_CHAIN_MAIL;
	init_mbr_item( ls_mbr[i], ITEM_KIND_ARMOR, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 2;
	sub_kind.armor = ARMOR_KIND_ROUND_SHIELD;
	init_mbr_item( ls_mbr[i], ITEM_KIND_ARMOR, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 3;
	sub_kind.armor = ARMOR_KIND_ROUND_SHIELD;
	init_mbr_item( ls_mbr[i], ITEM_KIND_ARMOR, &sub_kind,
			TRUE, FALSE, TRUE );

	i = 5;
	sub_kind.armor = ARMOR_KIND_ROBE;
	init_mbr_item( ls_mbr[i], ITEM_KIND_ARMOR, &sub_kind,
			TRUE, FALSE, TRUE );

	/* scroll */

	i = 0;
	sub_kind.scroll = SCROLL_KIND_RECALL;
	init_mbr_item( ls_mbr[i], ITEM_KIND_SCROLL, &sub_kind,
			FALSE, FALSE, FALSE );

	i = 1;
	sub_kind.scroll = SCROLL_KIND_SLEEP;
	init_mbr_item( ls_mbr[i], ITEM_KIND_SCROLL, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 2;
	sub_kind.scroll = SCROLL_KIND_IDENTIFY_ITEM;
	init_mbr_item( ls_mbr[i], ITEM_KIND_SCROLL, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 3;
	sub_kind.scroll = SCROLL_KIND_TELEPORT;
	init_mbr_item( ls_mbr[i], ITEM_KIND_SCROLL, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 4;
	sub_kind.scroll = SCROLL_KIND_POW_UP_WPN_HIT;
	init_mbr_item( ls_mbr[i], ITEM_KIND_SCROLL, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 4;
	sub_kind.scroll = SCROLL_KIND_POW_UP_WPN_DAM;
	init_mbr_item( ls_mbr[i], ITEM_KIND_SCROLL, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 5;
	sub_kind.scroll = SCROLL_KIND_REMOVE_CURSE;
	init_mbr_item( ls_mbr[i], ITEM_KIND_SCROLL, &sub_kind,
			TRUE, FALSE, FALSE );

	/* potion */

	i = 0;
	sub_kind.potion = POTION_KIND_RESI_PHYS;
	init_mbr_item( ls_mbr[i], ITEM_KIND_POTION, &sub_kind,
			FALSE, FALSE, FALSE );

	i = 0;
	sub_kind.potion = POTION_KIND_STRENGTH;
	init_mbr_item( ls_mbr[i], ITEM_KIND_POTION, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 0;
	sub_kind.potion = POTION_KIND_DULLNESS;
	init_mbr_item( ls_mbr[i], ITEM_KIND_POTION, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 0;
	sub_kind.potion = POTION_KIND_POISON;
	init_mbr_item( ls_mbr[i], ITEM_KIND_POTION, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 0;
	sub_kind.potion = POTION_KIND_FLY;
	init_mbr_item( ls_mbr[i], ITEM_KIND_POTION, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 1;
	sub_kind.potion = POTION_KIND_RUM;
	item = init_mbr_item( ls_mbr[i], ITEM_KIND_POTION, &sub_kind,
			TRUE, FALSE, FALSE );
	inc_item( item, +16 );

	/* stick */

	i = 5;
	sub_kind.stick.kind = STICK_KIND_WAND;
	sub_kind.stick.spell_kind = SPELL_KIND_SLEEP;
	init_mbr_item( ls_mbr[i], ITEM_KIND_STICK, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 5;
	sub_kind.stick.kind = STICK_KIND_STAFF;
	sub_kind.stick.spell_kind = SPELL_KIND_SLEEP;
	init_mbr_item( ls_mbr[i], ITEM_KIND_STICK, &sub_kind,
			TRUE, FALSE, FALSE );

	/* misc */

	i = 4;
	init_mbr_item( ls_mbr[i], ITEM_KIND_SPIKE, NULL,
			TRUE, FALSE, FALSE );

	i = 0;
	sub_kind.tobacco.kind = TOBACCO_KIND_CIGAR;
	sub_kind.tobacco.brand = TOBACCO_BRAND_LUMBERJACK;
	init_mbr_item( ls_mbr[i], ITEM_KIND_TOBACCO, &sub_kind,
			TRUE, FALSE, FALSE );

	i = 0;
	init_mbr_item( ls_mbr[i], ITEM_KIND_CHEST, NULL,
			TRUE, FALSE, FALSE );

	/**/

#if	0
/*@@@*/
	i = 0;
	ls_mbr[i]->nicotine.poisoning_rate = _100_PERCENT;
#endif

	/**/

	for( i = 0; i < MBR_MAX_N; i++ )
		join_mbr( i, i );
}

/**/

item_t	*init_mbr_item(
	mbr_t *mbr, item_kind_t kind, item_kind_dat_t *sub_kind,
	bool_t flg_ident, bool_t curse, bool_t flg_eq
)
{
	item_t	*item, dmy;
	long	tab_n;
	long	lev;

	if( mbr == NULL )
		return NULL;

	item = alloc_item( &dmy );
	if( item == NULL )
		return NULL;

	lev = -10;

	switch( kind ){
	case ITEM_KIND_NULL:
	case ITEM_KIND_MAX_N:
		break;
	case ITEM_KIND_WPN:
	case ITEM_KIND_ARMOR:
	case ITEM_KIND_POTION:
	case ITEM_KIND_SCROLL:
	case ITEM_KIND_STICK:
	case ITEM_KIND_ACCE:
	case ITEM_KIND_LIGHT:
	case ITEM_KIND_FOOD:
	case ITEM_KIND_TOBACCO:
	case ITEM_KIND_PIPE:
	case ITEM_KIND_COIN:
		if( sub_kind == NULL )
			return NULL;
		break;
	case ITEM_KIND_SPIKE:
	case ITEM_KIND_CHEST:
	case ITEM_KIND_JUNK:
		break;
	}

	tab_n = 0;
	switch( kind ){
	case ITEM_KIND_NULL:
	case ITEM_KIND_MAX_N:
		return NULL;
	case ITEM_KIND_WPN:
		tab_n = get_wpn_tab_n( get_wpn_tab(
				sub_kind->wpn ) );
		break;
	case ITEM_KIND_ARMOR:
		tab_n = get_armor_tab_n( get_armor_tab(
				sub_kind->armor ) );
		break;
	case ITEM_KIND_POTION:
		tab_n = get_potion_tab_n( get_potion_tab(
				sub_kind->potion ) );
		break;
	case ITEM_KIND_SCROLL:
		tab_n = get_scroll_tab_n( get_scroll_tab(
				sub_kind->scroll ) );
		break;
	case ITEM_KIND_STICK:
		tab_n = get_stick_tab_n( get_stick_tab(
				sub_kind->stick.kind,
				sub_kind->stick.spell_kind ) );
		break;
	case ITEM_KIND_ACCE:
		tab_n = get_acce_tab_n( get_acce_tab(
				sub_kind->ring,
				sub_kind->amulet,
				sub_kind->necklace ) );
		break;
	case ITEM_KIND_LIGHT:
		tab_n = get_light_tab_n( get_light_tab(
				sub_kind->light ) );
		break;
	case ITEM_KIND_SPIKE:
		break;
	case ITEM_KIND_FOOD:
		tab_n = get_food_tab_n( get_food_tab(
				sub_kind->food ) );
		break;
	case ITEM_KIND_CHEST:
		break;
	case ITEM_KIND_TOBACCO:
		tab_n = get_tobacco_tab_n( get_tobacco_tab(
				sub_kind->tobacco.kind,
				sub_kind->tobacco.brand ) );
		break;
	case ITEM_KIND_PIPE:
		tab_n = get_pipe_tab_n( get_pipe_tab(
				sub_kind->pipe ) );
		break;
	case ITEM_KIND_COIN:
		tab_n = get_coin_tab_n( get_coin_tab(
				sub_kind->coin ) );
		break;
	case ITEM_KIND_JUNK:
		break;
	}
	if( tab_n < 0 )
		return NULL;

	switch( kind ){
	case ITEM_KIND_NULL:
	case ITEM_KIND_MAX_N:
		return NULL;
	case ITEM_KIND_WPN:
		make_item_wpn( lev, item, tab_n, curse );
		break;
	case ITEM_KIND_ARMOR:
		make_item_armor( lev, item, tab_n, curse );
		break;
	case ITEM_KIND_POTION:
		make_item_potion( lev, item, tab_n );
		break;
	case ITEM_KIND_SCROLL:
		make_item_scroll( lev, item, tab_n );
		break;
	case ITEM_KIND_STICK:
		make_item_stick( lev, item, tab_n );
		break;
	case ITEM_KIND_ACCE:
		make_item_acce( lev, item, tab_n );
		break;
	case ITEM_KIND_LIGHT:
		make_item_light( lev, item, tab_n );
		break;
	case ITEM_KIND_SPIKE:
		make_item_spike( lev, item );
		break;
	case ITEM_KIND_FOOD:
		make_item_food( lev, item, tab_n );
		break;
	case ITEM_KIND_CHEST:
		make_item_chest( lev, item, 4 );
		break;
	case ITEM_KIND_TOBACCO:
		make_item_tobacco( lev, item, tab_n );
		break;
	case ITEM_KIND_PIPE:
		make_item_pipe( lev, item, tab_n );
		break;
	case ITEM_KIND_COIN:
		make_item_coin( lev, item, tab_n );
		break;
	case ITEM_KIND_JUNK:
		item->kind = ITEM_KIND_JUNK;
		break;
	}

	item->flg |= FLG_ITEM_DETECTED;
	if( flg_ident )
		item->flg |= FLG_ITEM_IDENTIFIED;
	set_item_name( item );

	give_mbr_item( mbr, item );
	if( flg_eq )
		equip_item_sel( mbr, item );

	return item;
}

/**/

void	init_party_auto_mark( void )
{	long	i, j;

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		j = 0;
		switch( i ){
		default:
		case 0:
		case 1:
		case 3:
			ls_mbr[i]->auto_mark[j] = dflt_auto_mark_fight;
			break;
		case 2:
			ls_mbr[i]->auto_mark[j] = dflt_auto_mark_throw;
			break;
		case 4:
		case 5:
			ls_mbr[i]->auto_mark[j] = dflt_auto_mark_fight_far;
			break;
		}
		strncpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_FIGHT,
				MSG_TTL_AUTO_MARK_MAX_LEN );
		j++;
		if( j < AUTO_MARK_MAX_N ){
			ls_mbr[i]->auto_mark[j] = dflt_auto_mark_fight_all;
			strncpy( msg_ttl_auto_mark[j],
					MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL,
					MSG_TTL_AUTO_MARK_MAX_LEN );
		}
		j++;
		if( j < AUTO_MARK_MAX_N ){
			ls_mbr[i]->auto_mark[j] = dflt_auto_mark_item_all;
			strncpy( msg_ttl_auto_mark[j],
					MSG_NAME_DFLT_AUTO_MARK_ITEM_ALL,
					MSG_TTL_AUTO_MARK_MAX_LEN );
		}
		j++;
		if( j < AUTO_MARK_MAX_N ){
			ls_mbr[i]->auto_mark[j] = dflt_auto_mark_item_own;
			strncpy( msg_ttl_auto_mark[j],
					MSG_NAME_DFLT_AUTO_MARK_ITEM_OWN,
					MSG_TTL_AUTO_MARK_MAX_LEN );
		}
		j++;
		for( ; j < AUTO_MARK_MAX_N; j++ ){
			ls_mbr[i]->auto_mark[j] = dflt_auto_mark_clear;
			strncpy( msg_ttl_auto_mark[j],
					MSG_NAME_DFLT_AUTO_MARK_CLEAR,
					MSG_TTL_AUTO_MARK_MAX_LEN );
		}
		j = AUTO_MARK_MAX_N - 1;
		ls_mbr[i]->auto_mark[j] = dflt_auto_mark_clear;
		strncpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_CLEAR,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
}

/**/

void	new_mbr_reset( mbr_t *mbr )
{
	new_mbr( mbr, mbr->name, mbr->face_mnr, mbr->race, mbr->sex,
			mbr->class_n, mbr->ls_mbr_n );
}

/**/

void	new_mbr(
	mbr_t *mbr, char *name, char face,
	race_t race, sex_t sex, long class_n, long ls_mbr_n
)
{
	long	lev;
	long	i;

	mbr->prev = NULL;
	mbr->next = NULL;
	mbr->kind = CHR_KIND_MBR;
	strncpy( mbr->name, name, MBR_NAME_MAX_LEN );
	mbr->mbr_n = MBR_N_NOT_JOIN;
	mbr->ls_mbr_n = ls_mbr_n;
	mbr->face_mjr = FACE_MJR_MBR;
	mbr->face_mnr = face;
	mbr->race = race;
	mbr->sex = sex;
	mbr->x = -1;
	mbr->y = -1;
	mbr->pre_x = -1;
	mbr->pre_y = -1;
	mbr->move_rate = _100_PERCENT;
	mbr->gold = DFLT_GOLD;
	mbr->max_dun_lev_floor = 0;
	mbr->max_dun_lev_base = 0;

	mbr->trgt.dist = DIST_NEAR;
	mbr->trgt.dflt_dist_mnstr = DIST_NEAR;
	mbr->act.dflt_kind_mnstr
			= ACT_KIND_MNSTR_FIGHT;
	strncpy( mbr->act.dflt_msg_mnstr,
			MSG_MENU_MARK_FIGHT, ACT_MSG_MAX_LEN );
	clr_chr_trgt_act( mbr, TRUE );

	for( i = 0; i < AUTO_MARK_MAX_N; i++ ){
		mbr->auto_mark[i] = dflt_auto_mark_clear;
		strncpy( msg_ttl_auto_mark[i],
				MSG_NAME_DFLT_AUTO_MARK_CLEAR,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	mbr->flg_chr = FLG_NULL;
	mbr->flg_chr |= FLG_CHR_AUTO_DOOR;
	mbr->flg_chr |= FLG_CHR_AVOID_TRAP;
	mbr->flg_map = FLG_NULL;

	mbr->stat = FLG_NULL;

	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		mbr->abl.lev[i].max = abl_init[mbr->race.main][i];

		lev = mbr->abl.lev[i].max;

		mbr->abl.exp[i].max = calc_lev_to_exp( lev, i );

		mbr->abl.exp[i].n = mbr->abl.exp[i].max;
		mbr->abl.lev[i].n = mbr->abl.lev[i].max;
	}

	lev = mbr->abl.lev[ABL_KIND_HP].max;
	mbr->abl.hp.max = calc_lev_to_val( lev, ABL_KIND_HP );
	mbr->abl.hp.n = mbr->abl.hp.max;

	lev = mbr->abl.lev[ABL_KIND_MP].max;
	mbr->abl.mp.max = calc_lev_to_val( lev, ABL_KIND_MP );
	mbr->abl.mp.n = mbr->abl.mp.max;

	mbr->class_n = class_n;

	for( i = 0; i < RESI_KIND_MAX_N; i++ ){
		mbr->resi[i].n = resi_init[mbr->race.main][i];
		mbr->resi[i].max = resi_init[mbr->race.main][i];
	}
	mbr->ac = 0;

	mbr->fx.next = &(mbr->fx);
	mbr->fx.prev = &(mbr->fx);

	mbr->fx_data.infra_vision = 0;

	mbr->fx_data.stomach.rate = _100_PERCENT;
	mbr->fx_data.stomach.full_rate
			= ave_stomach[race.main].full_rate;
	mbr->fx_data.stomach.digest_p_day
			= ave_stomach[race.main].digest_p_day;
	mbr->fx_data.stomach.hungry_rate
			= ave_stomach[race.main].hungry_rate;
	mbr->fx_data.stomach.starvation_rate
			= ave_stomach[race.main].starvation_rate;

	mbr->fx_data.drunk_rate = 0;

	mbr->fx_data.nicotine.rate = 0;
	mbr->fx_data.nicotine.poisoning_rate = 0;

	mbr->fx_data.friend_turn = FRIEND_MAX_TURN;

	mbr->mnstr_kind = MNSTR_KIND_NULL;
	mbr->mnstr_tab = NULL;

	mbr->work.caught = 0;

	/**/

	exp_chr( mbr, DFLT_EXP, FALSE );
}

/**/

void	set_mbr_dir( void )
{
	long	i, j;
	
	if( party.square.dir_x < 0 ){
		party.square.chr_dir[0][0] = party.square.chr_pos_n[0][2];
		party.square.chr_dir[0][1] = party.square.chr_pos_n[1][2];
		party.square.chr_dir[0][2] = party.square.chr_pos_n[2][2];
		party.square.chr_dir[1][0] = party.square.chr_pos_n[0][1];
		party.square.chr_dir[1][1] = party.square.chr_pos_n[1][1];
		party.square.chr_dir[1][2] = party.square.chr_pos_n[2][1];
		party.square.chr_dir[2][0] = party.square.chr_pos_n[0][0];
		party.square.chr_dir[2][1] = party.square.chr_pos_n[1][0];
		party.square.chr_dir[2][2] = party.square.chr_pos_n[2][0];
	} else if( party.square.dir_x > 0 ){
		party.square.chr_dir[0][0] = party.square.chr_pos_n[2][0];
		party.square.chr_dir[0][1] = party.square.chr_pos_n[1][0];
		party.square.chr_dir[0][2] = party.square.chr_pos_n[0][0];
		party.square.chr_dir[1][0] = party.square.chr_pos_n[2][1];
		party.square.chr_dir[1][1] = party.square.chr_pos_n[1][1];
		party.square.chr_dir[1][2] = party.square.chr_pos_n[0][1];
		party.square.chr_dir[2][0] = party.square.chr_pos_n[2][2];
		party.square.chr_dir[2][1] = party.square.chr_pos_n[1][2];
		party.square.chr_dir[2][2] = party.square.chr_pos_n[0][2];
	} else if( party.square.dir_y < 0 ){
		party.square.chr_dir[0][0] = party.square.chr_pos_n[0][0];
		party.square.chr_dir[0][1] = party.square.chr_pos_n[0][1];
		party.square.chr_dir[0][2] = party.square.chr_pos_n[0][2];
		party.square.chr_dir[1][0] = party.square.chr_pos_n[1][0];
		party.square.chr_dir[1][1] = party.square.chr_pos_n[1][1];
		party.square.chr_dir[1][2] = party.square.chr_pos_n[1][2];
		party.square.chr_dir[2][0] = party.square.chr_pos_n[2][0];
		party.square.chr_dir[2][1] = party.square.chr_pos_n[2][1];
		party.square.chr_dir[2][2] = party.square.chr_pos_n[2][2];
	} else if( party.square.dir_y > 0 ){
		party.square.chr_dir[0][0] = party.square.chr_pos_n[2][2];
		party.square.chr_dir[0][1] = party.square.chr_pos_n[2][1];
		party.square.chr_dir[0][2] = party.square.chr_pos_n[2][0];
		party.square.chr_dir[1][0] = party.square.chr_pos_n[1][2];
		party.square.chr_dir[1][1] = party.square.chr_pos_n[1][1];
		party.square.chr_dir[1][2] = party.square.chr_pos_n[1][0];
		party.square.chr_dir[2][0] = party.square.chr_pos_n[0][2];
		party.square.chr_dir[2][1] = party.square.chr_pos_n[0][1];
		party.square.chr_dir[2][2] = party.square.chr_pos_n[0][0];
	}
	for( i = 0; i < SQUARE_HEIGHT; i++ ){
		for( j = 0; j < SQUARE_WIDTH; j++ ){
			long	n;
			
			n = party.square.chr_dir[i][j];
			if( n != MBR_NO_POS ){
				party.square.chr_pos[n].x = j - 1;
				party.square.chr_pos[n].y = i - 1;
			}
		}
	}
}

/**/

void	appear_party( bool_t flg_clr_map )
{
	long	i, n;
	long	nx, ny;

	for( n = 0; n < MBR_MAX_N; n++ )
		clr_chr_trgt_act( party.mbr[n], FALSE );

	release_all_mbr();

	if( flg_clr_map )
		clr_map_all_mbr();

	for( i = 0; i < 1024; i++ ){
		party.square.x = 1 + randm( MAP_MAX_X - 2);
		party.square.y = 1 + randm( MAP_MAX_Y - 2);
		party.square.pre_x = party.square.x;
		party.square.pre_y = party.square.y;

		for( n = 0; n < MBR_MAX_N; n++ ){
			if( chk_flg_or( party.mbr[n]->stat,
					FLG_STAT_NOT_EXIST
					| FLG_STAT_DEAD ) ){
				continue;
			}

			nx = party.square.x + party.square.chr_pos[n].x;
			ny = party.square.y + party.square.chr_pos[n].y;
			party.mbr[n]->x = nx;
			party.mbr[n]->y = ny;
			party.mbr[n]->pre_x = nx;
			party.mbr[n]->pre_y = ny;

			if( !can_move_chr( party.mbr[n], nx, ny ) )
				break;	/* ֤˰ưʤ */
		}
		if( n >= MBR_MAX_N )
			break;	/* ư褿 */
	}

	set_map_all_mbr();
}

/**/

void	clr_map_all_mbr( void )
{
	long	n;

	for( n = 0; n < MBR_MAX_N; n++ )
		clr_map_chr( party.mbr[n] );
}

/**/

void	set_map_all_mbr( void )
{
	long	n;

	for( n = 0; n < MBR_MAX_N; n++ )
		set_map_chr( party.mbr[n] );
}

/**/

void	act_party( void )
{
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ )
		act_chr( party.mbr[i] );

	switch( party.act.kind ){
	default:
		break;
	case ACT_KIND_RECALL:
		chk_recall();
		break;
	case ACT_KIND_SHOP:
		enter_shop();
		break;
	}

	draw_party();
}

/**/

bool_t	chk_auto_mnstr( mbr_t *mbr, long x1, long y1, long x2, long y2 )
{
	dun_t	*dun = get_dun();

	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	if( !chk_flg( mbr->flg_chr, FLG_CHR_AUTO_FIGHT ) )
		return FALSE;

	if( dun->map.chr.mjr[y1][x1] != FACE_MJR_NULL ){
		if( dun->map.chr.mjr[y1][x1] != FACE_MJR_MBR ){
			act_chr_auto_mnstr( mbr, x1, y1 );
			return TRUE;
		}
	}
	if( dun->map.chr.mjr[y2][x2] != FACE_MJR_NULL ){
		if( dun->map.chr.mjr[y2][x2] != FACE_MJR_MBR ){
			act_chr_auto_mnstr( mbr, x2, y2 );
			return TRUE;
		}
	}

	return FALSE;
}

/**/

bool_t	chk_auto_door_mbr( mbr_t *mbr, long x1, long y1, long x2, long y2 )
{
	dun_t	*dun = get_dun();

	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	if( !chk_flg( mbr->flg_chr, FLG_CHR_AUTO_DOOR ) )
		return FALSE;

	if( dun->map.obj.mjr[y1][x1] == FACE_MJR_DOOR_CLOSE ){
		act_chr_auto_door( mbr, x1, y1 );
		return TRUE;
	}
	if( dun->map.obj.mjr[y2][x2] == FACE_MJR_DOOR_CLOSE ){
		act_chr_auto_door( mbr, x2, y2 );
		return TRUE;
	}

	return FALSE;
}

/**/

void	die_mbr( mbr_t *mbr )
{
	long	i;

	print_msg_n( CURS_ATTR_N_FX_MBR_CRTCL, FLG_NULL,
			MSG_MBR_DIE, mbr->name );

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( party.mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		break;
	}
	if( i >= MBR_MAX_N ){
		print_msg( FLG_MSG_NO_MORE_PREV, MSG_S, MSG_GAME_OVER );
		while( 1 ){
			switch( get_key( FALSE ) ){
			case 'C' - '@':
			case 'Q' - '@':
				exit_game( EXIT_SUCCESS );
			}
		}
	}
}

/**/

void	act_mbr_auto_mnstr( mbr_t *mbr, long x, long y )
{
	mnstr_t	*mnstr;

	if( mbr == NULL )
		return;

	mnstr = get_mnstr( x, y );
	if( mnstr == NULL )
		return;

	mark_mnstr( mbr, mnstr, DIST_NEAR );
	set_chr_act( mbr, ACT_KIND_MNSTR_FIGHT, NULL, NULL, 0, 0 );
}

/**/

void	mbr_peep_door( mbr_t *mbr, long dr_n )
{
	dun_t	*dun;
	long	dx, dy;

	if( mbr == NULL )
		return;

	dun = get_dun();

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) )
		return;

	for( dy = 0; dy < dun->door[dr_n].dy; dy++ ){
		for( dx = 0; dx < dun->door[dr_n].dx; dx++ ){
			long	x, y;

			x = dun->door[dr_n].x + dx;
			y = dun->door[dr_n].y + dy;
			dun->map.obj.flg[y][x] |= FLG_OBJ_PASS;
		}
	}

	/**/

	set_flg_find_all_mnstr();
	draw_all_mnstr();

	wait_key_ex( TRUE );

	/**/

	for( dy = 0; dy < dun->door[dr_n].dy; dy++ ){
		for( dx = 0; dx < dun->door[dr_n].dx; dx++ ){
			long	x, y;

			x = dun->door[dr_n].x + dx;
			y = dun->door[dr_n].y + dy;
			dun->map.obj.flg[y][x] &= ~FLG_OBJ_PASS;
		}
	}

	set_flg_find_all_mnstr();
	redraw_map();
}

/**/

void	mbr_srch_door( mbr_t *mbr, long dr_n )
{
	dun_t	*dun;

	if( mbr == NULL )
		return;

	dun = get_dun();

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_SHOP ) ){
		char	*name;

		name = get_shop_name( get_shop_n( dun->door[dr_n].mnr ) );
		print_msg( FLG_NULL, MSG_SRCH_DOOR_SHOP, name );
	}

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) )
		print_msg( FLG_NULL, MSG_SRCH_DOOR_OPEN );
	else
		print_msg( FLG_NULL, MSG_SRCH_DOOR_CLOSE );

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_JAMMED ) )
		print_msg( FLG_NULL, MSG_SRCH_DOOR_JAMMED );

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_BROKEN ) )
		print_msg( FLG_NULL, MSG_SRCH_DOOR_BROKEN );

	dun->door[dr_n].flg |= FLG_DOOR_SRCHED;
	dun->door[dr_n].flg &= ~(FLG_DOOR_SECRET);

	set_face_door( dr_n );
	draw_door( dr_n );
}

/**/

void	mbr_srch_trap( mbr_t *mbr, trap_t *trap )
{
	dun_t	*dun;

	if( mbr == NULL )
		return;
	if( trap == NULL )
		return;
	if( trap->tab == NULL )
		return;

	dun = get_dun();

	print_msg( FLG_NULL, MSG_SRCH_TRAP, trap->tab->name );
}

/**/

void	mbr_srch_item( mbr_t *mbr, item_t *item )
{
	print_msg( FLG_NULL, MSG_SRCH_ITEM, item->name );
}

/**/

void	mbr_srch_obj( mbr_t *mbr )
{
	long	dx, dy;
	long	x, y;
	char	mjr, mnr;
	flg_map_t	flg;
	door_t	*dr;
	dun_t	*dun;
	bool_t	flg_find;
	party_t	*pty;

	if( mbr == NULL )
		return;

	flg_find = FALSE;

	dun = get_dun();
	x = mbr->x;
	y = mbr->y;
	for( dy = -1; dy <= +1; dy++ ){
		if( !clip_y( y + dy ) )
			continue;

		for( dx = -1; dx <= +1; dx++ ){
			if( !clip_x( x + dx ) )
				continue;

			flg = dun->map.obj.flg[y + dy][x + dx];
			mjr = dun->map.obj.mjr[y + dy][x + dx];
			mnr = dun->map.obj.mnr[y + dy][x + dx];

			if( (mjr == FACE_MJR_DOOR_CLOSE)
					|| (mjr == FACE_MJR_DOOR_OPEN) ){
				dr = get_door( x + dx, y + dy );
				if( chk_flg( dr->flg, FLG_DOOR_SECRET ) ){
					flg_find = TRUE;
					print_msg( FLG_NULL,
							MSG_DOOR_SRCH );
				}
				srch_door( dr->n );
			}
		}
	}

	pty = get_party();
	if( flg_find && chk_flg( pty->flg, FLG_PARTY_SRCH_AUTO_OFF ) ){
		long	n;

		for( n = 0; n < MBR_MAX_N; n++ ){
			if( pty->mbr[n]->act.kind == ACT_KIND_SRCH ){
				clr_chr_trgt_act( pty->mbr[n], FALSE );
			}
		}
	}
}

/**/

void	clr_party_act( void )
{
	party.act.kind = ACT_KIND_NULL;
}

/**/

void	join_mbr( long ls_mbr_n, long mbr_n )
{
	if( mbr_n == MBR_N_NOT_JOIN )
		return;

	party.mbr[mbr_n] = ls_mbr[ls_mbr_n];
	ls_mbr[ls_mbr_n]->mbr_n = mbr_n;
}

/**/

void	not_join_mbr( long ls_mbr_n, long mbr_n )
{
	if( mbr_n == MBR_N_NOT_JOIN )
		return;

	ls_mbr[ls_mbr_n]->mbr_n = MBR_N_NOT_JOIN;
	party.mbr[mbr_n] = ls_mbr[LS_MBR_MAX_N];
}

/**/

void	collect_gold( mbr_t *mbr )
{
	long	gold;
	long	i;

	if( mbr == NULL )
		return;
	if( mbr->fx_data.friend_turn > 0 ){
		print_msg( FLG_NULL, MSG_NOT_FRIEND_GOLD,
				mbr->name );
		return;
	}

	gold = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg( party.mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;
		if( party.mbr[i]->fx_data.friend_turn > 0 ){
			print_msg( FLG_NULL, MSG_NOT_FRIEND_GOLD,
					party.mbr[i]->name );
			continue;
		}

		gold += party.mbr[i]->gold;
		party.mbr[i]->gold = 0;
	}

	mbr->gold = gold;

	print_msg( FLG_NULL, MSG_COLLECT_GOLD, mbr->name, gold );
}

/**/

void	divide_gold( void )
{
	long	sum, gold;
	long	i, n, n2;

	n = 0;
	sum = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg( party.mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;
		if( party.mbr[i]->fx_data.friend_turn > 0 ){
			print_msg( FLG_NULL, MSG_NOT_FRIEND_GOLD,
					party.mbr[i]->name );
			continue;
		}

		sum += party.mbr[i]->gold;
		n++;
	}
	if( n <= 0 )
		return;

	n2 = 0;
	gold = sum / n;
	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg( party.mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;
		if( party.mbr[i]->fx_data.friend_turn > 0 )
			continue;

		party.mbr[i]->gold = gold;
		sum -= gold;

		n2++;
		if( n2 == n ){
			party.mbr[i]->gold += sum;
			break;
		}
	}

	print_msg( FLG_NULL, MSG_DIVIDE_GOLD, gold );
}

/**/

void	exp_party( long exp, bool_t flg_draw )
{
	party_t	*pty = get_party();
	long	i, n, mod_n;
	flg_stat_t	flg;
	long	exp_add, exp_mod;

	flg = FLG_NULL;
	flg |= FLG_STAT_NOT_EXIST | FLG_STAT_DEAD | FLG_STAT_STONE;
	flg |= FLG_STAT_SLEEP | FLG_STAT_FAINT;

	n = 0;
	mod_n = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		if( !chk_flg_or( party.mbr[i]->stat, flg ) ){
			n++;
			if( randm( n ) == 0 )
				mod_n = i;
		}
	}
	if( n <= 0 )
		return;

	exp_add = exp / n;
	exp_mod = exp % n;

	if( flg_draw ){
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_EXP_PARTY, exp_add );
	}

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( party.mbr[i]->stat, flg ) )
			continue;

		if( i == mod_n )
			exp_chr( pty->mbr[i], exp_add + exp_mod, FALSE );
		else
			exp_chr( pty->mbr[i], exp_add, FALSE );
	}
}

/**/

void	remove_mbr( mbr_t *mbr )
{
	long	i;
	long	mbr_n, ls_mbr_n;
	mbr_t	*tmp_mbr;

	if( mbr == NULL )
		return;

	mbr_n = mbr->mbr_n;
	ls_mbr_n = mbr->ls_mbr_n;

	/* item */

	remove_mbr_del_item( ls_mbr_n );

	/* party.mbr */

	if( mbr_n != MBR_N_NOT_JOIN )
		party.mbr[mbr_n] = ls_mbr[LS_MBR_MAX_N];

	/* ls_mbr */

	free_fx_all( &(ls_mbr[ls_mbr_n]->fx) );
	tmp_mbr = ls_mbr[ls_mbr_n];
	for( i = ls_mbr_n; i < LS_MBR_MAX_N - 1; i++ ){
		ls_mbr[i] = ls_mbr[i + 1];
		ls_mbr[i]->ls_mbr_n--;
	}
	ls_mbr[i] = tmp_mbr;
	ls_mbr[i]->mbr_n = MBR_N_NOT_JOIN;
	ls_mbr[i]->stat |= FLG_STAT_NOT_EXIST;
}

/**/

mbr_t	*get_mbr_nearest( long x, long y )
{
	mbr_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;
	dun_t	*dun;
	long	i;

	dun = get_dun();

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		pos_t	pos1, pos2;

		p = party.mbr[i];

		if( chk_flg_or( p->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		tmp_r = abs( p->x - x ) + abs( p->y - y );
		if( tmp_r > min_r )
			continue;

		pos1.x = p->x;
		pos1.y = p->y;
		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/**/

mbr_t	*get_mbr_near( long x, long y )
{
	mbr_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;
	dun_t	*dun;
	long	i;

	dun = get_dun();

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		pos_t	pos1, pos2;

		p = party.mbr[i];

		if( chk_flg_or( p->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		tmp_r = abs( p->x - x ) + abs( p->y - y );
		if( tmp_r > min_r )
			continue;

		pos1.x = p->x;
		pos1.y = p->y;
		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( (tmp_r - min_r) <= MBR_NEAR_R ){
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/**/

mbr_t	*get_mbr_disperse( mbr_t *mbr )
{
	mbr_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;
	long	x, y;
	dun_t	*dun;
	long	i;

	if( mbr == NULL )
		return NULL;

	x = mbr->x;
	y = mbr->y;

	dun = get_dun();

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		pos_t	pos1, pos2;

		p = party.mbr[i];

		if( chk_flg_or( p->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		tmp_r = abs( p->x - x ) + abs( p->y - y );
		if( tmp_r > min_r )
			continue;

		pos1.x = p->x;
		pos1.y = p->y;
		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			if( chk_already_mark( p, mbr ) )
				continue;
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			if( chk_already_mark( p, mbr ) )
				continue;
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/**/

mbr_t	*get_mbr_randm( long x, long y )
{
	mbr_t	*p, *ret_p;
	long	n;
	dun_t	*dun;
	long	i;

	dun = get_dun();

	ret_p = NULL;
	n = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		pos_t	pos1, pos2;

		p = party.mbr[i];

		if( chk_flg_or( p->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		pos1.x = p->x;
		pos1.y = p->y;
		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		n++;
		if( randm( n ) == 0 )
			ret_p = p;
	}

	return ret_p;
}

/**/

mbr_t	*get_mbr_stagger( mbr_t *mbr )
{
	mbr_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;
	long	x, y;
	dun_t	*dun;
	long	i;

	if( mbr == NULL )
		return NULL;

	/* ʬեĤƤޡʤ */
	if( chk_chr_stagger( mbr ) )
		return NULL;

	x = mbr->x;
	y = mbr->y;

	dun = get_dun();

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		pos_t	pos1, pos2;

		p = party.mbr[i];

		if( chk_flg_or( p->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( !chk_chr_stagger( p ) )
			continue;

		tmp_r = abs( p->x - x ) + abs( p->y - y );
		if( tmp_r > min_r )
			continue;

		pos1.x = p->x;
		pos1.y = p->y;
		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			if( chk_already_mark( p, mbr ) )
				continue;
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			if( chk_already_mark( p, mbr ) )
				continue;
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/**/

bool_t	chk_already_mark( void *p, mbr_t *mbr )
{
	party_t	*pty;
	long	i;

	if( mbr == NULL )
		return FALSE;

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( pty->mbr[i] == mbr )
			continue;
		if( pty->mbr[i]->trgt.kind == TRGT_KIND_SQUARE )
			continue;

		if( pty->mbr[i]->trgt.p == p )
			return TRUE;
	}

	return FALSE;
}

/**/

char	*get_race_str( race_t *race )
{
	static char	str_main[RACE_STR_MAX_LEN + 1];
	static char	str_sub[RACE_STR_MAX_LEN + 1];
	static char	str_tmp[RACE_STR_MAX_LEN * 3 + 1];
	static char	str_name[RACE_STR_MAX_LEN + 1];

	str_main[0] = '\0';
	str_sub[0] = '\0';
	str_tmp[0] = '\0';
	str_name[0] = '\0';

	switch( race->main ){
	case MAIN_RACE_HUMAN:
		strncpy( str_main, MSG_MAIN_RACE_HUMAN,
				RACE_STR_MAX_LEN );
		break;
	case MAIN_RACE_HALF_ELF:
		strncpy( str_main, MSG_MAIN_RACE_HALF_ELF,
				RACE_STR_MAX_LEN );
		break;
	case MAIN_RACE_ELF:
		strncpy( str_main, MSG_MAIN_RACE_ELF,
				RACE_STR_MAX_LEN );
		break;
	case MAIN_RACE_DWARF:
		strncpy( str_main, MSG_MAIN_RACE_DWARF,
				RACE_STR_MAX_LEN );
		break;
	case MAIN_RACE_VIVID:
		strncpy( str_main, MSG_MAIN_RACE_VIVID,
				RACE_STR_MAX_LEN );
		break;
	case MAIN_RACE_MAX_N:
		break;
	}

	switch( race->sub ){
	case SUB_RACE_NULL:
		break;
	case SUB_RACE_CAT:
		str_max_n_cat( str_sub, MSG_SUB_RACE_CAT,
				RACE_STR_MAX_LEN );
		break;
	case SUB_RACE_DOG:
		str_max_n_cat( str_sub, MSG_SUB_RACE_DOG,
				RACE_STR_MAX_LEN );
		break;
	case SUB_RACE_MOUSE:
		str_max_n_cat( str_sub, MSG_SUB_RACE_MOUSE,
				RACE_STR_MAX_LEN );
		break;
	case SUB_RACE_RABBIT:
		str_max_n_cat( str_sub, MSG_SUB_RACE_RABBIT,
				RACE_STR_MAX_LEN );
		break;
	case SUB_RACE_MONKEY:
		str_max_n_cat( str_sub, MSG_SUB_RACE_MONKEY,
				RACE_STR_MAX_LEN );
		break;
	case SUB_RACE_PIG:
		str_max_n_cat( str_sub, MSG_SUB_RACE_PIG,
				RACE_STR_MAX_LEN );
		break;
	case SUB_RACE_BIRD:
		str_max_n_cat( str_sub, MSG_SUB_RACE_BIRD,
				RACE_STR_MAX_LEN );
		break;
	case SUB_RACE_LIZARD:
		str_max_n_cat( str_sub, MSG_SUB_RACE_LIZARD,
				RACE_STR_MAX_LEN );
		break;
	case SUB_RACE_MAX_N:
		break;
	}

	if( race->sub == SUB_RACE_NULL )
		sprintf( str_tmp, MSG_RACE_STR_PUREBRED, str_main );
	else
		sprintf( str_tmp, MSG_RACE_STR_MIXED, str_main, str_sub );

	strncpy( str_name, str_tmp, RACE_STR_MAX_LEN );

	return str_name;
}

/**/

char	*get_race_name( race_t *race )
{
	if( race == NULL )
		return "";

	if( race->sub == SUB_RACE_NULL ){
		switch( race->main ){
		case MAIN_RACE_HUMAN:
			return MSG_MAIN_RACE_HUMAN;
		case MAIN_RACE_HALF_ELF:
			return MSG_MAIN_RACE_HALF_ELF;
		case MAIN_RACE_ELF:
			return MSG_MAIN_RACE_ELF;
		case MAIN_RACE_DWARF:
			return MSG_MAIN_RACE_DWARF;
		case MAIN_RACE_VIVID:
			return MSG_MAIN_RACE_VIVID;
		case MAIN_RACE_MAX_N:
			break;
		}
	}

	return race->name;
}

/**/

long	add_hp_mbr( mbr_t *mbr, long n )
{
	long	pre_hp, add;

	if( mbr == NULL )
		return 0;

	pre_hp = mbr->abl.hp.n;
	if( (mbr->abl.hp.n <= 1) && (n <= -1) ){
		mbr->abl.hp.n = 0;
	} else {
		mbr->abl.hp.n += n;
		if( mbr->abl.hp.n > mbr->abl.hp.max )
			mbr->abl.hp.n = mbr->abl.hp.max;
		if( mbr->abl.hp.n < 1 )
			mbr->abl.hp.n = 1;
	}

	add = mbr->abl.hp.n - pre_hp;
	if( add != 0 ){
		vfx_num( mbr, add );
		draw_mbr_stat( mbr );
	}

	if( mbr->abl.hp.n <= 0 )
		die_chr( mbr, FALSE );

	return mbr->abl.hp.n;
}

/**/

mbr_t	**get_ls_mbr( void )
{
	return ls_mbr;
}

/**/

party_t	*get_party( void )
{
	return &party;
}

/**/

long	get_mbr_n( long x, long y )
{
	party_t	*pty;
	long	n;

	pty = get_party();
	for( n = 0; n < MBR_MAX_N; n++ ){
		mbr_t	*mbr;

		mbr = pty->mbr[n];
		if( chk_flg_or( mbr->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( (mbr->x == x) && (mbr->y == y) ){
			return n;
		}
	}
	return MBR_N_NOT_JOIN;
}

/**/

mbr_t	*get_mbr( long x, long y )
{
	long	mbr_n;

	mbr_n = get_mbr_n( x, y );

	if( mbr_n <= MBR_N_NOT_JOIN )
		return NULL;

	return( party.mbr[mbr_n] );
}

/**/

flg_party_t	get_flg_party( void )
{
	return party.flg;
}

/**/

flg_party_t	set_flg_party( flg_party_t flg )
{
	party.flg = flg;

	return party.flg;
}

/**/

long	next_mbr( long mbr_n, long add )
{
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ ){
		mbr_n += add + MBR_MAX_N;
		mbr_n %= MBR_MAX_N;
		if( party.mbr[mbr_n]->stat != FLG_STAT_NOT_EXIST )
			break;
	}

	return mbr_n;
}

/**/

long	next_ls_mbr( long ls_mbr_n, long add )
{
	long	i;

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		ls_mbr_n += add + LS_MBR_MAX_N;
		ls_mbr_n %= LS_MBR_MAX_N;
		if( ls_mbr[ls_mbr_n]->stat != FLG_STAT_NOT_EXIST )
			break;
	}

	return ls_mbr_n;
}

/**/

class_t	*get_class_tab( void )
{
	return class_tab;
}

/**/

bool_t	remove_class( long class_n )
{
	mbr_t	**ls_mbr = get_ls_mbr();
	class_t	*p;
	long	n, max_n;
	long	i;

	p = get_class_tab();

	if( p[1].name[0] == '\0' ){
		print_msg( FLG_NULL, MSG_S, MSG_ERR_REMOVE_CLASS );
		return FALSE;
	}

	for( n = class_n; n < CLASS_MAX_N; n++ ){
		p[n] = p[n + 1];
		if( p[n + 1].name[0] == '\0' )
			break;
	}
	max_n = n - 1;

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		if( ls_mbr[i]->class_n > class_n )
			ls_mbr[i]->class_n--;
		if( ls_mbr[i]->class_n > max_n )
			ls_mbr[i]->class_n = max_n;
	}

	return TRUE;
}

/**/

bool_t	cmp_class( class_t *org, class_t *dst )
{
	abl_kind_t	abl;

	if( strncmp( org->name, dst->name, CLASS_NAME_MAX_LEN ) != 0 )
		return FALSE;

	for( abl = 0; abl < ABL_KIND_MAX_N; abl++ )
		if( org->abl_rate[abl] != dst->abl_rate[abl] )
			return FALSE;

	return TRUE;
}

/**/

char	*get_msg_ttl_auto_mark( long n )
{
	return msg_ttl_auto_mark[n];
}

/**/

square_t	*get_square_mbr( void )
{
	return &(party.square);
}

/**/

void	set_square_mbr( square_t *sq )
{
	party.square = *sq;
}

/**/

