#ifndef	__CURS_H__
#define	__CURS_H__

#include	"msg.h"

#ifdef	D_USE_CURSES

#include	<curses.h>

#else	/* D_USE_CURSES */

#define NCURSES_ATTR_SHIFT       8
#define NCURSES_BITS(mask,shift) ((mask) << ((shift) + NCURSES_ATTR_SHIFT))

#define A_NORMAL	0L
#define A_ATTRIBUTES	NCURSES_BITS(~(1UL - 1UL),0)
#define A_CHARTEXT	(NCURSES_BITS(1UL,0) - 1UL)
#define A_COLOR		NCURSES_BITS(((1UL) << 8) - 1UL,0)
#define A_STANDOUT	NCURSES_BITS(1UL,8)
#define A_UNDERLINE	NCURSES_BITS(1UL,9)
#define A_REVERSE	NCURSES_BITS(1UL,10)
#define A_BLINK		NCURSES_BITS(1UL,11)
#define A_DIM		NCURSES_BITS(1UL,12)
#define A_BOLD		NCURSES_BITS(1UL,13)
#define A_ALTCHARSET	NCURSES_BITS(1UL,14)
#define A_INVIS		NCURSES_BITS(1UL,15)
#define A_PROTECT	NCURSES_BITS(1UL,16)
#define A_HORIZONTAL	NCURSES_BITS(1UL,17)
#define A_LEFT		NCURSES_BITS(1UL,18)
#define A_LOW		NCURSES_BITS(1UL,19)
#define A_RIGHT		NCURSES_BITS(1UL,20)
#define A_TOP		NCURSES_BITS(1UL,21)
#define A_VERTICAL	NCURSES_BITS(1UL,22)

#define COLOR_BLACK	0
#define COLOR_RED	1
#define COLOR_GREEN	2
#define COLOR_YELLOW	3
#define COLOR_BLUE	4
#define COLOR_MAGENTA	5
#define COLOR_CYAN	6
#define COLOR_WHITE	7

typedef struct {
} WINDOW;

WINDOW	*stdscr;

typedef unsigned long	chtype;

#endif	/* D_USE_CURSES */

typedef enum {
	CURS_ATTR_N_NORMAL,
	CURS_ATTR_N_ERR,
	CURS_ATTR_N_MENU_DIS,
	CURS_ATTR_N_MENU_SEL,
	CURS_ATTR_N_MAP_ITEM,
	CURS_ATTR_N_MAP_SQUARE,
	CURS_ATTR_N_MAP_MNSTR,
	CURS_ATTR_N_MAP_CRSR,
	CURS_ATTR_N_FX_MBR_PLUS,
	CURS_ATTR_N_FX_MBR_MINUS,
	CURS_ATTR_N_FX_MBR_CRTCL,
	CURS_ATTR_N_FX_MNSTR_PLUS,
	CURS_ATTR_N_FX_MNSTR_MINUS,
	CURS_ATTR_N_FX_MNSTR_CRTCL,
	CURS_ATTR_N_VFX,

	CURS_ATTR_N_MBR_1,
	CURS_ATTR_N_MBR_2,
	CURS_ATTR_N_MBR_3,
	CURS_ATTR_N_MBR_4,
	CURS_ATTR_N_MBR_5,
	CURS_ATTR_N_MBR_6,

	CURS_ATTR_MAX_N,

	CURS_ATTR_N_MAP_NORMAL = CURS_ATTR_N_NORMAL,
} curs_attr_n_t;

typedef struct {
	short	color_pair_n;
	n_msg_t	name_n;
	int	fg, bg;
	chtype	attr;
} curs_attr_t;

#endif	/* __CURS_H__ */
