/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
/*#include	"dun.h"*/
/*#include	"town.h"*/
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
#include	"item_prot.h"
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
#include	"fight_prot.h"
#include	"fx_prot.h"
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

#define	MNSTR_MOVE_MAX_X	(AREA_MAX_X * 1 + 0)
#define	MNSTR_MOVE_MAX_Y	(AREA_MAX_Y * 1 + 0)

#define	MNSTR_NEAR_R	4

#define	INCREASE_RATE_GIANT_RAT	20

/**/

mnstr_t	mnstr_buf[MNSTR_MAX_N];
mnstr_t	mnstr_used, mnstr_free;

#include	"mnstr_tab.h"

/**/

void	init_mnstr( void )
{
	long	i;

	for( i = 0; mnstr_tab[i].mnstr_kind != MNSTR_KIND_NULL; i++ ){
		mnstr_tab[i].name = MSG( mnstr_tab[i].name_n );
	}

	reset_mnstr();
}

/**/

void	reset_mnstr( void )
{
	long	i;

	mnstr_used.next = &mnstr_used;
	mnstr_used.prev = &mnstr_used;

	mnstr_free.next = &mnstr_buf[0];
	mnstr_buf[0].prev = &mnstr_free;
	mnstr_buf[0].next = &mnstr_buf[1];
	for( i = 1; i < MNSTR_MAX_N - 1; i++ ){
		mnstr_buf[i].prev = &(mnstr_buf[i - 1]);
		mnstr_buf[i].next = &(mnstr_buf[i + 1]);
	}
	mnstr_buf[i].prev = &mnstr_buf[i - 1];
	mnstr_buf[i].next = &mnstr_free;
	mnstr_free.prev = &mnstr_buf[i];
}

/**/

void	new_mnstr( mnstr_t *mnstr )
{
	long	lev;
	long	i;

#if	0
	mnstr->prev = NULL;
	mnstr->next = NULL;
#endif
	mnstr->kind = CHR_KIND_MNSTR;
	mnstr->name[0] = '0';
	mnstr->mbr_n = MBR_N_NOT_JOIN;
	mnstr->ls_mbr_n = 0;
	mnstr->face_mjr = FACE_MJR_NULL;
	mnstr->face_mnr = FACE_MNR_NULL;
	mnstr->race.main = MAIN_RACE_HUMAN;
	mnstr->race.sub = SUB_RACE_NULL;
	mnstr->race.name[0] = '0';
	mnstr->sex = MALE;
	mnstr->x = -1;
	mnstr->y = -1;
	mnstr->pre_x = -1;
	mnstr->pre_y = -1;
	mnstr->move_rate = _100_PERCENT;
	mnstr->gold = 0;
	mnstr->max_dun_lev_floor = 0;
	mnstr->max_dun_lev_base = 0;

	mnstr->trgt.dist = DIST_NEAR;
	mnstr->trgt.dflt_dist_mnstr = DIST_NEAR;
	mnstr->act.dflt_kind_mnstr
			= ACT_KIND_MNSTR_FIGHT;
	strncpy( mnstr->act.dflt_msg_mnstr,
			MSG_MENU_MARK_FIGHT, ACT_MSG_MAX_LEN );
	clr_chr_trgt_act( mnstr, TRUE );

#if	0
	for( i = 0; i < AUTO_MARK_MAX_N; i++ ){
		mnstr->auto_mark[i] = dflt_auto_mark_clear;
		strncpy( msg_ttl_auto_mark[i],
				MSG_NAME_DFLT_AUTO_MARK_CLEAR,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
#endif

	mnstr->flg_chr = FLG_NULL;
	mnstr->flg_map = FLG_NULL;
	mnstr->stat = FLG_NULL;

	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		mnstr->abl.lev[i].max = 1;

		lev = mnstr->abl.lev[i].max;

		mnstr->abl.exp[i].max = calc_lev_to_exp( lev, i );

		mnstr->abl.exp[i].n = mnstr->abl.exp[i].max;
		mnstr->abl.lev[i].n = mnstr->abl.lev[i].max;
	}

	lev = mnstr->abl.lev[ABL_KIND_HP].max;
	mnstr->abl.hp.max = calc_lev_to_val( lev, ABL_KIND_HP );
	mnstr->abl.hp.n = mnstr->abl.hp.max;

	lev = mnstr->abl.lev[ABL_KIND_MP].max;
	mnstr->abl.mp.max = calc_lev_to_val( lev, ABL_KIND_MP );
	mnstr->abl.mp.n = mnstr->abl.mp.max;

	mnstr->class_n = 0;

	for( i = 0; i < RESI_KIND_MAX_N; i++ ){
		mnstr->resi[i].n = _100_PERCENT;
		mnstr->resi[i].max = _100_PERCENT;
	}
	mnstr->ac = 0;

	mnstr->fx.next = &(mnstr->fx);
	mnstr->fx.prev = &(mnstr->fx);

	mnstr->fx_data.infra_vision = 0;

	mnstr->fx_data.stomach.rate = _100_PERCENT;
	mnstr->fx_data.stomach.full_rate = 100;
	mnstr->fx_data.stomach.digest_p_day = 20;
	mnstr->fx_data.stomach.hungry_rate = 70;
	mnstr->fx_data.stomach.starvation_rate = 30;

	mnstr->fx_data.drunk_rate = 0;

	mnstr->fx_data.nicotine.rate = 0;
	mnstr->fx_data.nicotine.poisoning_rate = 0;

	mnstr->fx_data.friend_turn = 0;

	mnstr->mnstr_kind = MNSTR_KIND_NULL;
	mnstr->mnstr_tab = NULL;

	mnstr->work.caught = 0;
}

/**/

mnstr_kind_t	make_mnstr_rand( long x, long y, long dun_lev )
{
	mnstr_kind_t	mnstr_kind;
	mnstr_tab_t	*tab;
	long	n;
	short	group;
	long	i, j;

	if( !can_move_chr( NULL, x, y ) )
		return MNSTR_KIND_NULL;

	n = 0;
	mnstr_kind = MNSTR_KIND_NULL;
	tab = &(mnstr_tab[0]);
	for( i = 0; mnstr_tab[i].mnstr_kind != MNSTR_KIND_NULL; i++ ){
		mnstr_tab_t	*tmp_tab;

		tmp_tab = &(mnstr_tab[i]);

		if( abs( dun_lev ) < tmp_tab->min_lev )
			continue;
		if( tmp_tab->max_lev <  abs( dun_lev ) )
			continue;
		if( sgn( dun_lev ) != tmp_tab->sgn_lev )
			continue;

		n++;
		if( randm( n ) == 0 ){
			mnstr_kind = tmp_tab->mnstr_kind;
			tab = tmp_tab;
		}
	}
	if( mnstr_kind == MNSTR_KIND_NULL )
		return MNSTR_KIND_NULL;

	make_mnstr( x, y, dun_lev, mnstr_kind );

	group = roll_dice( tab->group );
	for( i = 0; i < tab->group - 1; i++ ){
		long	nx, ny;

		for( j = 128; j > 0; j-- ){
			nx = x + (randm( 10 + 1 + 10 ) - 10);
			ny = y + (randm( 10 + 1 + 10 ) - 10);
			if( can_move_chr( NULL, nx, ny ) )
				break;
		}
		if( j <= 0 )
			continue;

		make_mnstr( nx, ny, dun_lev, mnstr_kind );
	}

	return mnstr_kind;
}

/**/

mnstr_kind_t	make_mnstr(
	long x, long y, long dun_lev, mnstr_kind_t mnstr_kind
)
{
	long	i;
	dun_t	*dun;
	mnstr_t	*p;
	mnstr_tab_t	*tab;

	dun = get_dun();
	if( dun->map.chr.mjr[y][x] != FACE_MJR_NULL )
		return MNSTR_KIND_NULL;
	if( !chk_flg( dun->map.obj.flg[y][x], FLG_OBJ_PASS ) )
		return MNSTR_KIND_NULL;
	if( mnstr_kind == MNSTR_KIND_NULL )
		return MNSTR_KIND_NULL;

	tab = get_mnstr_tab( mnstr_kind );
	if( tab == NULL )
		return MNSTR_KIND_NULL;

	p = mnstr_free.next;
	if( p == &mnstr_free )
		return MNSTR_KIND_NULL;
	ins_ls_mnstr( &mnstr_used, p );

	new_mnstr( p );

	strncpy( p->name, tab->name, MNSTR_NAME_MAX_LEN );
	p->x = x;
	p->y = y;
	p->pre_x = x;
	p->pre_y = y;
	p->face_mjr = tab->face_mjr;
	p->face_mnr = tab->face_mnr;
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		long	lev;

		lev = tab->abl_lev_max[i];

		p->abl.lev[i].n = lev;
		p->abl.lev[i].max = lev;
	}
	p->abl.hp.n = calc_lev_to_val(
			tab->abl_lev_max[ABL_KIND_HP], ABL_KIND_HP );
	p->abl.mp.n = calc_lev_to_val(
			tab->abl_lev_max[ABL_KIND_MP], ABL_KIND_MP );

	for( i = 0; i < RESI_KIND_MAX_N; i++ ){
		p->resi[i].n = tab->resi[i];
		p->resi[i].max = tab->resi[i];
	}
	p->ac = tab->ac;
	p->move_rate = tab->move_rate;
	p->flg_chr = tab->flg;
	p->stat = FLG_NULL;
	p->trgt.kind = TRGT_KIND_NULL;
	p->trgt.p = NULL;
	p->trgt.n = 0;
	p->trgt.x = 0;
	p->trgt.y = 0;
	p->trgt.true_x = 0;
	p->trgt.true_y = 0;
	p->fx.next = &(p->fx);
	p->fx.prev = &(p->fx);
	p->fx_data.drunk_rate = 0;
	p->mnstr_kind = mnstr_kind;
	p->mnstr_tab = tab;
	p->work.flg = FLG_NULL;
	p->work.flg &= ~(FLG_WORK_FIND_MBR);
	p->work.catch_chr = NULL;

	dun->map.chr.mjr[p->y][p->x] = p->face_mjr;
	dun->map.chr.mnr[p->y][p->x] = p->face_mnr;
	dun->map.chr.flg[p->y][p->x] = p->flg_chr;

	make_mnstr_special( dun_lev, p );

	return p->mnstr_kind;
}

/**/

void	make_mnstr_special( long dun_lev, mnstr_t *p )
{
	item_t	*tmp, dmy;

	if( p == NULL )
		return;

	switch( p->mnstr_kind ){
	default:
		break;
	case MNSTR_KIND_MIMIC:
		tmp = alloc_item( &dmy );
		if( tmp == NULL )
			break;

		if( !make_item_chest( dun_lev, tmp,
				get_chest_n( dun_lev ) ) ){
			free_item( tmp );
			die_chr( p, FALSE );
			break;
		}
		if( !put_item( p->x, p->y, 1, tmp, FALSE ) ){
			free_item( tmp );
			die_chr( p, FALSE );
			break;
		}

		break;
	}
}

/**/

void	act_all_mnstr( void )
{
	mnstr_t	*p, *head;

	head = &mnstr_used;
	for( p = head->next->next; p->prev != head; p = p->next ){
		if( p == NULL )
			break;
		act_mnstr( p );
	}
}

/**/

void	act_mnstr( mnstr_t *p )
{
	long	i;
	party_t	*party;
	dun_t	*dun;

	party = get_party();
	dun = get_dun();

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( party->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( (abs( p->x - party->mbr[i]->x )
				<= MNSTR_MOVE_MAX_X)
				&& (abs( p->y - party->mbr[i]->y )
				<= MNSTR_MOVE_MAX_Y) ){
			break;
		}
	}
	if( i >= MBR_MAX_N ){	/* СΥƤ */
		p->flg_chr &= ~FLG_CHR_FIND;
		dun->map.chr.flg[p->y][p->x] = p->flg_chr;
		draw_mnstr( p );
		return;	/* Υ⤻˽λ */
	}

	if( !chk_flg_or( p->stat,
			FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_PARALYZE
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){

		switch( p->mnstr_kind ){
		case MNSTR_KIND_GIANT_BAT:
			act_mnstr_giant_bat( p );
			break;
		case MNSTR_KIND_GIANT_RAT:
			act_mnstr_giant_rat( p );
			break;
		case MNSTR_KIND_MIMIC:
			act_mnstr_mimic( p );
			break;
		case MNSTR_KIND_NULL:
		case MNSTR_KIND_MAX_N:
			break;
		}
	}

	set_flg_find_mnstr( p );

	draw_mnstr( p );
}

/**/

void	inc_turn_all_mnstr( void )
{
	mnstr_t	*p, *head;

	head = &mnstr_used;
	for( p = head->next->next; p->prev != head; p = p->next ){
		if( p == NULL )
			break;

		p->fx_data.infra_vision--;
		if( p->fx_data.infra_vision < 0 )
			p->fx_data.infra_vision = 0;
	}
}

/**/

void	act_mnstr_giant_bat( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( !chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
		if( mnstr_srch_mbr_std( p ) == NULL ){
			move_chr( p, MOVE_KIND_STAGGER );
			return;
		}
		p->work.flg |= FLG_WORK_FIND_MBR;
	}

	mnstr_mark_mbr_std( p );
	if( p->trgt.p == NULL )
		return;

	if( rate_randm( 80 ) ){
		move_chr( p, MOVE_KIND_STAGGER );
		return;
	}

	mnstr_move_or_atack_std( p );
}

/**/

void	act_mnstr_giant_rat( mnstr_t *p )
{
	static long	increase_turn = -1;

	if( p == NULL )
		return;

	if( !chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
		if( mnstr_srch_mbr_std( p ) == NULL ){
			move_chr( p, MOVE_KIND_STAGGER );
			return;
		}
		p->work.flg |= FLG_WORK_FIND_MBR;
	}

	mnstr_mark_mbr_std( p );
	if( p->trgt.p == NULL )
		return;

	if( rate_randm( 60 ) ){
		move_chr( p, MOVE_KIND_STAGGER );
		return;
	}

	mnstr_move_or_atack_std( p );

	if( increase_turn < get_turn() ){
		if( rate_randm( INCREASE_RATE_GIANT_RAT ) ){
			increase_mnstr( p );
			increase_turn = get_turn();
		}
	}
}

/**/

void	act_mnstr_mimic( mnstr_t *p )
{
	dun_t	*dun;

	if( p == NULL )
		return;

	dun = get_dun();
	if( dun == NULL )
		return;

	if( !chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
		if( mnstr_srch_mbr_mimic( p ) == NULL )
			return;
		p->work.flg |= FLG_WORK_FIND_MBR;
	}

	dun->map.chr.mjr[p->y][p->x] = p->face_mjr;
	dun->map.chr.mnr[p->y][p->x] = p->face_mnr;
	dun->map.chr.flg[p->y][p->x] = p->flg_chr;

	mnstr_mark_mbr_std( p );
	if( p->trgt.p == NULL )
		return;

	if( (abs( p->x - p->trgt.x ) <= 1)
			&& (abs( p->y - p->trgt.y ) <= 1) ){
		bash( p, (mbr_t *)(p->trgt.p), NULL );
	}
}

/**/

void	mnstr_move_or_atack_std( mnstr_t *p )
{
	if( (abs( p->x - p->trgt.x ) <= 1)
			&& (abs( p->y - p->trgt.y ) <= 1) ){
		bash( p, (mbr_t *)(p->trgt.p), NULL );
	} else {
		move_chr( p, MOVE_KIND_STD );
	}
}

/**/

bool_t	teleport_mnstr( mnstr_t *mnstr )
{
	dun_t	*dun = get_dun();
	long	i;

	if( mnstr == NULL )
		return FALSE;
	if( chk_flg_or( mnstr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	dun->map.chr.mjr[mnstr->y][mnstr->x] = FACE_MJR_NULL;
	dun->map.chr.mnr[mnstr->y][mnstr->x] = FACE_MNR_NULL;
	dun->map.chr.flg[mnstr->y][mnstr->x] = FLG_NULL;
	draw_mnstr( mnstr );

	for( i = 1024; i > 0; i-- ){
		long	nx, ny;

		nx = 1 + randm( MAP_MAX_X - 2);
		ny = 1 + randm( MAP_MAX_Y - 2);

		if( can_move_chr( NULL, nx, ny ) ){
			/* ֤˰ư褿 */
			mnstr->x = nx;
			mnstr->y = ny;
			mnstr->pre_x = nx;
			mnstr->pre_y = ny;
			break;
		}
	}

	dun->map.chr.mjr[mnstr->y][mnstr->x] = mnstr->face_mjr;
	dun->map.chr.mnr[mnstr->y][mnstr->x] = mnstr->face_mnr;
	dun->map.chr.flg[mnstr->y][mnstr->x] = mnstr->flg_chr;
	draw_mnstr( mnstr );

	redraw_all();

	return TRUE;
}

/**/

bool_t	increase_mnstr( mnstr_t *p )
{
	long	nx, ny;
	dun_t	*dun;

	nx = p->x + (randm( 3 ) - 1);
	ny = p->y + (randm( 3 ) - 1);
	if( can_move_chr( NULL, nx, ny ) ){
		dun = get_dun();

		make_mnstr( nx, ny, dun->lev, p->mnstr_kind );

		return TRUE;
	}

	return FALSE;
}

/**/

mbr_t	*mnstr_srch_mbr_std( mnstr_t *p )
{
	party_t	*pty;
	pos_t	pos1, pos2;
	long	i;

	if( p == NULL )
		return NULL;

	pty = get_party();
	pos1.x = p->x;
	pos1.y = p->y;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		pos2.x = pty->mbr[i]->x;
		pos2.y = pty->mbr[i]->y;

		if( chk_find( &pos1, &pos2 ) )
			return pty->mbr[i];
	}

	return NULL;
}

/**/

mbr_t	*mnstr_srch_mbr_mimic( mnstr_t *p )
{
	party_t	*pty;
	long	i;
	item_t	*chest;

	if( p == NULL )
		return NULL;

	if( !chk_flg( p->work.flg, FLG_WORK_ADJOIN ) )
		return NULL;
	p->work.flg &= FLG_WORK_ADJOIN;

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( abs( p->x - pty->mbr[i]->x ) > 1 )
			continue;
		if( abs( p->y - pty->mbr[i]->y ) > 1 )
			continue;

		/* Ĥ */
		p->flg_chr &= ~FLG_CHR_INVISIBLE;
		p->flg_chr |= FLG_CHR_FIND;
		draw_mnstr( p );

		chest = get_item( p->x, p->y );
		if( chest != NULL )
			lost_trgt( chest );

		catch_mbr( p, pty->mbr[i] );

		print_msg( FLG_NULL, MSG_MIMIC_FIND_MBR, p->name );

		return pty->mbr[i];
	}

	return NULL;
}

/**/

void	mnstr_mark_mbr_std( mnstr_t *p )
{
	party_t	*party;
	long	i;
	long	n;
	long	r;

	party = get_party();

	r = MAP_MAX_X + MAP_MAX_Y;
	n = -1;
	for( i = 0; i < MBR_MAX_N; i++ ){
		long	tmp_r;

		if( chk_flg_or( party->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		tmp_r = abs( party->mbr[i]->x - p->x )
				+ abs( party->mbr[i]->y - p->y );
		if( tmp_r < r ){
			n = i;
			r = tmp_r;
		}
	}
	if( n <= -1 )
		return;

	p->trgt.kind = TRGT_KIND_MBR;
	p->trgt.p = party->mbr[n];
	p->trgt.n = party->mbr[n]->mbr_n;
	p->trgt.x = party->mbr[n]->x;
	p->trgt.y = party->mbr[n]->y;
	p->trgt.true_x = p->trgt.x;
	p->trgt.true_y = p->trgt.y;
}

/**/

bool_t	chk_auto_door_mnstr( mnstr_t *p, long x1, long y1, long x2, long y2 )
{
	if( p->kind != CHR_KIND_MNSTR )
		return FALSE;

	if( chk_flg( p->flg_chr, FLG_CHR_CAN_OPEN_DOOR ) )
		return TRUE;

	return FALSE;
}

/**/

void	set_flg_find_all_mnstr( void )
{
	mnstr_t	*p;

	for( p = mnstr_used.next; (p != NULL) && (p != &mnstr_used);
			p = p->next ){
		set_flg_find_mnstr( p );
	}
}

/**/

bool_t	set_flg_find_mnstr( mnstr_t *p )
{
	long	i;
	dun_t	*dun;
	party_t	*pty;

	dun = get_dun();
	pty = get_party();

	if( p == NULL )
		return FALSE;

	p->flg_chr &= ~FLG_CHR_FIND;
	dun->map.chr.flg[p->y][p->x] = p->flg_chr;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_find_mnstr( pty->mbr[i], p ) ){
			p->flg_chr |= FLG_CHR_FIND;
			dun->map.chr.flg[p->y][p->x] = p->flg_chr;
			return TRUE;
		}
	}

	return FALSE;
}

/**/

bool_t	chk_find_mnstr( mbr_t *mbr, mnstr_t *mnstr )
{
	dun_t	*dun;
	party_t	*pty;
	pos_t	pos1, pos2;

	if( mnstr == NULL)
		return FALSE;
	if( mbr == NULL)
		return FALSE;

	dun = get_dun();
	pty = get_party();

	if( chk_flg( mnstr->flg_chr, FLG_CHR_INVISIBLE ) )
		return FALSE;
	if( chk_flg_or( mbr->stat,
			FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_BLIND
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		return FALSE;
	}
	if( abs( mnstr->x - mbr->x ) > MNSTR_MOVE_MAX_X )
		return FALSE;
	if( abs( mnstr->y - mbr->y ) > MNSTR_MOVE_MAX_Y )
		return FALSE;

	if( dun->map.light_depth[mnstr->y][mnstr->x] <= 0 )
		return FALSE;

	pos1.x = mbr->x;
	pos1.y = mbr->y;
	pos2.x = mnstr->x;
	pos2.y = mnstr->y;
	if( !chk_find( &pos1, &pos2 ) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	chk_adjoin_mnstr( long x, long y )
{
	dun_t	*dun;
	mnstr_t	*mnstr;

	dun = get_dun();

	do {
		if( dun->map.chr.mjr[y][x] != FACE_MJR_MNSTR_MAGICAL )
			break;
		if( dun->map.chr.mnr[y][x] != FACE_MNR_MNSTR_MIMIC )
			break;

		mnstr = get_mnstr( x, y );
		if( mnstr == NULL )
			break;
		if( mnstr->mnstr_kind != MNSTR_KIND_MIMIC )
			break;

		/* ߥߥåä */
		mnstr->work.flg |= FLG_WORK_ADJOIN;

		return TRUE;
	} while( 0 );

	return FALSE;
}

/**/

long	add_hp_mnstr( mnstr_t *mnstr, long n )
{
	long	pre_hp, add;

	if( mnstr == NULL )
		return 0;

	pre_hp = mnstr->abl.hp.n;

	mnstr->abl.hp.n += n;
	if( mnstr->abl.hp.n > mnstr->abl.hp.max )
		mnstr->abl.hp.n = mnstr->abl.hp.max;
	if( mnstr->abl.hp.n < 0 )
		mnstr->abl.hp.n = 0;

	add = mnstr->abl.hp.n - pre_hp;
	if( add != 0 )
		vfx_num( mnstr, add );

	if( mnstr->abl.hp.n <= 0 )
		die_chr( mnstr, TRUE );

	return mnstr->abl.hp.n;
}

/**/

void	die_mnstr( mnstr_t *p )
{
	release_mbr( p );

	ins_ls_mnstr( &mnstr_free, p );
}

/**/

void	set_find_all_mnstr( void )
{
	mnstr_t	*p;
	dun_t	*dun;

	dun = get_dun();

	for( p = mnstr_used.next;
			(p != NULL) && (p != &mnstr_used); p = p->next ){
		p->flg_chr |= FLG_CHR_FIND;
		dun->map.chr.flg[p->y][p->x] = p->flg_chr;
	}
}

/**/

mnstr_tab_t	*get_mnstr_tab( mnstr_kind_t mnstr_kind )
{
	long	n;
	
	for( n = 0; mnstr_tab[n].mnstr_kind != MNSTR_KIND_NULL; n++ ){
		if( mnstr_tab[n].mnstr_kind == mnstr_kind )
			return &mnstr_tab[n];
	}
	return NULL;
}

/**/

mnstr_tab_t	*get_mnstr_tab_rand( long dun_lev )
{
	long	i, n;
	mnstr_tab_t	*tab;

	n = 0;
	tab = NULL;
	for( i = 0; mnstr_tab[i].mnstr_kind != MNSTR_KIND_NULL; i++ ){
		if( abs( dun_lev ) < mnstr_tab[i].min_lev )
			continue;
		if( mnstr_tab[i].max_lev < abs( dun_lev ) )
			continue;
		if( sgn( dun_lev ) != mnstr_tab[i].sgn_lev )
			continue;

		n++;
		if( randm( n ) != 0 )
			continue;

		tab = &mnstr_tab[i];
	}

	return tab;
}

/**/

void	ins_ls_mnstr( mnstr_t *ls, mnstr_t *p )
{
	if( ls == NULL )
		return;
	if( ls->prev == NULL )
		return;
	if( ls->next == NULL )
		return;
	if( p == NULL )
		return;
	if( p->prev == NULL )
		return;
	if( p->next == NULL )
		return;

	p->next->prev = p->prev;
	p->prev->next = p->next;

	p->prev = ls->prev;
	p->next = ls;

	ls->prev->next = p;
	ls->prev = p;
}

/**/

mnstr_t	*get_mnstr( long x, long y )
{
	mnstr_t	*m;

	for( m = mnstr_used.next; m != &mnstr_used; m = m->next ){
		if( chk_flg( m->stat, FLG_STAT_DEAD ) )
			continue;
		if( (m->x == x) && (m->y == y) )
			return m;
	}

	return NULL;
}

/**/

mnstr_t	*get_mnstr_nearest( long x, long y )
{
	mnstr_t	*m, *ret_m;
	long	min_r, tmp_r;
	long	n;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_m = NULL;
	n = 0;
	for( m = mnstr_used.next; m != &mnstr_used; m = m->next ){
		if( !chk_flg( m->flg_chr, FLG_CHR_FIND ) )
			continue;
		if( chk_flg( m->stat, FLG_STAT_DEAD ) )
			continue;

		tmp_r = abs( m->x - x ) + abs( m->y - y );
		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			n++;
			if( randm( n ) != 0 )
				continue;
		} else {
			continue;
		}

		ret_m = m;
	}

	return ret_m;
}

/**/

mnstr_t	*get_mnstr_near( long x, long y )
{
	mnstr_t	*m, *ret_m;
	long	min_r, tmp_r;
	long	n;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_m = NULL;
	n = 0;
	for( m = mnstr_used.next; m != &mnstr_used; m = m->next ){
		if( !chk_flg( m->flg_chr, FLG_CHR_FIND ) )
			continue;
		if( chk_flg( m->stat, FLG_STAT_DEAD ) )
			continue;

		tmp_r = abs( m->x - x ) + abs( m->y - y );
		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( (tmp_r - min_r) <= MNSTR_NEAR_R ){
			n++;
			if( randm( n ) != 0 )
				continue;
		} else {
			continue;
		}

		ret_m = m;
	}

	return ret_m;
}

/**/

mnstr_t	*get_mnstr_disperse( mbr_t *mbr )
{
	mnstr_t	*m, *ret_m;
	long	min_r, tmp_r;
	long	n;
	long	x, y;

	x = mbr->x;
	y = mbr->y;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_m = NULL;
	n = 0;
	for( m = mnstr_used.next; m != &mnstr_used; m = m->next ){
		if( !chk_flg( m->flg_chr, FLG_CHR_FIND ) )
			continue;
		if( chk_flg( m->stat, FLG_STAT_DEAD ) )
			continue;

		tmp_r = abs( m->x - x ) + abs( m->y - y );
		if( tmp_r < min_r ){
			if( already_mark_mnstr( m, mbr ) )
				continue;
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			if( already_mark_mnstr( m, mbr ) )
				continue;
			n++;
			if( randm( n ) != 0 )
				continue;
		} else {
			continue;
		}

		ret_m = m;
	}

	return ret_m;
}

/**/

mnstr_t	*get_mnstr_randm( long x, long y )
{
	mnstr_t	*m, *ret_m;
	long	n;

	ret_m = NULL;
	n = 0;
	for( m = mnstr_used.next; m != &mnstr_used; m = m->next ){
		if( !chk_flg( m->flg_chr, FLG_CHR_FIND ) )
			continue;
		if( chk_flg( m->stat, FLG_STAT_DEAD ) )
			continue;

		n++;
		if( randm( n ) == 0 )
			ret_m = m;
	}

	return ret_m;
}

/**/

bool_t	already_mark_mnstr( mnstr_t *mnstr, mbr_t *mbr )
{
	party_t	*pty;
	long	i;

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( pty->mbr[i] == mbr )
			continue;

		if( pty->mbr[i]->trgt.p == ((void *)mnstr) )
			return TRUE;
	}

	return FALSE;
}

/**/

mnstr_t	*get_mnstr_rand( long x, long y )
{
	mnstr_t	*m;
	long	n, max_n, max_n2;

	max_n = 0;
	max_n2 = 0;
	for( m = mnstr_used.next; m != &mnstr_used; m = m->next ){
		if( !chk_flg( m->flg_chr, FLG_CHR_FIND ) )
			continue;
		if( chk_flg( m->stat, FLG_STAT_DEAD ) )
			continue;

		max_n++;

		if( (abs( m->x - x ) < 1) && (abs( m->y - y ) < 1) )
			max_n2++;
	}
	if( max_n <= 0 )
		return NULL;

	if( max_n2 == 0 ){
		n = randm( max_n ) + 1;
		for( m = mnstr_used.next; m != &mnstr_used; m = m->next ){
			if( !chk_flg( m->flg_chr, FLG_CHR_FIND ) )
				continue;
			if( chk_flg( m->stat, FLG_STAT_DEAD ) )
				continue;

			n--;
			if( n == 0 )
				return m;
		}
	} else {
		n = randm( max_n2 ) + 1;
		for( m = mnstr_used.next; m != &mnstr_used; m = m->next ){
			if( !chk_flg( m->flg_chr, FLG_CHR_FIND ) )
				continue;
			if( chk_flg( m->stat, FLG_STAT_DEAD ) )
				continue;

			if( (abs( m->x - x ) < 1) && (abs( m->y - y ) < 1) ){
				n--;
				if( n == 0 )
					return m;
			}
		}
	}

	return NULL;
}

/**/

mnstr_t	*get_mnstr_used( void )
{
	return &mnstr_used;
}

/**/

