/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
/*#include	"dun.h"*/
/*#include	"town.h"*/
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
#include	"menu.h"
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
#include	"item_prot.h"
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
/*#include	"fight_prot.h"*/
/*#include	"fx_prot.h"*/
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
#include	"menu_prot.h"
/*#include	"tmenu_prot.h"*/
#include	"amenu_prot.h"
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

long	auto_mark_cur_n;

mbr_t	*g_sel_mbr;

menu_t	ls_menu_auto_mark[1 + 1 + ((1 + 3) * AUTO_MARK_MAX_N) + 1];

menu_t	ls_menu_appoint_item[1 + 1 + (AUTO_MARK_APPOINT_ITEM_MAX_N * 2) + 1];

menu_t	ls_menu_auto_mark_edit[] = {
	{
		"/Edit",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_edit_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* Target */
	{
		"/Edit/Target",
		"<Branch>",
		'T',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_trgt_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Target/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Target/Monster",
		"<Item>",
		'X',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_MNSTR, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_MNSTR,
		FLG_NULL,
	},
	{
		"/Edit/Target/Item",
		"<Item>",
		'I',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_ITEM, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_ITEM,
		FLG_NULL,
	},
	{
		"/Edit/Target/Door",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_DOOR, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_DOOR,
		FLG_NULL,
	},
	{
		"/Edit/Target/Trap",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_TRAP, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_TRAP,
		FLG_NULL,
	},
	{
		"/Edit/Target/Member",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_MBR, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_MBR,
		FLG_NULL,
	},
	{
		"/Edit/Target/Unchange",
		"<Item>",
		'U',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_UNCHANGE, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_UNCHANGE,
		FLG_NULL,
	},
	{
		"/Edit/Target/Clear",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_CLEAR, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_CLEAR,
		FLG_NULL,
	},
/* Dist */
	{
		"/Edit/Dist",
		"<Branch>",
		'D',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_dist_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Dist/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Dist/Near",
		"<Item>",
		'N',
		"",
		N_MSG_MENU_AUTO_MARK_DIST_NEAR, "",
		cb_menu_auto_mark_dist, (void *)AUTO_MARK_DIST_NEAR,
		FLG_NULL,
	},
	{
		"/Edit/Dist/Medium",
		"<Item>",
		'M',
		"",
		N_MSG_MENU_AUTO_MARK_DIST_MEDIUM, "",
		cb_menu_auto_mark_dist, (void *)AUTO_MARK_DIST_MEDIUM,
		FLG_NULL,
	},
	{
		"/Edit/Dist/Far",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_AUTO_MARK_DIST_FAR, "",
		cb_menu_auto_mark_dist, (void *)AUTO_MARK_DIST_FAR,
		FLG_NULL,
	},
/* Action */
	{
		"/Edit/Action",
		"<Branch>",
		'A',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_act_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Action/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Action/Fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_FIGHT, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_FIGHT,
		FLG_NULL,
	},
	{
		"/Edit/Action/Throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_THROW, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_THROW,
		FLG_NULL,
	},
	{
		"/Edit/Action/Tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_TAIL, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_TAIL,
		FLG_NULL,
	},
	{
		"/Edit/Action/Pick up",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_PICK_UP, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_PICK_UP,
		FLG_NULL,
	},
	{
		"/Edit/Action/Open",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_OPEN, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_OPEN,
		FLG_NULL,
	},
	{
		"/Edit/Action/Close",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_CLOSE, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_CLOSE,
		FLG_NULL,
	},
	{
		"/Edit/Action/Jam",
		"<Item>",
		'J',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_JAM, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_JAM,
		FLG_NULL,
	},
	{
		"/Edit/Action/Disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_DISARM, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_DISARM,
		FLG_NULL,
	},
	{
		"/Edit/Action/Break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_BREAK, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_BREAK,
		FLG_NULL,
	},
	{
		"/Edit/Action/Peep",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_PEEP, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_PEEP,
		FLG_NULL,
	},
	{
		"/Edit/Action/Search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_SRCH, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_SRCH,
		FLG_NULL,
	},
/* Condition */
	{
		"/Edit/Condition",
		"<Branch>",
		'C',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_cond_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Nearest",
		"<Item>",
		'N',
		"",
		N_MSG_MENU_AUTO_MARK_COND_NEAREST, "",
		cb_menu_auto_mark_cond, (void *)AUTO_MARK_COND_NEAREST,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Disperse",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_AUTO_MARK_COND_DISPERSE, "",
		cb_menu_auto_mark_cond, (void *)AUTO_MARK_COND_DISPERSE,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Stagger",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_AUTO_MARK_COND_STAGGER, "",
		cb_menu_auto_mark_cond, (void *)AUTO_MARK_COND_STAGGER,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Own",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_AUTO_MARK_COND_OWN, "",
		cb_menu_auto_mark_cond, (void *)AUTO_MARK_COND_OWN,
		FLG_NULL,
	},
/* Appoint Item */
	{
		"/Edit/Appoint item",
		"<Branch>",
		'I',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_APPOINT_ITEM, "",
		cb_menu_auto_mark_appoint_item, NULL,
		FLG_NULL,
	},
/**/
	{
		"/Edit/Continue",
		"<CheckItem>",
		'O',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_CONT, "",
		cb_menu_auto_mark_cont, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Priority",
		"<CheckItem>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_PRIORITY, "",
		cb_menu_auto_mark_priority, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

/**/

void	init_auto_menu( void )
{
	auto_mark_cur_n = 0;
}

/**/

char	*menu_auto_mark( menu_t **pp, menu_t **dflt )
{
	*dflt = NULL;

	set_menu_auto_mark( dflt );

	*pp = ls_menu_auto_mark;

	return NULL;
}

/**/

void	set_menu_auto_mark( menu_t **dflt )
{
	menu_t	*p;
	long	i, k;

	p = ls_menu_auto_mark;
	k = 0;

	strncpy( p[k].path, "/Auto mark", MENU_PATH_MAX_LEN );
	strncpy( p[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	p[k].key = '\0';
	p[k].accel_key[0] = '\0';
	p[k].msg[0] = '\0';
	p[k].call_back = NULL;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	strncpy( p[k].path, "/Auto mark/Title", MENU_PATH_MAX_LEN );
	strncpy( p[k].kind, "<Title>", MENU_KIND_MAX_LEN );
	p[k].key = '\0';
	p[k].accel_key[0] = '\0';
	strncpy( p[k].msg, MSG_MENU_AUTO_MARK_TITLE,
			MENU_MSG_MAX_LEN );
	p[k].call_back = NULL;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < AUTO_MARK_MAX_N; i++ ){
		long	kk;

		kk = k;

		if( i == auto_mark_cur_n )
			*dflt = &(p[k]);

		sprintf( p[k].path, "/Auto mark/%ld", i );
		strncpy( p[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
		p[k].key = 'A' + i;
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, get_msg_ttl_auto_mark( i ),
				MENU_MSG_MAX_LEN );
		p[k].call_back = NULL;
		p[k].arg = NULL;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/Exec", p[kk].path );
		strncpy( p[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		p[k].key = 'X';
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, MSG_MENU_AUTO_MARK_EXEC,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_exec;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/Edit", p[kk].path );
		strncpy( p[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
		p[k].key = 'E';
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, MSG_MENU_AUTO_MARK_EDIT,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_edit;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/Arrange", p[kk].path );
		strncpy( p[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		p[k].key = 'A';
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, MSG_MENU_AUTO_MARK_ARRANGE,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_arrange;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;
	}
	p[k].path[0] = '\0';
}

/**/

char	*cb_menu_auto_mark_exec( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	long	n;
	long	i;

	n = (long)((*pp)->arg);
	if( auto_mark_cur_n != n ){
		auto_mark_cur_n = n;

		for( i = 0; i < MBR_MAX_N; i++ ){
			set_auto_mark_cont( pty->mbr[i] );
		}
	}

	for( i = 0; i < MBR_MAX_N; i++ )
		exec_menu_auto_mark( pty->mbr[i] );

	return NULL;
}

/**/

void	set_auto_mark_cont( mbr_t *mbr )
{
	if( mbr == NULL )
		return;

	if( !chk_flg( mbr->auto_mark[auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_PRIORITY ) ){
		return;
	}

	mbr->flg_chr &= ~(FLG_CHR_AUTO_MARK_CONT);
}

/**/

bool_t	exec_menu_auto_mark( mbr_t *mbr )
{
	auto_mark_t	*am;
	bool_t	flg_clr;

	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	am = &(mbr->auto_mark[auto_mark_cur_n]);

	/* $B$9$G$K%^!<%/$7$F$$$k$+!)(B */
	if( !chk_flg( am->flg, FLG_AUTO_MARK_EDIT_PRIORITY ) )
		if( mbr->act.kind != ACT_KIND_NULL )
			return FALSE;

	flg_clr = FALSE;
	switch( am->trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		if( !exec_menu_auto_mark_mnstr( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_ITEM:
		if( !exec_menu_auto_mark_item( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_DOOR:
		if( !exec_menu_auto_mark_door( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_TRAP:
		break;
	case AUTO_MARK_TRGT_MBR:
		if( !exec_menu_auto_mark_mbr( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
		return TRUE;
	case AUTO_MARK_TRGT_CLEAR:
		flg_clr = TRUE;
		break;
	}

	if( flg_clr )
		clr_chr_trgt_act( mbr, TRUE );

	if( chk_flg( mbr->auto_mark[auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_CONT ) ){
		mbr->flg_chr |= FLG_CHR_AUTO_MARK_CONT;
	} else {
		mbr->flg_chr &= ~(FLG_CHR_AUTO_MARK_CONT);
	}

	return TRUE;
}

/**/

bool_t	exec_menu_auto_mark_mnstr( mbr_t *mbr )
{
	auto_mark_t	*am;
	mnstr_t	*mnstr;
	dist_t	dist;
	act_kind_t	act_kind;
	char	*act_msg;

	am = &(mbr->auto_mark[auto_mark_cur_n]);

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
		act_kind = ACT_KIND_MNSTR_FIGHT;
		act_msg = MSG_ACT_MNSTR_FIGHT;
		break;
	case AUTO_MARK_ACT_THROW:
		act_kind = ACT_KIND_MNSTR_THROW;
		act_msg = MSG_ACT_MNSTR_THROW;
		break;
	case AUTO_MARK_ACT_TAIL:
		act_kind = ACT_KIND_MNSTR_TAIL;
		act_msg = MSG_ACT_MNSTR_TAIL;
		break;
	case AUTO_MARK_ACT_PICK_UP:
	case AUTO_MARK_ACT_OPEN:
	case AUTO_MARK_ACT_CLOSE:
	case AUTO_MARK_ACT_JAM:
	case AUTO_MARK_ACT_DISARM:
	case AUTO_MARK_ACT_BREAK:
	case AUTO_MARK_ACT_PEEP:
	case AUTO_MARK_ACT_SRCH:
	default:
		return FALSE;
	}

	/* $B%b%s%9%?!<$rC5$9(B */
	mnstr = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		mnstr = get_mnstr_nearest( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_DISPERSE:
		mnstr = get_mnstr_disperse( mbr );
		if( mnstr == NULL )
			mnstr = get_mnstr_randm( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_STAGGER:
	case AUTO_MARK_COND_OWN:
		return FALSE;
	}
	if( mnstr == NULL )
		return FALSE;

	/* $B4V9g$$$r%;%C%H(B */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	/* $B%"%/%7%g%s$r%;%C%H(B */
	mbr->act.kind = act_kind;
	strncpy( mbr->act.msg, act_msg, ACT_MSG_MAX_LEN );
	mbr->act.p = NULL;
	mbr->act.n = 0;
	mbr->act.dflt_kind_mnstr = mbr->act.kind;
	strncpy( mbr->act.dflt_msg_mnstr, mbr->act.msg, ACT_MSG_MAX_LEN );

	/* $B%b%s%9%?!<$r%^!<%/$9$k(B */
	mark_mnstr( mbr, mnstr, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

bool_t	exec_menu_auto_mark_item( mbr_t *mbr )
{
	auto_mark_t	*am;
	item_t	*item;
	dist_t	dist;
	act_kind_t	act_kind;
	char	*act_msg;

	am = &(mbr->auto_mark[auto_mark_cur_n]);

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
	case AUTO_MARK_ACT_THROW:
	case AUTO_MARK_ACT_TAIL:
		return FALSE;
	case AUTO_MARK_ACT_PICK_UP:
		act_kind = ACT_KIND_ITEM_PICK_UP;
		act_msg = MSG_ACT_ITEM_PICK_UP;
		break;
	case AUTO_MARK_ACT_OPEN:
		act_kind = ACT_KIND_ITEM_OPEN;
		act_msg = MSG_ACT_ITEM_OPEN;
		break;
	case AUTO_MARK_ACT_CLOSE:
	case AUTO_MARK_ACT_JAM:
		return FALSE;
	case AUTO_MARK_ACT_DISARM:
		act_kind = ACT_KIND_ITEM_DISARM;
		act_msg = MSG_ACT_ITEM_DISARM;
		break;
	case AUTO_MARK_ACT_BREAK:
		act_kind = ACT_KIND_ITEM_BREAK;
		act_msg = MSG_ACT_ITEM_BREAK;
		break;
	case AUTO_MARK_ACT_PEEP:
		return FALSE;
	case AUTO_MARK_ACT_SRCH:
		act_kind = ACT_KIND_ITEM_SRCH;
		act_msg = MSG_ACT_ITEM_SRCH;
		break;
	default:
		return FALSE;
	}

	/* $B%"%$%F%`$rC5$9(B */
	item = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		item = get_item_nearest( mbr, act_kind, TRUE );
		break;
	case AUTO_MARK_COND_DISPERSE:
		item = get_item_disperse( mbr, act_kind, TRUE );
		if( item == NULL )
			item = get_item_randm( mbr, act_kind, TRUE );
		break;
	case AUTO_MARK_COND_STAGGER:
		return FALSE;
	case AUTO_MARK_COND_OWN:
		item = get_item_own( mbr, act_kind, TRUE );
		break;
	}
	if( item == NULL )
		return FALSE;

	/* $B4V9g$$$r%;%C%H(B */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	/* $B%"%/%7%g%s$r%;%C%H(B */
	mbr->act.kind = act_kind;
	strncpy( mbr->act.msg, act_msg, ACT_MSG_MAX_LEN );
	mbr->act.p = NULL;
	mbr->act.n = 0;

	/* $B%"%$%F%`$r%^!<%/$9$k(B */
	mark_item( mbr, item, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

bool_t	exec_menu_auto_mark_door( mbr_t *mbr )
{
	auto_mark_t	*am;
	door_t	*door;
	dist_t	dist;
	act_kind_t	act_kind;
	char	*act_msg;

	am = &(mbr->auto_mark[auto_mark_cur_n]);

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
	case AUTO_MARK_ACT_THROW:
	case AUTO_MARK_ACT_TAIL:
	case AUTO_MARK_ACT_PICK_UP:
		return FALSE;
	case AUTO_MARK_ACT_OPEN:
		act_kind = ACT_KIND_DOOR_OPEN;
		act_msg = MSG_ACT_DOOR_OPEN;
		break;
	case AUTO_MARK_ACT_CLOSE:
		act_kind = ACT_KIND_DOOR_CLOSE;
		act_msg = MSG_ACT_DOOR_CLOSE;
		break;
	case AUTO_MARK_ACT_JAM:
		act_kind = ACT_KIND_DOOR_JAM;
		act_msg = MSG_ACT_DOOR_JAM;
		break;
	case AUTO_MARK_ACT_DISARM:
		act_kind = ACT_KIND_DOOR_DISARM;
		act_msg = MSG_ACT_DOOR_DISARM;
		break;
	case AUTO_MARK_ACT_BREAK:
		act_kind = ACT_KIND_DOOR_BREAK;
		act_msg = MSG_ACT_DOOR_BREAK;
		break;
	case AUTO_MARK_ACT_PEEP:
		act_kind = ACT_KIND_DOOR_PEEP;
		act_msg = MSG_ACT_DOOR_PEEP;
		break;
	case AUTO_MARK_ACT_SRCH:
		act_kind = ACT_KIND_DOOR_SRCH;
		act_msg = MSG_ACT_DOOR_SRCH;
		break;
	default:
		return FALSE;
	}

	/* $B%I%"$rC5$9(B */
	door = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		door = get_door_nearest( mbr->x, mbr->y, act_kind );
		break;
	case AUTO_MARK_COND_DISPERSE:
		door = get_door_disperse( mbr, act_kind );
		if( door == NULL )
			door = get_door_randm( mbr->x, mbr->y, act_kind );
		break;
	case AUTO_MARK_COND_STAGGER:
	case AUTO_MARK_COND_OWN:
		return FALSE;
	}
	if( door == NULL )
		return FALSE;

	/* $B4V9g$$$r%;%C%H(B */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	/* $B%"%/%7%g%s$r%;%C%H(B */
	mbr->act.kind = act_kind;
	strncpy( mbr->act.msg, act_msg, ACT_MSG_MAX_LEN );
	mbr->act.p = NULL;
	mbr->act.n = 0;

	/* $B%I%"$r%^!<%/$9$k(B */
	mark_door( mbr, door, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

bool_t	exec_menu_auto_mark_mbr( mbr_t *mbr )
{
	auto_mark_t	*am;
	mbr_t	*p;
	dist_t	dist;
	act_kind_t	act_kind;
	char	*act_msg;

	am = &(mbr->auto_mark[auto_mark_cur_n]);

	/* $B%a%s%P!<$rC5$9(B */
	p = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		p = get_mbr_nearest( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_DISPERSE:
		p = get_mbr_disperse( mbr );
		if( p == NULL )
			p = get_mbr_randm( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_STAGGER:
		p = get_mbr_stagger( mbr );
		break;
	case AUTO_MARK_COND_OWN:
		return FALSE;
	}
	if( p == NULL )
		return FALSE;

	/* $B4V9g$$$r%;%C%H(B */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
		act_kind = ACT_KIND_MBR_FIGHT;
		act_msg = MSG_ACT_MBR_FIGHT;
		break;
	case AUTO_MARK_ACT_THROW:
		act_kind = ACT_KIND_MBR_THROW;
		act_msg = MSG_ACT_MBR_THROW;
		break;
	case AUTO_MARK_ACT_TAIL:
		act_kind = ACT_KIND_MBR_TAIL;
		act_msg = MSG_ACT_MBR_TAIL;
		break;
	case AUTO_MARK_ACT_PICK_UP:
	case AUTO_MARK_ACT_OPEN:
	case AUTO_MARK_ACT_CLOSE:
	case AUTO_MARK_ACT_JAM:
	case AUTO_MARK_ACT_DISARM:
	case AUTO_MARK_ACT_BREAK:
	case AUTO_MARK_ACT_PEEP:
	case AUTO_MARK_ACT_SRCH:
		return FALSE;
	default:
		return FALSE;
	}

	/* $B%"%/%7%g%s$r%;%C%H(B */
	mbr->act.kind = act_kind;
	strncpy( mbr->act.msg, act_msg, ACT_MSG_MAX_LEN );
	mbr->act.p = NULL;
	mbr->act.n = 0;

	/* $B%a%s%P!<$r%^!<%/$9$k(B */
	mark_mbr( mbr, p, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

char	*cb_menu_auto_mark_edit( menu_t **pp, menu_t **dflt )
{
	char	*str_goto;

	auto_mark_cur_n = (long)((*pp)->arg);

	while( 1 ){
		str_goto = exec_menu_sel_mbr( &g_sel_mbr, NULL, TRUE );
		if( str_goto != NULL )
			return str_goto;

		while( 1 ){
			str_goto = exec_menu(
					ls_menu_auto_mark_edit,
					NULL, NULL );
			if( str_goto == NULL )
				continue;
			if( strcmp( str_goto, STR_MENU_ERR ) == 0 )
				return STR_MENU_ERR;
			if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 )
				break;
		}
	}

	return STR_MENU_ERR;
}

/**/

char	*cb_menu_auto_mark_edit_init(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*p;

	/* $B%?%$%H%k(B */
	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_EDIT,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	/* $BBP>](B */
	p = srch_menu( *pp, "Target" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_TRGT,
			get_msg_menu_auto_mark_edit_trgt( g_sel_mbr ) );

	/* $B4V9g$$(B */
	p = srch_menu( *pp, "Dist" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_DIST,
			get_msg_menu_auto_mark_edit_dist( g_sel_mbr ) );

	/* $B9TF0(B */
	p = srch_menu( *pp, "Action" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_ACT,
			get_msg_menu_auto_mark_edit_act( g_sel_mbr ) );

	/* $B>r7o(B */
	p = srch_menu( *pp, "Condition" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_COND,
			get_msg_menu_auto_mark_edit_cond( g_sel_mbr ) );

	/* $B%"%$%F%`<oJL(B */
	if( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_ITEM ){
		clr_flg_menu( *pp, "Appoint item", FLG_MENU_HIDDEN );
	} else {
		set_flg_menu( *pp, "Appoint item", FLG_MENU_HIDDEN );
	}

	/* $BO"B3%^!<%/(B */
	if( chk_flg( g_sel_mbr->auto_mark[auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_CONT ) ){
		set_chk_on_menu( *pp, "Continue" );
	} else {
		set_chk_off_menu( *pp, "Continue" );
	}

	/* $B8=:_$N@_Dj$h$jM%@h(B */
	if( chk_flg( g_sel_mbr->auto_mark[auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_PRIORITY ) ){
		set_chk_on_menu( *pp, "Priority" );
	} else {
		set_chk_off_menu( *pp, "Priority" );
	}

	return NULL;
}

/**/

char	*cb_menu_auto_mark_trgt_init(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*p;
	char	*s;

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_TRGT,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	s = NULL;
	switch( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		s = "Monster";
		break;
	case AUTO_MARK_TRGT_ITEM:
		s = "Item";
		break;
	case AUTO_MARK_TRGT_DOOR:
		s = "Door";
		break;
	case AUTO_MARK_TRGT_TRAP:
		s = "Trap";
		break;
	case AUTO_MARK_TRGT_MBR:
		s = "Member";
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
		s = "Unchange";
		break;
	case AUTO_MARK_TRGT_CLEAR:
		s = "Clear";
		break;
	}

	*dflt = srch_menu( *pp, s );

	return NULL;
}

/**/

char	*cb_menu_auto_mark_trgt( menu_t **pp, menu_t **dflt )
{
	auto_mark_trgt_t	trgt;

	trgt = (auto_mark_trgt_t)((*pp)->arg);
	g_sel_mbr->auto_mark[auto_mark_cur_n].trgt = trgt;

	switch( trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		g_sel_mbr->auto_mark[auto_mark_cur_n].act
				= AUTO_MARK_ACT_FIGHT;
		break;
	case AUTO_MARK_TRGT_ITEM:
		g_sel_mbr->auto_mark[auto_mark_cur_n].act
				= AUTO_MARK_ACT_PICK_UP;
		break;
	case AUTO_MARK_TRGT_DOOR:
		g_sel_mbr->auto_mark[auto_mark_cur_n].act
				= AUTO_MARK_ACT_OPEN;
		break;
	case AUTO_MARK_TRGT_TRAP:
		g_sel_mbr->auto_mark[auto_mark_cur_n].act
				= AUTO_MARK_ACT_DISARM;
		break;
	case AUTO_MARK_TRGT_MBR:
		g_sel_mbr->auto_mark[auto_mark_cur_n].act
				= AUTO_MARK_ACT_TAIL;
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
	case AUTO_MARK_TRGT_CLEAR:
		break;
	}

	return NULL;
}

/**/

char	*cb_menu_auto_mark_dist_init(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*p;
	char	*s;

	if( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_UNCHANGE ){
		return STR_MENU_CANCEL;
	}
	if( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_CLEAR ){
		return STR_MENU_CANCEL;
	}

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_DIST,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	s = NULL;
	switch( g_sel_mbr->auto_mark[auto_mark_cur_n].dist ){
	case AUTO_MARK_DIST_NEAR:
		s = "Near";
		break;
	case AUTO_MARK_DIST_MEDIUM:
		s = "Medium";
		break;
	case AUTO_MARK_DIST_FAR:
		s = "Far";
		break;
	}

	*dflt = srch_menu( *pp, s );

	return NULL;
}

/**/

char	*cb_menu_auto_mark_dist( menu_t **pp, menu_t **dflt )
{
	g_sel_mbr->auto_mark[auto_mark_cur_n].dist
			= (auto_mark_dist_t)((*pp)->arg);

	return NULL;
}

/**/

char	*cb_menu_auto_mark_act_init( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;
	char	*s;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	if( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_UNCHANGE ){
		return STR_MENU_CANCEL;
	}
	if( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_CLEAR ){
		return STR_MENU_CANCEL;
	}

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_ACT,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	s = NULL;
	switch( g_sel_mbr->auto_mark[auto_mark_cur_n].act ){
	case AUTO_MARK_ACT_FIGHT:
		s = "Fight";
		break;
	case AUTO_MARK_ACT_THROW:
		s = "Throw";
		break;
	case AUTO_MARK_ACT_TAIL:
		s = "Tail";
		break;
	case AUTO_MARK_ACT_PICK_UP:
		s = "Pick up";
		break;
	case AUTO_MARK_ACT_OPEN:
		s = "Open";
		break;
	case AUTO_MARK_ACT_CLOSE:
		s = "Close";
		break;
	case AUTO_MARK_ACT_JAM:
		s = "Jam";
		break;
	case AUTO_MARK_ACT_DISARM:
		s = "Disarm";
		break;
	case AUTO_MARK_ACT_BREAK:
		s = "Break";
		break;
	case AUTO_MARK_ACT_PEEP:
		s = "Peep";
		break;
	case AUTO_MARK_ACT_SRCH:
		s = "Search";
		break;
	}

	*dflt = srch_menu( *pp, s );

	/* $BBP>]$K1~$8$F%a%K%e!<9`L\$NL58z2=(B */

	switch( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		set_flg_menu( *pp, "Pick up", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Open", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Disarm", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Break", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Peep", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Search", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_ITEM:
		set_flg_menu( *pp, "Fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Throw", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Tail", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Peep", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_DOOR:
		set_flg_menu( *pp, "Fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Throw", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Tail", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Pick up", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_TRAP:
		set_flg_menu( *pp, "Fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Throw", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Tail", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Pick up", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Open", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Peep", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_MBR:
		set_flg_menu( *pp, "Pick up", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Open", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Disarm", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Break", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Peep", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Search", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
	case AUTO_MARK_TRGT_CLEAR:
		return STR_MENU_CANCEL;
	}

	if( chk_flg( (*dflt)->flg, FLG_MENU_HIDDEN ) )
		*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_auto_mark_act( menu_t **pp, menu_t **dflt )
{
	g_sel_mbr->auto_mark[auto_mark_cur_n].act
			= (auto_mark_act_t)((*pp)->arg);

	return NULL;
}

/**/

char	*cb_menu_auto_mark_cond_init(
	menu_t **pp, menu_t **dflt
)
{
	char	*s;
	menu_t	*p;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	if( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_UNCHANGE ){
		return STR_MENU_CANCEL;
	}
	if( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_CLEAR ){
		return STR_MENU_CANCEL;
	}

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_COND,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	/* $B%G%U%)%k%H$N%+!<%=%k0LCV@_Dj(B */

	s = NULL;
	switch( g_sel_mbr->auto_mark[auto_mark_cur_n].cond ){
	case AUTO_MARK_COND_NEAREST:
		s = "Nearest";
		break;
	case AUTO_MARK_COND_DISPERSE:
		s = "Disperse";
		break;
	case AUTO_MARK_COND_STAGGER:
		s = "Stagger";
		break;
	case AUTO_MARK_COND_OWN:
		s = "Own";
		break;
	}
	*dflt = srch_menu( *pp, s );

	/* $BBP>]$K1~$8$F%a%K%e!<9`L\$NL58z2=(B */

	switch( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_DOOR:
	case AUTO_MARK_TRGT_TRAP:
	case AUTO_MARK_TRGT_MNSTR:
		set_flg_menu( *pp, "Stagger", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Own", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_ITEM:
		set_flg_menu( *pp, "Stagger", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_MBR:
		set_flg_menu( *pp, "Own", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
	case AUTO_MARK_TRGT_CLEAR:
		return STR_MENU_ERR;
	}

	if( (*dflt != NULL) && chk_flg( (*dflt)->flg, FLG_MENU_HIDDEN ) )
		*dflt = NULL;

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_ACT,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	return NULL;
}

/**/

char	*cb_menu_auto_mark_cond( menu_t **pp, menu_t **dflt )
{
	switch( (auto_mark_cond_t)((*pp)->arg) ){
	case AUTO_MARK_COND_NEAREST:
		g_sel_mbr->auto_mark[auto_mark_cur_n].cond
				= AUTO_MARK_COND_NEAREST;
		break;
	case AUTO_MARK_COND_DISPERSE:
		g_sel_mbr->auto_mark[auto_mark_cur_n].cond
				= AUTO_MARK_COND_DISPERSE;
		break;
	case AUTO_MARK_COND_STAGGER:
		g_sel_mbr->auto_mark[auto_mark_cur_n].cond
				= AUTO_MARK_COND_STAGGER;
		break;
	case AUTO_MARK_COND_OWN:
		g_sel_mbr->auto_mark[auto_mark_cur_n].cond
				= AUTO_MARK_COND_OWN;
		break;
	}

	return NULL;
}

/**/

char	*cb_menu_auto_mark_appoint_item(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*ls;
	long	k;
	auto_mark_appoint_item_t	*apo;
	long	i;

	if( g_sel_mbr->auto_mark[auto_mark_cur_n].trgt
			!= AUTO_MARK_TRGT_ITEM ){
		return STR_MENU_CANCEL;
	}

	ls = ls_menu_appoint_item;
	k = 0;

	strncpy( ls[k].path, "/Appoint item",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Appoint item/Title",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Title>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	sprintf( ls[k].msg, MSG_TTL_MENU_AUTO_MARK_APPOINT_ITEM_MJR,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	apo = get_auto_mark_appoint_item( g_sel_mbr );
	if( apo == NULL )
		return STR_MENU_ERR;

	for( i = 0; i < 1024; i++ ){
		char	*ret;

		if( apo->mjr == FACE_MJR_NULL )
			break;

		ret = set_menu_auto_mark_appoint_item(
				ls, &k, 'A' + i, &apo );
		if( ret != NULL )
			return ret;
	}
	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/**/

char	*set_menu_auto_mark_appoint_item(
	menu_t *ls, long *k, char mjr_key,
	auto_mark_appoint_item_t **apo
)
{
	char	mjr;
	char	mnr_key;

	mjr = (*apo)->mjr;

	sprintf( ls[*k].path, "/Appoint item/%c", mjr );
	strncpy( ls[*k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[*k].key = mjr_key;
	ls[*k].accel_key[0] = '\0';
	ls[*k].n_msg = N_MSG_NULL;
	strncpy( ls[*k].msg, get_item_mjr_name( mjr ),
			MENU_MSG_MAX_LEN );
	ls[*k].call_back = cb_menu_auto_mark_appoint_item_init;
	ls[*k].arg = (void *)(*apo);
	ls[*k].flg = FLG_NULL;
	(*k)++;

	mnr_key = 'A';
	for( ; (*apo)->mjr != FACE_MJR_NULL; (*apo)++ ){
		if( (*apo)->mjr != mjr )
			break;

		sprintf( ls[*k].path, "/Appoint item/%c/%c",
				(*apo)->mjr, (*apo)->mnr );
		strncpy( ls[*k].kind, "<CheckItem>",
				MENU_KIND_MAX_LEN );
		ls[*k].key = mnr_key;
		ls[*k].accel_key[0] = '\0';
		ls[*k].n_msg = N_MSG_NULL;
		strncpy( ls[*k].msg, get_item_mnr_name( mjr, (*apo)->mnr ),
				MENU_MSG_MAX_LEN );
		ls[*k].call_back = cb_menu_auto_mark_appoint_item_mnr;
		ls[*k].arg = (void *)(*apo);
		ls[*k].flg = FLG_NULL;
		(*k)++;

		mnr_key++;
	}

	return NULL;
}

/**/

char	*cb_menu_auto_mark_appoint_item_init(
	menu_t **pp, menu_t **dflt
)
{
	auto_mark_appoint_item_t	*apo;
	char	mjr;
	char	sub_path[MENU_PATH_MAX_LEN + 1];

	apo = (auto_mark_appoint_item_t *)((*pp)->arg);
	mjr = apo->mjr;

	for( ; apo->mjr != FACE_MJR_NULL; apo++ ){
		if( apo->mjr != mjr )
			break;

		sprintf( sub_path, "%c", apo->mnr );
		if( apo->flg_ena )
			set_chk_on_menu( *pp, sub_path );
		else
			set_chk_off_menu( *pp, sub_path );
	}

	return NULL;
}

/**/

char	*cb_menu_auto_mark_appoint_item_mnr(
	menu_t **pp, menu_t **dflt
)
{
	auto_mark_appoint_item_t	*apo;

	apo = (auto_mark_appoint_item_t *)((*pp)->arg);
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		apo->flg_ena = TRUE;
	else
		apo->flg_ena = FALSE;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_auto_mark_cont( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) ){
		g_sel_mbr->auto_mark[auto_mark_cur_n].flg
				|= FLG_AUTO_MARK_EDIT_CONT;
	} else {
		g_sel_mbr->auto_mark[auto_mark_cur_n].flg
				&= ~(FLG_AUTO_MARK_EDIT_CONT);
	}

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_auto_mark_priority( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) ){
		g_sel_mbr->auto_mark[auto_mark_cur_n].flg
				|= FLG_AUTO_MARK_EDIT_PRIORITY;
	} else {
		g_sel_mbr->auto_mark[auto_mark_cur_n].flg
				&= ~(FLG_AUTO_MARK_EDIT_PRIORITY);
	}

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_auto_mark_arrange( menu_t **pp, menu_t **dflt )
{
	mbr_t	**ls_mbr = get_ls_mbr();
	long	n, i, j;
	auto_mark_t	am;
	char	buf[MSG_TTL_AUTO_MARK_MAX_LEN + 1];

	n = (long)((*pp)->arg);

	/**/

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		am = ls_mbr[i]->auto_mark[n];

		for( j = n - 1; j >= 0; j-- ){
			ls_mbr[i]->auto_mark[j + 1]
					= ls_mbr[i]->auto_mark[j];
		}

		ls_mbr[i]->auto_mark[0] = am;
	}

	/**/

	strncpy( buf, get_msg_ttl_auto_mark( n ),
			MSG_TTL_AUTO_MARK_MAX_LEN );

	for( j = n - 1; j >= 0; j-- ){
		strncpy( get_msg_ttl_auto_mark( j + 1 ),
				get_msg_ttl_auto_mark( j ),
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	strncpy( get_msg_ttl_auto_mark( 0 ), buf,
			MSG_TTL_AUTO_MARK_MAX_LEN );

	/**/

	set_menu_auto_mark( dflt );
	auto_mark_cur_n = 0;

	return "/Auto mark/0";
}

/**/

char	*get_msg_menu_auto_mark_edit_trgt( mbr_t *mbr )
{
	switch( mbr->auto_mark[auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		return MSG_MENU_AUTO_MARK_TRGT_MNSTR;
	case AUTO_MARK_TRGT_ITEM:
		return MSG_MENU_AUTO_MARK_TRGT_ITEM;
	case AUTO_MARK_TRGT_DOOR:
		return MSG_MENU_AUTO_MARK_TRGT_DOOR;
	case AUTO_MARK_TRGT_TRAP:
		return MSG_MENU_AUTO_MARK_TRGT_TRAP;
	case AUTO_MARK_TRGT_MBR:
		return MSG_MENU_AUTO_MARK_TRGT_MBR;
	case AUTO_MARK_TRGT_UNCHANGE:
		return MSG_MENU_AUTO_MARK_TRGT_UNCHANGE;
	case AUTO_MARK_TRGT_CLEAR:
		return MSG_MENU_AUTO_MARK_TRGT_CLEAR;
	}

	return MSG_NOT_NULL;
}

/**/

char	*get_msg_menu_auto_mark_edit_dist( mbr_t *mbr )
{
	auto_mark_trgt_t	trgt;

	trgt = mbr->auto_mark[auto_mark_cur_n].trgt;
	if( (trgt == AUTO_MARK_TRGT_UNCHANGE)
			|| (trgt ==AUTO_MARK_TRGT_CLEAR) ){
		return MSG_MENU_AUTO_MARK_INVALID;
	}

	switch( mbr->auto_mark[auto_mark_cur_n].dist ){
	case AUTO_MARK_DIST_NEAR:
		return MSG_MENU_AUTO_MARK_DIST_NEAR;
	case AUTO_MARK_DIST_MEDIUM:
		return MSG_MENU_AUTO_MARK_DIST_MEDIUM;
	case AUTO_MARK_DIST_FAR:
		return MSG_MENU_AUTO_MARK_DIST_FAR;
	}

	return MSG_NOT_NULL;
}

/**/

char	*get_msg_menu_auto_mark_edit_act( mbr_t *mbr )
{
	auto_mark_trgt_t	trgt;

	trgt = mbr->auto_mark[auto_mark_cur_n].trgt;
	if( (trgt == AUTO_MARK_TRGT_UNCHANGE)
			|| (trgt ==AUTO_MARK_TRGT_CLEAR) ){
		return MSG_MENU_AUTO_MARK_INVALID;
	}

	switch( mbr->auto_mark[auto_mark_cur_n].act ){
	case AUTO_MARK_ACT_FIGHT:
		return MSG_MENU_AUTO_MARK_ACT_FIGHT;
	case AUTO_MARK_ACT_THROW:
		return MSG_MENU_AUTO_MARK_ACT_THROW;
	case AUTO_MARK_ACT_TAIL:
		return MSG_MENU_AUTO_MARK_ACT_TAIL;
	case AUTO_MARK_ACT_PICK_UP:
		return MSG_MENU_AUTO_MARK_ACT_PICK_UP;
	case AUTO_MARK_ACT_OPEN:
		return MSG_MENU_AUTO_MARK_ACT_OPEN;
	case AUTO_MARK_ACT_CLOSE:
		return MSG_MENU_AUTO_MARK_ACT_CLOSE;
	case AUTO_MARK_ACT_JAM:
		return MSG_MENU_AUTO_MARK_ACT_JAM;
	case AUTO_MARK_ACT_DISARM:
		return MSG_MENU_AUTO_MARK_ACT_DISARM;
	case AUTO_MARK_ACT_BREAK:
		return MSG_MENU_AUTO_MARK_ACT_BREAK;
	case AUTO_MARK_ACT_PEEP:
		return MSG_MENU_AUTO_MARK_ACT_PEEP;
	case AUTO_MARK_ACT_SRCH:
		return MSG_MENU_AUTO_MARK_ACT_SRCH;
	}

	return MSG_NOT_NULL;
}

/**/

char	*get_msg_menu_auto_mark_edit_cond( mbr_t *mbr )
{
	auto_mark_trgt_t	trgt;

	trgt = mbr->auto_mark[auto_mark_cur_n].trgt;
	if( (trgt == AUTO_MARK_TRGT_UNCHANGE)
			|| (trgt ==AUTO_MARK_TRGT_CLEAR) ){
		return MSG_MENU_AUTO_MARK_INVALID;
	}

	switch( mbr->auto_mark[auto_mark_cur_n].cond ){
	case AUTO_MARK_COND_NEAREST:
		return MSG_MENU_AUTO_MARK_COND_NEAREST;
	case AUTO_MARK_COND_DISPERSE:
		return MSG_MENU_AUTO_MARK_COND_DISPERSE;
	case AUTO_MARK_COND_STAGGER:
		return MSG_MENU_AUTO_MARK_COND_STAGGER;
	case AUTO_MARK_COND_OWN:
		return MSG_MENU_AUTO_MARK_COND_OWN;
	}

	return MSG_NOT_NULL;
}

/**/

long	get_auto_mark_cur_n( void )
{
	return auto_mark_cur_n;
}

/**/

