/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: party.h,v 1.24 2009/05/29 01:51:16 bowkenken Exp $
***************************************************************/

#ifndef	PARTY_H
#define	PARTY_H

/* ѡƥȥС */

#include	"chr.h"

/* С */

enum {
	LS_MBR_N_BLADE,
	LS_MBR_N_DRANK,
	LS_MBR_N_ELSIE,
	LS_MBR_N_CECILE,
	LS_MBR_N_HALLE,
	LS_MBR_N_BEAUT,
	LS_MBR_N_GOKOU,
	LS_MBR_N_EYE,
};

#define	MBR_MAX_N	6	/*  */
#define	MBR_N_NOT_JOIN	(-1)	/* ѡƥ˲ääƤʤ */
#define	MBR_NO_POS	(-1)	/* ե᡼ζ */

/* ѡƥ */

#define	LS_MBR_MAX_N	64	/* СκϿ */

typedef unsigned long	flg_party_t;
#define	FLG_PARTY_ACTUAL_FIGHTING	(1 << 0)
#define	FLG_PARTY_SRCH_AUTO_OFF	(1 << 1)

typedef chr_t	mbr_t;

/* 󥫡(ѡƥΰư濴) */

typedef enum {
	SQUARE_DIR_NORTH,
	SQUARE_DIR_EAST,
	SQUARE_DIR_SOUTH,
	SQUARE_DIR_WEST,
	SQUARE_DIR_MAX_N,
} square_dir_t;

typedef struct {
	/* ɸ */
	long	x, y;
	/* 1κɸ */
	long	pre_x, pre_y;
	/* Ƥ */
	square_dir_t	dir;
	/* 1θƤ */
	square_dir_t	pre_dir;

	/* Ƥθ */
	long	chr_pos_n[SQUARE_HEIGHT][SQUARE_WIDTH];

	/* ºݤθ */
	long	chr_dir[SQUARE_HEIGHT][SQUARE_WIDTH];

	/* 饯Υ󥫡кɸ (Υ󥫡) */
	pos_t	chr_rel_pos[MBR_MAX_N];
	/* 饯Υޥå׾кɸ (Υ󥫡) */
	pos_t	chr_abs_pos[MBR_MAX_N];
	/* 饯Υޥå׾кɸ (̥󥫡) */
	pos_t	chr_ind_pos[MBR_MAX_N];
	/* ƥ饯Υ󥫡ɸ */
	pos_t	chr_map_pos[MBR_MAX_N];
	/* ƥ饯1Υ󥫡ɸ */
	pos_t	chr_pre_pos[MBR_MAX_N];
} square_t;

/* ѡƥ */

typedef struct {
	mbr_t	*mbr[MBR_MAX_N];	/* С */
	square_t	square;	/* 󥫡 */
	flg_party_t	flg;	/* ե饰 */
	act_t	act;	/* ѡƥΤΥ */
} party_t;

#endif	/* PARTY_H */
