/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: scene.c,v 1.16 2009/01/04 00:24:52 bowkenken Exp $
***************************************************************/

/***************************************************************
* ڤؤ
***************************************************************/

#define	SCENE_C
#include	"inc.h"

/***************************************************************
* ѿ
***************************************************************/

static scene_n_t	scene_n;
static last_scene_n_t	last_scene_n;

/***************************************************************
* ν
***************************************************************/

void	init_scene( void )
{
	scene_n = SCENE_N_NULL;
	last_scene_n = LAST_SCENE_N_NULL;
}

/***************************************************************
* ƥåѿꥻå
***************************************************************/

void	reset_static_scene( void )
{
}

/***************************************************************
* ˱ƥڤؤ
***************************************************************/

void	chk_change_scene( void )
{
	switch( scene_n ){
	case SCENE_N_NULL:
		break;
	case SCENE_N_INIT:
	case SCENE_N_TITLE:
	case SCENE_N_OPENING:
		break;
	case SCENE_N_TOWN:
		chk_change_scene_town();
		break;
	case SCENE_N_SHOP:
		break;
	case SCENE_N_DUN:
		chk_change_scene_dun();
		break;
	case SCENE_N_BATTLE:
		chk_change_scene_battle();
		break;
	case SCENE_N_BATTLE_BOSS:
		chk_change_scene_battle_boss();
		break;
	case SCENE_N_LAST_BOSS:
		break;
	case SCENE_N_GAME_OVER:
	case SCENE_N_GAME_OVER_WAIT:
	case SCENE_N_GAME_OVER_END:
	case SCENE_N_ENDING:
	case SCENE_N_ENDING_EPILOGUE:
	case SCENE_N_ENDING_SPACE:
	case SCENE_N_ENDING_STAFF_ROLL:
	case SCENE_N_ENDING_END:
	case SCENE_N_SEL_MBR_GRAPH:
		break;
	case SCENE_N_MAX_N:
		break;
	}
}

/***************************************************************
* ˱ƥڤؤ ()
***************************************************************/

void	chk_change_scene_town( void )
{
	chk_change_scene_dun();
}

/***************************************************************
* ˱ƥڤؤ (µ)
***************************************************************/

void	chk_change_scene_dun( void )
{
	if( scene_srch_boss() ){
		change_scene( SCENE_N_BATTLE_BOSS );
		return;
	}

	if( scene_srch_battle() ){
		change_scene( SCENE_N_BATTLE );
		return;
	}
}

/***************************************************************
* ˱ƥڤؤ (Ʈ)
***************************************************************/

void	chk_change_scene_battle( void )
{
	dun_t	*dun;

	if( scene_n != SCENE_N_BATTLE )
		return;
	if( scene_srch_battle() )
		return;

	/* Ʈλ */

	dun = get_dun();
	if( dun->lev == 0 )
		change_scene( SCENE_N_TOWN );
	else
		change_scene( SCENE_N_DUN );
}

/***************************************************************
* ˱ƥڤؤ (ܥ)
***************************************************************/

void	chk_change_scene_battle_boss( void )
{
	dun_t	*dun;

	if( scene_n != SCENE_N_BATTLE_BOSS )
		return;
	if( scene_srch_boss() )
		return;

	/* ܥ郎λ */

	dun = get_dun();
	if( dun->lev == 0 )
		change_scene( SCENE_N_TOWN );
	else
		change_scene( SCENE_N_DUN );
}

/***************************************************************
* ܥ椫Ĵ٤
* return : ܥ椫?
***************************************************************/

bool_t	scene_srch_boss( void )
{
	dun_t	*dun;
	mnstr_t	*mns_head, *mns_p;
	party_t	*pty;

	dun = get_dun();
	if( dun->lev == 0 )
		return FALSE;
	if( (dun->lev % DUN_LEV_BOSS ) != 0 )
		return FALSE;

	pty = get_party();

	/* ܥõ */

	mns_head = get_mnstr_used();
	for( mns_p = mns_head->next->next; mns_p != NULL;
			mns_p = mns_p->next ){
		mnstr_t	*pp;

		pp = mns_p->prev;
		if( pp == mns_head )
			break;

		if( pp->kind != CHR_KIND_MNSTR )
			continue;
		if( pp->mnstr_tab == NULL )
			continue;
		if( !(pp->mnstr_tab->flg_boss) )
			continue;
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( !clip_pos( pp->x, pp->y ) )
			continue;
		if( !chk_flg( dun->map.chr.flg[pp->y][pp->x],
				FLG_MAP_CHR_FIND ) ){
			continue;
		}

		return TRUE;
	}

	return FALSE;
}

/***************************************************************
* Ʈ椫Ĵ٤
* return : ܥ椫?
***************************************************************/

bool_t	scene_srch_battle( void )
{
	party_t	*pty;
	long	i;

	/* ƮΥС뤫õ */

	pty = get_party();
	for( i = 0; i < MBR_MAX_N; i++ ){
		mbr_t	*pp;

		pp = pty->mbr[i];

		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( pp->trgt.kind != TRGT_KIND_MNSTR )
			if( pp->trgt.kind != TRGT_KIND_MNSTR_NULL )
				continue;
		if( pp->act.kind != ACT_KIND_MNSTR_FIGHT )
			if( pp->act.kind != ACT_KIND_MNSTR_THROW )
				continue;

		return TRUE;
	}

	return FALSE;
}

/***************************************************************
* ڤؤ
***************************************************************/

scene_n_t	change_scene( scene_n_t n )
{
	if( n <= SCENE_N_NULL )
		return SCENE_N_NULL;
	if( n >= SCENE_N_MAX_N )
		return SCENE_N_NULL;

	scene_n = n;

	call_game_music_play_scene();

	return scene_n;
}

/***************************************************************
* ֤
***************************************************************/

scene_n_t	get_scene( void )
{
	return scene_n;
}

/***************************************************************
* 饹ܥΥڤؤ
***************************************************************/

last_scene_n_t	change_last_scene( last_scene_n_t n )
{
	if( n < LAST_SCENE_N_NULL )
		return LAST_SCENE_N_NULL;
	if( n >= LAST_SCENE_N_MAX_N )
		return LAST_SCENE_N_NULL;

	scene_n = SCENE_N_LAST_BOSS;
	last_scene_n = n;

	call_demo_last_boss_reset();
	call_game_music_play_scene();

	return last_scene_n;
}

/***************************************************************
* 饹ܥΥ֤
***************************************************************/

last_scene_n_t	get_last_scene( void )
{
	return last_scene_n;
}

/***************************************************************
* ߤΥ󤬻Υ롼פɤĴ٤
***************************************************************/

bool_t	chk_scene_group( scene_group_n_t group_n )
{
	switch( scene_n ){
	case SCENE_N_NULL:
		if( group_n == SCENE_GROUP_N_NULL )
			return TRUE;
		if( group_n == SCENE_GROUP_N_INIT )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_INIT:
		if( group_n == SCENE_GROUP_N_INIT )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_TITLE:
		if( group_n == SCENE_GROUP_N_TITLE )
			return TRUE;
		if( group_n == SCENE_GROUP_N_DEMO )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_OPENING:
		if( group_n == SCENE_GROUP_N_DEMO )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_SKIP )
			return TRUE;
		break;
	case SCENE_N_TOWN:
		if( group_n == SCENE_GROUP_N_PLAYING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_SHOP:
		if( group_n == SCENE_GROUP_N_PLAYING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_DUN:
		if( group_n == SCENE_GROUP_N_PLAYING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_BATTLE:
		if( group_n == SCENE_GROUP_N_PLAYING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_BATTLE )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_BATTLE_BOSS:
		if( group_n == SCENE_GROUP_N_PLAYING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_BATTLE )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_LAST_BOSS:
		if( group_n == SCENE_GROUP_N_PLAYING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_BATTLE )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_GAME_OVER:
		if( group_n == SCENE_GROUP_N_GAME_OVER )
			return TRUE;
		if( group_n == SCENE_GROUP_N_GAME_END )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_GAME_OVER_WAIT:
		if( group_n == SCENE_GROUP_N_GAME_OVER )
			return TRUE;
		if( group_n == SCENE_GROUP_N_GAME_END )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_GAME_OVER_END:
		if( group_n == SCENE_GROUP_N_GAME_OVER )
			return TRUE;
		if( group_n == SCENE_GROUP_N_GAME_END )
			return TRUE;
		if( group_n == SCENE_GROUP_N_DEMO )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_SKIP )
			return TRUE;
		break;
	case SCENE_N_ENDING:
		if( group_n == SCENE_GROUP_N_ENDING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_DEMO )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_ENDING_EPILOGUE:
		if( group_n == SCENE_GROUP_N_ENDING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_DEMO )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_ENDING_SPACE:
		if( group_n == SCENE_GROUP_N_ENDING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_DEMO )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_ENDING_STAFF_ROLL:
		if( group_n == SCENE_GROUP_N_ENDING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_DEMO )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_NOT_SKIP )
			return TRUE;
		break;
	case SCENE_N_ENDING_END:
		if( group_n == SCENE_GROUP_N_ENDING )
			return TRUE;
		if( group_n == SCENE_GROUP_N_GAME_END )
			return TRUE;
		if( group_n == SCENE_GROUP_N_DEMO )
			return TRUE;
		if( group_n == SCENE_GROUP_N_CAN_SKIP )
			return TRUE;
		break;
	case SCENE_N_SEL_MBR_GRAPH:
		if( group_n == SCENE_GROUP_N_SEL_GRAPH )
			return TRUE;
		break;
	case SCENE_N_MAX_N:
		break;
	}

	return FALSE;
}
