/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: DemoCutIn.cpp,v 1.3 2008/10/07 02:34:44 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// åȥ󡦥ǥ
////////////////////////////////////////////////////////////////

#define DEMO_CUT_IN_CPP
#include "inc.h"

////////////////////////////////////////////////////////////////

// åȥΥǥ쥯ȥ
#define STR_CUT_IN_DIR_NAME	"cut_in/"

////////////////////////////////////////////////////////////////
// 󥹥ȥ饯
////////////////////////////////////////////////////////////////

DemoCutIn::DemoCutIn()
{
	nFileSelN = 0;
	nFileMaxN = 0;

	rateBgnX = (rate_t)0;
	rateBgnY = (rate_t)0;
	rateEndX = (rate_t)0;
	rateEndY = (rate_t)0;
}

////////////////////////////////////////////////////////////////
// ǥȥ饯
////////////////////////////////////////////////////////////////

DemoCutIn::~DemoCutIn()
{
}

////////////////////////////////////////////////////////////////
// 
// WSCstring dirName : Υǥ쥯ȥ̾
////////////////////////////////////////////////////////////////

void DemoCutIn::init( WSCstring dirName )
{
	// åȥθ

	WSCstring dir = STR_DEFAULT_GRAPH_DIR_NAME;
	WSCstring ext = STR_GRAPH_FILE_EXT;
	WSCstring pcgPath = FileList::jointDir(
			STR_CUT_IN_DIR_NAME, dirName );

	FileList::setStrDirSelGraph( dir );
	FileList ls;

	// åȥ򸡺

	{
		nFileMaxN = 0;

		ls.reset( pcgPath, ext );
		long j = 0;
		for( j = 0; j < LOOP_MAX_1000; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
		}

		nFileMaxN = j;
	}

	// åȥ

	if( nFileMaxN > 0 )
		nFileSelN = randm( nFileMaxN );
	else
		nFileSelN = -1;

	// åȥɤ߹

	if( nFileSelN > -1 ){
		ls.reset( pcgPath, ext );
		long j = 0;
		for( j = 0; j < LOOP_MAX_1000; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			if( j == nFileSelN ){
				pcg.init( path );
				break;
			}
		}
	}
}

////////////////////////////////////////////////////////////////
// åȥ󳫻ϡλɸ
// rate_t bx :  X ɸΨ
// rate_t by :  Y ɸΨ
// rate_t ex : λ X ɸΨ
// rate_t ey : λ Y ɸΨ
////////////////////////////////////////////////////////////////

void DemoCutIn::setPos( rate_t bx, rate_t by, rate_t ex, rate_t ey )
{
	rateBgnX = bx;
	rateBgnY = by;
	rateEndX = ex;
	rateEndY = ey;
}

////////////////////////////////////////////////////////////////
// åȥ
// long frame : ߤΥե졼
// long maxFrame : λե졼
// return : 顼̵ä?
////////////////////////////////////////////////////////////////

bool DemoCutIn::drawCutIn( long frame, long maxFrame )
{
	return draw( frame, maxFrame, true );
}

////////////////////////////////////////////////////////////////
// åȥȤ
// long frame : ߤΥե졼
// long maxFrame : λե졼
// return : 顼̵ä?
////////////////////////////////////////////////////////////////

bool DemoCutIn::drawCutOut( long frame, long maxFrame )
{
	return draw( frame, maxFrame, false );
}

////////////////////////////////////////////////////////////////
// åȥ󡿥Ȥ
// long frame : ߤΥե졼
// long maxFrame : λե졼
// return : 顼̵ä?
////////////////////////////////////////////////////////////////

bool DemoCutIn::draw( long frame, long maxFrame, bool flagCutIn )
{
	if( frame < 0 )
		frame = 0;
	if( frame > maxFrame )
		frame = maxFrame;

	if( !flagCutIn )
		frame = maxFrame - frame;

	long x = gPcgDun.getScrollBarX();
	long y = gPcgDun.getScrollBarY();
	long w = gPcgDun.getScrollBarW();
	long h = gPcgDun.getScrollBarH();

	long pcgW = pcg.getWidth();
	long pcgH = pcg.getHeight();
	rate_t rateX = ((rateEndX - rateBgnX) * frame / maxFrame)
			+ rateBgnX;
	rate_t rateY = ((rateEndY - rateBgnY) * frame / maxFrame)
			+ rateBgnY;
	long xx = ((w / 2) * rateX / _100_PERCENT) + ((w - pcgW) / 2);
	long yy = ((h / 2) * rateY / _100_PERCENT) + ((h - pcgH) / 2);
	xx += x;
	yy += y;

	return pcg.draw( gPcgDun.getWBuf(), xx, yy, pcgW, pcgH );
}
