/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: SelMbrGraph.h,v 1.3 2008/05/13 06:21:21 bowkenken Exp $
***************************************************************/

#ifndef SEL_MBR_GRAPH_H
#define SEL_MBR_GRAPH_H	1

////////////////////////////////////////////////////////////////
// СΥեåѥ
////////////////////////////////////////////////////////////////

#include "misc.h"
#include "party.h"
#include "scene.h"
#include "scene-prot.h"

#include "PcgDun.h"

#ifdef D_WS
# include <WSCstring.h>
#endif //D_WS

#ifdef D_GTK
# include "GtkWSCstring.h"
#endif //D_GTK

#ifdef D_MFC
# include "MfcWSCstring.h"
#endif //D_MFC

////////////////////////////////////////////////////////////////

class SelMbrGraph {

private:
	static const long nBaseColorR = 0xdddd;
	static const long nBaseColorG = 0xdddd;
	static const long nBaseColorB = 0xdddd;

	static const long nSelColorR = 0x0000;
	static const long nSelColorG = 0xdddd;
	static const long nSelColorB = 0xdddd;

	static const long nHighColorR = 0xffff;
	static const long nHighColorG = 0xffff;
	static const long nHighColorB = 0xffff;

	static const long nLowColorR = 0xbbbb;
	static const long nLowColorG = 0xbbbb;
	static const long nLowColorB = 0xbbbb;

	static const long nSelBorderW = 3;
	static const long nSelBorderH = 3;

	// ΥС
	mbr_t *pMbr;

	// ѥ󡦥ꥹȤƬ
	Pcg *pPtnHead;
	// ѥκ
	long nPtnMaxN;
	// Υѥ󡦥ǥå
	long nPtnSelN;

	// ڤؤΥΥХåå
	scene_n_t nPreScene;
	// ڤؤΥޥåɽɸ
	long nPreMapX;
	long nPreMapY;

	// ѥɽ
	long nSizeX, nSizeY;
	long nSizeMaxX, nSizeMaxY;

	// ѥ̾Υե
#ifdef D_GTK
	GdkFont *font;
#endif // D_GTK

public:
	SelMbrGraph();
	~SelMbrGraph();

	bool exec( mbr_t *mbr );
	long sel( long sx, long sy );
	void ok();
	void cancel();

	void redraw();
	void draw();

private:
	void close();

	void drawAllChr();
	void drawChr(
		long x, long y, long w, long h,
		Pcg *p, bool flagSel );
};

#endif /* SEL_MBR_GRAPH_H */
