/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiMenu.h,v 1.19 2008/08/17 11:51:30 bowkenken Exp $
***************************************************************/

#ifndef GUI_MENU_H
#define GUI_MENU_H	1

////////////////////////////////////////////////////////////////
// GUI ǥ˥塼
////////////////////////////////////////////////////////////////

#ifdef D_WS
# include <WSCvbtn.h>
#endif // D_WS

#ifdef D_GTK
# include <gtk/gtk.h>
#endif // D_GTK

#ifdef D_MFC
# include "xlnl-dows/stdafx.h"
# include "xlnl-dows/xlnl-dows.h"
# include "xlnl-dows/MenuWnd.h"
#endif // D_MFC

#include "misc.h"
#include "menu.h"

////////////////////////////////////////////////////////////////

class GuiMenu {

public:

	enum {
		MOUSE_BUTTON_N_NULL,
		MOUSE_BUTTON_N_LEFT,
		MOUSE_BUTTON_N_MIDDLE,
		MOUSE_BUTTON_N_RIGHT,
		MOUSE_BUTTON_N_MAX_N,
	};

// ץ饤١ȡСѿ
private:

	char cAccelKey[MENU_MAX_N_PER_PAGE];
	bool bFlagSetMouseDfltMenu;

#ifdef D_WS
	WSCvbtn *aBtnMenu[MENU_MAX_N_PER_PAGE];
#endif // D_WS

#ifdef D_GTK
	GtkWidget *vBox;
	GtkWidget *aBtnMenu[MENU_MAX_N_PER_PAGE];
	GtkWidget *btnMenuPrevPage;
	GtkWidget *btnMenuNextPage;
	GtkWidget *btnMenuCancel;
	GtkWidget *btnMenuCancelAll;
	GtkWidget *labelMenuPageN;
#endif // D_GTK

#ifdef D_MFC
	CButton *aBtnMenu[MENU_MAX_N_PER_PAGE + 1];
#endif // D_WS

// ѥ֥åСѿ
public:

#ifdef D_WS
	void *mMenuWin;
#endif // D_WS

#ifdef D_GTK
	GtkWidget *mMenuWin;
	long nClickedButton;
	gboolean bFlagEnter;
#endif // D_GTK

#ifdef D_MFC
	CMenuWnd *mMenuWin;
#endif // D_WS

// ѥ֥åСؿ
public:

	GuiMenu();
	~GuiMenu();
	void init();
	void destroy();

	void draw( draw_menu_t *data );
	void wipe();

	void setMouseDfltMenu( long sel_n );

	char getAccelKey( long n );

// ץ饤١ȡСؿ
private:
	void newWin();
};

#endif /* GUI_MENU_H */
