/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: call.cpp,v 1.40 2007/06/07 16:38:53 bowkenken Exp $
***************************************************************/

#define	CALL_CPP
#include	"inc.h"

#ifdef D_WS
extern WSCwindow *StatWin;
#endif

/***************************************************************
* ᥤ󡦥롼פΥåɤڤ
* void *(*func)( void * ) : 롦Хåؿ
* return : 顼̵ä
***************************************************************/

bool_t	call_game_thread_create( void *(*func)( void * ) )
{
#ifdef D_WS
	if( GameThreadCreate( func ) )
		return TRUE;
	else
		return FALSE;
#endif // D_WS

#ifdef D_GTK
	if( GameThreadCreate( func ) )
		return TRUE;
	else
		return FALSE;
#endif // D_GTK

	return TRUE;
}

/***************************************************************
* ޥåסɥϢ³¹ԥܥΥå
* bool_t flagExec : 
***************************************************************/

void	call_gui_map_cont_exec_set( bool_t flagExec )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON( gMapButtonContExec ),
			flagExec );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ˥塼ɥ
* draw_menu_t *data : ˥塼ѥǡ
***************************************************************/

void	call_gui_menu_draw( draw_menu_t *data )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiMenu.draw( data );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMenu.draw( data );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ˥塼ɥĤ
***************************************************************/

void	call_gui_menu_wipe( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiMenu.wipe();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMenu.wipe();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ǥեȤܤ˥ޥư
* long sel_n : 
***************************************************************/

void	call_set_mouse_dflt_menu( long sel_n )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiMenu.setMouseDfltMenu( sel_n );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMenu.setMouseDfltMenu( sel_n );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* å³ޡ
***************************************************************/

void	call_gui_message_set_flag_more( bool_t flag )
{
#ifdef D_WS
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMessage.setFlagMore( flag );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* åɥ
***************************************************************/

void	call_gui_message_draw( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

//@@@	gGuiMessage.draw();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMessage.draw( false );
	gGuiMessage.drawScrollBar();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ϥɥ
***************************************************************/

void	call_gui_num_draw( long *n, long min, long max, long figure )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiNum.draw( n, min, max, figure );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiNum.draw( n, min, max, figure );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ϥɥĤ
***************************************************************/

void	call_gui_num_wipe( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiNum.wipe();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiNum.wipe();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ʸϥɥ
***************************************************************/

void	call_gui_input_string_draw(
	const char *ttl, const char *str, long len
)
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiInpStr.draw( ttl, str, len );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiInpStr.draw( ttl, str, len );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ʸϥɥĤ
***************************************************************/

void	call_gui_input_string_wipe( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiInpStr.wipe();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiInpStr.wipe();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* եåǥ쥯ȥ
***************************************************************/

void	set_str_dir_sel_graph( char *dir )
{
#ifdef D_WS
	setStrDirSelGraph( dir );
#endif // D_WS

#ifdef D_GTK
	setStrDirSelGraph( dir );
#endif // D_GTK
}

/***************************************************************
* եåѥΥꥻå
***************************************************************/

void	call_pcg_dun_reset( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.reset();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
#if 0
//@@@
	if( !g_flg_init )
		return;
#endif
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.reset();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ޥåפιե饰Υꥻå
***************************************************************/

void	call_pcg_dun_reset_update_flg( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.resetUpdateFlg();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.resetUpdateFlg();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* եåѥ
* long map_x : ޥåפ X ɸ
* long map_y : ޥåפ Y ɸ
* long map_w : ޥåפ
* long map_h : ޥåפι⤵
***************************************************************/

void	call_pcg_dun_draw( long map_x, long map_y, long map_w, long map_h )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.draw( map_x, map_y, map_w, map_h );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.draw( map_x, map_y, map_w, map_h );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ޥåפΥ
* long map_x : ޥåפ X ɸ
* long map_y : ޥåפ Y ɸ
***************************************************************/

void	call_pcg_dun_scroll( long map_x, long map_y )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.scrollTile( map_x, map_y );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.scrollTile( map_x, map_y );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* 饯κüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_left( chr_t *chr, bool_t flagPre )
{
#ifdef D_WS
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawLeft( chr, pPcg, flagPre );
	n = n / gPcgDun.getTileSizeX();

	return n;
#endif // D_WS

#ifdef D_GTK
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawLeft( chr, pPcg, flagPre );
	n = n / gPcgDun.getTileSizeX();

	return n;
#endif // D_GTK

	if( flagPre )
		return get_chr_left( chr->pre_draw_x, chr->dx );
	else
		return get_chr_left( chr->x, chr->dx );
}

/***************************************************************
* 饯αüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_right( chr_t *chr, bool_t flagPre )
{
#ifdef D_WS
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawRight( chr, pPcg, flagPre );
	n = (n + gPcgDun.getTileSizeX() - 1) / gPcgDun.getTileSizeX();

	return n;
#endif // D_WS

#ifdef D_GTK
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawRight( chr, pPcg, flagPre );
	n = (n + gPcgDun.getTileSizeX() - 1) / gPcgDun.getTileSizeX();

	return n;
#endif // D_GTK

	if( flagPre )
		return get_chr_right( chr->pre_draw_x, chr->dx );
	else
		return get_chr_right( chr->x, chr->dx );
}

/***************************************************************
* 饯ξüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_top( chr_t *chr, bool_t flagPre )
{
#ifdef D_WS
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawTop( chr, pPcg, flagPre );
	n = n / gPcgDun.getTileSizeY();

	return n;
#endif // D_WS

#ifdef D_GTK
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawTop( chr, pPcg, flagPre );
	n = n / gPcgDun.getTileSizeY();

	return n;
#endif // D_GTK

	if( flagPre )
		return get_chr_top( chr->pre_draw_y, chr->dy );
	else
		return get_chr_top( chr->y, chr->dy );
}

/***************************************************************
* 饯βüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_bottom( chr_t *chr, bool_t flagPre )
{
#ifdef D_WS
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawBottom( chr, pPcg, flagPre );
	n = (n + gPcgDun.getTileSizeY() - 1) / gPcgDun.getTileSizeY();

	return n;
#endif // D_WS

#ifdef D_GTK
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawBottom( chr, pPcg, flagPre );
	n = (n + gPcgDun.getTileSizeY() - 1) / gPcgDun.getTileSizeY();

	return n;
#endif // D_GTK

	if( flagPre )
		return get_chr_bottom( chr->pre_draw_y, chr->dy );
	else
		return get_chr_bottom( chr->y, chr->dy );
}

/***************************************************************
* ɸޥåסɥɽϰ⤫Ĵ٤
* long mapX : Xɸ
* long mapY : Yɸ
* return : ޥåסɥɽϰ⤫?
***************************************************************/

bool_t	call_pcg_dun_clip_win( long mapX, long mapY )
{
#ifdef D_GTK
	return gPcgDun.clipWin( mapX, mapY );
#endif // D_GTK

	return true;
}

/***************************************************************
*  X ɸޥåסɥɽϰ⤫Ĵ٤
* long mapX : Xɸ
* return : ޥåסɥɽϰ⤫?
***************************************************************/

bool_t	call_pcg_dun_clip_win_x( long mapX )
{
#ifdef D_GTK
	return gPcgDun.clipWinX( mapX );
#endif // D_GTK

	return true;
}

/***************************************************************
*  Y ɸޥåסɥɽϰ⤫Ĵ٤
* long mapY : Yɸ
* return : ޥåסɥɽϰ⤫?
***************************************************************/

bool_t	call_pcg_dun_clip_win_y( long mapY )
{
#ifdef D_GTK
	return gPcgDun.clipWinY( mapY );
#endif // D_GTK

	return true;
}

/***************************************************************
* ơɥ
***************************************************************/

void	call_stat_win_redraw( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	StatWin->redraw();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiStat.redraw();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ʸ
* return : Ϥ줿
***************************************************************/

long	call_key_get_char( void )
{
	long	c = '\0';

#ifdef D_WS
	if( !g_flg_init )
		return c;
	if( !g_flg_gui )
		return c;

	WSGIappDev()->lock();

	c = gKey.getChar();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return c;
	if( !g_flg_gui )
		return c;

	gdk_threads_enter();

	c = gKey.getChar();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

	return c;
}
